﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class test : MonoBehaviour
{
    public CanvasManager3D CM;

    public List<Line> lines;
    public float width = 1.0f;

    Mesh mesh;
    // Start is called before the first frame update
    void Start()
    {

    }

    // Update is called once per frame
    void Update()
    {
        if(lines.Count != 0)
        {
            Vector3[] vertices = new Vector3[lines.Count * 4];
            Vector3 offset = Camera.main.transform.up * width;

            int k = 0;
            foreach (Line l in lines)
            {
                Vector3 tmp1 = new Vector3(l.point1.x, l.point1.y, l.point1.z);
                Vector3 tmp2 = new Vector3(l.point2.x, l.point2.y, l.point2.z);
                vertices[k] = tmp1 + offset;
                vertices[k + 1] = tmp1 - offset;
                vertices[k + 2] = tmp2 + offset;
                vertices[k + 3] = tmp2 - offset;
                k += 4;
            }
            mesh.vertices = vertices;

            int[] triangles = new int[lines.Count * 6];
            for (int i = 0; i < lines.Count; i++)
            {
                triangles[6 * i] = 4 * i;
                triangles[6 * i + 1] = 4 * i + 1;
                triangles[6 * i + 2] = 4 * i + 2;
                triangles[6 * i + 3] = 4 * i + 1;
                triangles[6 * i + 4] = 4 * i + 3;
                triangles[6 * i + 5] = 4 * i + 2;
            }
            mesh.SetIndices(triangles, MeshTopology.Triangles, 0);
        }
        else
        {
            lines = CM.GetLines();
        }
    }
}
