﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Plane
{
    List<Point> points;
    public Vector3 normal;

    public Plane(List<Point> ps)
    {
        points = new List<Point>();
        foreach(Point p in ps)
        {
            points.Add(p);
        }

        updateNormal();
    }

    public void updateNormal()
    {
        List<Vector3> vector3s = new List<Vector3>();
        for (int i = 1; i < points.Count; ++i)
        {
            Vector3 tmp = new Vector3(points[i].x - points[0].x, points[i].y - points[0].y, points[i].z - points[0].z);
            vector3s.Add(tmp);
        }

        List<Vector3> normals = new List<Vector3>();
        for (int i = 0; i < vector3s.Count; ++i)
        {
            for (int j = i + 1; j < vector3s.Count; ++j)
            {
                Vector3 tmp = Vector3.Cross(vector3s[i], vector3s[j]).normalized;
                if (tmp.magnitude != 0)
                    normals.Add(tmp);
            }
        }

        bool flag = true;
        for (int i = 1; i < normals.Count; ++i)
        {
            if (normals[i - 1] != normals[i] && normals[i - 1] != -normals[i])
            {
                flag = false;
                break;
            }
        }
        if (flag)
        {
            normal = normals[0];
        }
        else
        {
            Debug.Log("wrong plane");
        }
    }
}
