﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Line
{
    public Point point1;
    public Point point2;
    public Vector3 direction;

    public State lineState = State.unknown;

    public Line(Point p1, Point p2)
    {
        point1 = p1;
        point2 = p2;
        direction = new Vector3(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z).normalized;
    }

    public float getLength()
    {
        return new Vector3(point2.x - point1.x, point2.y - point1.y, point2.z - point1.z).magnitude;
    }

    public void updateDirection()
    {
        direction = new Vector3(point2.x - point1.x, point2.y - point1.y, point2.z - point1.z).normalized;
        if (point1.getState() == State.confirm)
        {
            if (point2.getState() == State.confirm)
                lineState = State.confirm;
            else
                lineState = State.halfconfirm;
        }
        else if (point2.getState() == State.confirm)
            lineState = State.halfconfirm;
        else
            lineState = State.unknown;
    }

    public Vector3 getDirection(Point p)
    {
        Point tmp = getAnotherPoint(p);
        return new Vector3(p.x - tmp.x, p.y - tmp.y, p.z - tmp.z).normalized;
    }

    public Point getAnotherPoint(Point p)
    {
        if (p.name.Equals(point1.name))
            return point2;
        else if (p.name.Equals(point2.name))
            return point1;
        else
            return null;
    }

    public Gradient getGradient()
    {
        if(point2.getState() > point1.getState())
        {
            Vector3 tmp =  new Vector3(2 * point2.x - 2 * point1.x, 2 * point2.y - 2 * point1.y, 2 * point2.z - 2 * point1.z);
            return new Gradient(point2, tmp);
        }
        else
        {
            Vector3 tmp = new Vector3(2 * point1.x - 2 * point2.x, 2 * point1.y - 2 * point2.y, 2 * point1.z - 2 * point2.z);
            return new Gradient(point1, tmp);
        }
    }

    public void setConstraint(Constraint c)
    {
        point1.constraints.Add(c);
        point2.constraints.Add(c);
    }

}
