﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Gradient
{
    public Point targetpoint;

    public Vector3 gradient;

    public Gradient(Point p, Vector3 g)
    {
        targetpoint = p;
        gradient = g;
    }

    public Vector3 calculateGradient(float value)
    {
        Vector3 result = new Vector3(gradientLevel(gradient.x), gradientLevel(gradient.y), gradientLevel(gradient.z));

        if (value > 0)
        {
            if (gradient.x > 0)
                result.x *= -1;
            if (gradient.y > 0)
                result.y *= -1;
            if (gradient.z > 0)
                result.z *= -1;
        }
        else
        {
            if (gradient.x < 0)
                result.x *= -1;
            if (gradient.y < 0)
                result.y *= -1;
            if (gradient.z < 0)
                result.z *= -1;
        }

        result += new Vector3(Random.Range(0, result.x), Random.Range(0, result.y), Random.Range(0, result.z));
        return result;
    }

    public float gradientLevel(float input)
    {
        if (Mathf.Abs(input) < 0.1f)
            return 0.0001f;
        if (Mathf.Abs(input) < 1)
            return 0.001f;
        if (Mathf.Abs(input) < 10)
            return 0.01f;
        if (Mathf.Abs(input) < 100)
            return 0.1f;
        return 1;
    }
}
