/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine.recorder;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import cn.easyar.engine.recorder.Muxer;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=18)
public class VideoEncoderCore {
    private static final String TAG = "EasyAR";
    private static final boolean DEBUG = false;
    private static final String MIME_TYPE = "video/avc";
    private static final int FRAME_RATE = 30;
    private static final int IFRAME_INTERVAL = 5;
    private Surface mInputSurface;
    private Muxer mMuxer;
    private MediaCodec mEncoder;
    private MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
    private int mTrackIndex;

    public VideoEncoderCore(int width, int height, int bitRate, Muxer muxer) throws IOException {
        MediaFormat format = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)width, (int)height);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", bitRate);
        format.setInteger("frame-rate", 30);
        format.setInteger("i-frame-interval", 5);
        int width_t = format.getInteger("width");
        int height_t = format.getInteger("height");
        this.mEncoder = MediaCodec.createEncoderByType((String)MIME_TYPE);
        this.mEncoder.configure(format, null, null, 1);
        this.mInputSurface = this.mEncoder.createInputSurface();
        this.mEncoder.start();
        this.mMuxer = muxer;
        this.mTrackIndex = -1;
    }

    public Surface getInputSurface() {
        return this.mInputSurface;
    }

    public void release() {
        if (this.mEncoder != null) {
            this.mEncoder.stop();
            this.mEncoder.release();
            this.mEncoder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainEncoder(boolean endOfStream) {
        int TIMEOUT_USEC = 10000;
        Muxer muxer = this.mMuxer;
        synchronized (muxer) {
            block23: {
                if (endOfStream) {
                    this.mEncoder.signalEndOfInputStream();
                }
                if (!this.mMuxer.isStarted()) {
                    if (endOfStream) {
                        if (!this.mMuxer.endBeforeStart()) {
                            this.mMuxer.endBeforeStart(true);
                        } else {
                            this.mMuxer.release(false);
                        }
                        return;
                    }
                    if (this.mMuxer.endBeforeStart()) {
                        return;
                    }
                }
                ByteBuffer[] encoderOutputBuffers = this.mEncoder.getOutputBuffers();
                while (true) {
                    int encoderStatus;
                    if ((encoderStatus = this.mEncoder.dequeueOutputBuffer(this.mBufferInfo, 10000L)) == -1) {
                        if (endOfStream) continue;
                        break block23;
                    }
                    if (encoderStatus == -3) {
                        encoderOutputBuffers = this.mEncoder.getOutputBuffers();
                        continue;
                    }
                    if (encoderStatus == -2) {
                        if (this.mMuxer.isStarted()) {
                            throw new RuntimeException("format changed twice");
                        }
                        MediaFormat newFormat = this.mEncoder.getOutputFormat();
                        this.mTrackIndex = this.mMuxer.addTrack(newFormat);
                        continue;
                    }
                    if (encoderStatus < 0) continue;
                    ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
                    if (encodedData == null) {
                        throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                    }
                    if ((this.mBufferInfo.flags & 2) != 0) {
                        this.mBufferInfo.size = 0;
                    }
                    if (this.mBufferInfo.size != 0) {
                        if (!this.mMuxer.isStarted()) {
                            // empty if block
                        }
                        encodedData.position(this.mBufferInfo.offset);
                        encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
                        if (endOfStream) {
                            this.mBufferInfo.flags |= 4;
                        }
                        if (this.mMuxer.isStarted()) {
                            this.mMuxer.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                        }
                    } else if ((this.mBufferInfo.flags & 4) != 0 && this.mMuxer.isStarted()) {
                        this.mMuxer.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                    }
                    this.mEncoder.releaseOutputBuffer(encoderStatus, false);
                    if ((this.mBufferInfo.flags & 4) != 0) break;
                }
                if (endOfStream) {
                    // empty if block
                }
            }
        }
    }
}

