/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine.recorder;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLException;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import cn.easyar.engine.recorder.AVRecorderConfig;
import cn.easyar.engine.recorder.RecordNative;
import cn.easyar.engine.recorder.VideoEncoderCore;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.IntBuffer;

@TargetApi(value=17)
public class TextureMovieEncoder
implements Runnable {
    private static final String TAG = "easyar.TextureEncoder";
    private static final boolean VERBOSE = false;
    private static final int MSG_STOP_RECORDING = 1;
    private static final int MSG_FRAME_AVAILABLE = 2;
    private VideoEncoderCore mVideoEncoder;
    private volatile EncoderHandler mHandler;
    private Object mReadyFence = new Object();
    private volatile boolean mReady = false;
    private DeviceType mDeviceType;
    private int[] texWaterMark = new int[1];
    private int[] mSurfaceWidth = new int[1];
    private int[] mSurfaceHeight = new int[1];
    private AVRecorderConfig config;
    private RecordNative aNative;
    Handler vHandler;
    Runnable run;
    private int number = 0;

    public void setDeviceType() {
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        this.mDeviceType = model.toLowerCase().equals("c6602") ? DeviceType.Sony_Z1 : (model.toLowerCase().equals("HUAWEI P7-L07") ? DeviceType.HUAWEI_P7 : (model.toLowerCase().equals("iph") ? DeviceType.IPH : DeviceType.Default));
    }

    public TextureMovieEncoder(AVRecorderConfig mAVRecorderConfig) throws RuntimeException {
        this.config = mAVRecorderConfig;
        this.mSurfaceHeight[0] = 0;
        this.mSurfaceWidth[0] = 0;
        this.texWaterMark[0] = 0;
        try {
            int video_width;
            int video_height;
            if (mAVRecorderConfig.getRotationClip()) {
                video_height = mAVRecorderConfig.getWidth();
                video_width = mAVRecorderConfig.getHeight();
            } else {
                video_width = mAVRecorderConfig.getWidth();
                video_height = mAVRecorderConfig.getHeight();
            }
            this.mVideoEncoder = new VideoEncoderCore(video_width, video_height, mAVRecorderConfig.getVideoBitRate(), mAVRecorderConfig.getMuxer());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        try {
            this.aNative = new RecordNative(this.mVideoEncoder.getInputSurface(), this.config.getTextureWidth(), this.config.getTextureHeight(), this.config.getZoomMode());
        }
        catch (Exception e) {
            this.mVideoEncoder.release();
            throw new RuntimeException("ReccordNative init failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording() {
        Object object = this.mReadyFence;
        synchronized (object) {
            new Thread((Runnable)this, "TextureMovieEncoder").start();
            while (!this.mReady) {
                try {
                    this.mReadyFence.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private Bitmap createBitmapFromGLSurface(int x, int y, int w, int h) {
        int[] bitmapBuffer = new int[w * h];
        int[] bitmapSource = new int[w * h];
        IntBuffer intBuffer = IntBuffer.wrap(bitmapBuffer);
        intBuffer.position(0);
        try {
            GLES20.glReadPixels((int)x, (int)y, (int)w, (int)h, (int)6408, (int)5121, (Buffer)intBuffer);
            for (int i = 0; i < h; ++i) {
                int offset1 = i * w;
                int offset2 = (h - i - 1) * w;
                for (int j = 0; j < w; ++j) {
                    int pixel;
                    int texturePixel = bitmapBuffer[offset1 + j];
                    int blue = texturePixel >> 16 & 0xFF;
                    int red = texturePixel << 16 & 0xFF0000;
                    bitmapSource[offset2 + j] = pixel = texturePixel & 0xFF00FF00 | red | blue;
                }
            }
        }
        catch (GLException e) {
            return null;
        }
        return Bitmap.createBitmap((int[])bitmapSource, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    private void saveBitmap(Bitmap bitmap) {
        File f = new File("/sdcard/easyar3d/video/", "" + this.number + ".png");
        try {
            f.createNewFile();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)bos);
            byte[] bitmapdata = bos.toByteArray();
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(bitmapdata);
            fos.flush();
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateRecording(int aTexName) {
        long timeStampNanos = System.nanoTime();
        this.frameAvailableSoon();
        try {
            GLES20.glFinish();
            this.aNative.updateRecord(aTexName, timeStampNanos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateRecording(int aTexName, int texWidth, int texHeight) {
        long timeStampNanos = System.nanoTime();
        this.frameAvailableSoon();
        int width = this.aNative.nativeWidth();
        int height = this.aNative.nativeHeight();
        ++this.number;
        if (this.number < 0) {
            Bitmap bitmap = this.createBitmapFromGLSurface(0, 0, 1280, 720);
            this.saveBitmap(bitmap);
            bitmap.recycle();
        }
        ++this.number;
        try {
            GLES20.glFinish();
            this.aNative.updateRecord(aTexName, texWidth, texHeight, timeStampNanos);
            if (this.number < 0) {
                Bitmap bitmap1 = this.createBitmapFromGLSurface(0, 0, 1280, 720);
                this.saveBitmap(bitmap1);
                bitmap1.recycle();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void Assert(boolean judge, String st) {
        if (!judge) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording(Handler viewHandler, Runnable r) {
        this.Assert(this.mReady, "stopRecording: mReady");
        this.vHandler = viewHandler;
        this.run = r;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        Object object = this.mReadyFence;
        synchronized (object) {
            while (this.mReady) {
                try {
                    this.mReadyFence.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.aNative.release();
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.release();
            this.mVideoEncoder = null;
        }
        this.vHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameAvailableSoon() {
        Object object = this.mReadyFence;
        synchronized (object) {
            if (!this.mReady) {
                return;
            }
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Looper.prepare();
        Object object = this.mReadyFence;
        synchronized (object) {
            this.mHandler = new EncoderHandler(this);
            this.mReady = true;
            this.mReadyFence.notify();
        }
        Looper.loop();
        object = this.mReadyFence;
        synchronized (object) {
            this.mHandler = null;
        }
    }

    private void handleFrameAvailable() {
        this.mVideoEncoder.drainEncoder(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStopRecording() {
        this.mVideoEncoder.drainEncoder(true);
        Object object = this.mReadyFence;
        synchronized (object) {
            this.mReady = false;
            this.mReadyFence.notify();
        }
    }

    private static class EncoderHandler
    extends Handler {
        private WeakReference<TextureMovieEncoder> mWeakEncoder;

        public EncoderHandler(TextureMovieEncoder encoder) {
            this.mWeakEncoder = new WeakReference<TextureMovieEncoder>(encoder);
        }

        public void handleMessage(Message inputMessage) {
            int what = inputMessage.what;
            Object obj = inputMessage.obj;
            TextureMovieEncoder encoder = (TextureMovieEncoder)this.mWeakEncoder.get();
            if (encoder == null) {
                return;
            }
            switch (what) {
                case 1: {
                    encoder.handleStopRecording();
                    Looper.myLooper().quit();
                    break;
                }
                case 2: {
                    encoder.handleFrameAvailable();
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled msg what=" + what);
                }
            }
        }
    }

    public static enum DeviceType {
        Default,
        Sony_Z1,
        HUAWEI_P7,
        IPH,
        UnKnown;

    }
}

