/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine.recorder;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.media.CamcorderProfile;
import android.os.Build;
import android.os.Handler;
import cn.easyar.engine.EasyAR;
import cn.easyar.engine.PermissionFragment;
import cn.easyar.engine.recorder.AVRecorderConfig;
import cn.easyar.engine.recorder.AudioEncorderConfig;
import cn.easyar.engine.recorder.MicroPhoneEncoder;
import cn.easyar.engine.recorder.RecordListener;
import cn.easyar.engine.recorder.TextureMovieEncoder;
import cn.easyar.engine.recorder.VideoEncoderConfig;
import java.io.IOException;
import java.util.ArrayList;

public class SessionRecorder {
    private static String TAG = "EasyAR";
    private TextureMovieEncoder mTexture2Video;
    private MicroPhoneEncoder mMicroPhoneEncoder;
    private AVRecorderConfig mAVRecorderConfig;
    private long nativeId;
    private RecordListener mListener;
    Handler mHandler;
    int width;
    int height;
    int videoBitrate;
    int audioChannelCount;
    int audioBitrate;
    int audioSampleRate;
    int texId;
    int tex_width;
    int tex_height;
    boolean rotationClip;
    String file;
    boolean configUpdated = false;
    int mode;
    static VideoSize systemQuality = VideoSize.Vid720p;

    public void prepareRecording() {
        try {
            this.mAVRecorderConfig = new AVRecorderConfig(new AudioEncorderConfig(this.audioBitrate, this.audioChannelCount, this.audioSampleRate), new VideoEncoderConfig(this.width, this.height, this.tex_width, this.tex_height, this.videoBitrate, this.mode), this.rotationClip, this.file, this.mListener);
        }
        catch (IOException e) {
            this.mListener.onMessage(513, "");
            return;
        }
        try {
            this.mMicroPhoneEncoder = new MicroPhoneEncoder(this.mAVRecorderConfig);
        }
        catch (Exception e) {
            this.mAVRecorderConfig = null;
            this.mListener.onMessage(513, "");
            return;
        }
        try {
            this.mTexture2Video = new TextureMovieEncoder(this.mAVRecorderConfig);
        }
        catch (RuntimeException e) {
            this.mAVRecorderConfig = null;
            this.mMicroPhoneEncoder.releaseRecording();
            this.mMicroPhoneEncoder = null;
            this.mListener.onMessage(513, "");
            return;
        }
    }

    public void startRecording() {
        this.mTexture2Video.startRecording();
        try {
            this.mMicroPhoneEncoder.startRecording();
        }
        catch (IllegalStateException e) {
            this.mTexture2Video.stopRecording(null, null);
            this.mListener.onMessage(514, "startRecording failed due to illegal state");
            return;
        }
        this.mListener.onMessage(2, "");
        this.configUpdated = false;
    }

    public void updateRecording(int texId, int width, int height) {
        if (this.configUpdated) {
            this.mAVRecorderConfig.setTextureHeight(height);
            this.mAVRecorderConfig.setTextureWidth(width);
            this.mTexture2Video.updateRecording(texId, this.tex_width, this.tex_height);
            this.configUpdated = false;
        } else {
            this.mTexture2Video.updateRecording(texId);
        }
    }

    public void stopRecording() {
        this.mMicroPhoneEncoder.stopRecording();
        this.mTexture2Video.stopRecording(null, null);
        this.mListener.onMessage(4, "");
    }

    public void releaseRecording() {
        this.mTexture2Video = null;
        this.mMicroPhoneEncoder = null;
        this.mAVRecorderConfig = null;
        this.mListener.onMessage(8, "");
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean compatibleValidation() {
        if (this.width == 1280 && this.height == 720) {
            if (systemQuality.has(VideoSize.Vid720p.value())) {
                return true;
            }
            if (systemQuality.has(VideoSize.Vid480p.value())) {
                this.width = 720;
                this.height = 480;
                this.mListener.onMessage(2049, "480P");
                return true;
            }
            this.mListener.onMessage(2048, "config_size: failed");
            return false;
        }
        if (this.width == 1920 && this.height == 1080) {
            if (systemQuality.has(VideoSize.Vid1080p.value())) {
                return true;
            }
            if (systemQuality.has(VideoSize.Vid720p.value())) {
                this.width = 1280;
                this.height = 720;
                this.mListener.onMessage(2049, "720P");
                return true;
            }
            if (systemQuality.has(VideoSize.Vid480p.value())) {
                this.width = 720;
                this.height = 480;
                this.mListener.onMessage(2049, "480P");
                return true;
            }
            this.mListener.onMessage(2048, "config_size: failed");
            return false;
        }
        if (this.width != 720) return true;
        if (this.height != 480) return true;
        if (systemQuality.has(VideoSize.Vid480p.value())) {
            return true;
        }
        if (systemQuality.has(VideoSize.Vid720p.value())) {
            this.width = 1280;
            this.height = 720;
            this.mListener.onMessage(2049, "720P");
            return true;
        }
        this.mListener.onMessage(2048, "config_size: failed");
        return false;
    }

    boolean envSetup() {
        return true;
    }

    public static void requestPermissions(long instanceId) {
        if (Build.VERSION.SDK_INT >= 23) {
            Activity context = (Activity)EasyAR.getInitializeActivity().get();
            if (context == null) {
                SessionRecorder.onPermissionCallback(instanceId, 2, "ContextMiss");
                return;
            }
            ArrayList<String> permissions = new ArrayList<String>();
            if (context.checkSelfPermission("android.permission.RECORD_AUDIO") != 0) {
                permissions.add("android.permission.RECORD_AUDIO");
            }
            if (context.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
            if (permissions.size() == 0) {
                SessionRecorder.onPermissionCallback(instanceId, 0, "");
                return;
            }
            FragmentManager fragmentManager = context.getFragmentManager();
            PermissionFragment.PermissionCallback callback = new PermissionFragment.PermissionCallback(){

                @Override
                public void invoke(long instanceId, int status, String msg) {
                    SessionRecorder.onPermissionCallback(instanceId, status, msg);
                }
            };
            PermissionFragment request = PermissionFragment.newInstance(instanceId, permissions.toArray(new String[0]), callback, fragmentManager);
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
            fragmentTransaction.add(0, (Fragment)request);
            fragmentTransaction.commit();
        } else {
            SessionRecorder.onPermissionCallback(instanceId, 0, "");
        }
    }

    public void prepare() {
        this.mListener = new RecordListener(){
            private boolean waitForSuccess = true;
            private boolean resendOnStop = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessage(int status, String info) {
                String string = TAG;
                synchronized (string) {
                    if (status >= 512 && status < 4096 || status == 1024 || status == 1025) {
                        this.waitForSuccess = false;
                    }
                    if (this.waitForSuccess && status == 4) {
                        this.resendOnStop = true;
                        return;
                    }
                    SessionRecorder.this.onStatusNotify(status, info);
                    if (this.resendOnStop && (status == 1024 || status == 1025)) {
                        SessionRecorder.this.onStatusNotify(4, "");
                        this.resendOnStop = false;
                    }
                }
            }
        };
        if (this.compatibleValidation()) {
            if (this.envSetup()) {
                this.prepareRecording();
                this.mListener.onMessage(1, "");
                return;
            }
            this.mListener.onMessage(513, "");
        } else {
            this.mListener.onMessage(513, "");
        }
    }

    public void start() {
        this.startRecording();
    }

    public void updateFrame() {
        this.updateRecording(this.texId, this.tex_width, this.tex_height);
    }

    public void stop() {
        this.stopRecording();
    }

    public void release() {
        this.releaseRecording();
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setVideoBitrate(int bitrate) {
        this.videoBitrate = bitrate;
    }

    public void setChannelCount(int count) {
        this.audioChannelCount = count;
    }

    public void setAudioSampleRate(int samplerate) {
        this.audioSampleRate = samplerate;
    }

    public void setAudioBitrate(int bitrate) {
        this.audioBitrate = bitrate;
    }

    public void setZoomMode(int mode) {
        this.mode = mode;
    }

    public void setTexture(int texture, int tex_width, int tex_height) {
        if (this.texId != texture || this.tex_width != tex_width || this.tex_height != tex_height) {
            this.configUpdated = true;
        }
        this.texId = texture;
        this.tex_width = tex_width;
        this.tex_height = tex_height;
    }

    public void setCachedFile(String file) {
        this.file = file;
    }

    public void setRectRotationClip(boolean rotationClip) {
        this.rotationClip = rotationClip;
    }

    private native void onStatusNotify(int var1, String var2);

    private static native void onPermissionCallback(long var0, int var2, String var3);

    static {
        int x = 0;
        if (CamcorderProfile.hasProfile((int)4)) {
            x = systemQuality.value() | VideoSize.Vid480p.value();
        }
        if (CamcorderProfile.hasProfile((int)5)) {
            x = systemQuality.value() | VideoSize.Vid720p.value();
        }
        if (CamcorderProfile.hasProfile((int)6)) {
            x = systemQuality.value() | VideoSize.Vid1080p.value();
        }
        systemQuality.custom(x);
    }

    static enum VideoSize {
        Vid480p(1),
        Vid720p(2),
        Vid1080p(4);

        private int quality;

        private VideoSize(int flag) {
            this.quality = flag;
        }

        boolean has(int flag) {
            return (this.quality & flag) != 0;
        }

        int value() {
            return this.quality;
        }

        void custom(int flag) {
            this.quality = flag;
        }
    }
}

