/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine.recorder;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import cn.easyar.engine.recorder.RecordListener;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=18)
public class Muxer {
    private static final String TAG = "EasyAR";
    private static final boolean DEBUG = false;
    private volatile boolean mStarted;
    private MediaMuxer mMuxer;
    private int mExpectedNumTracks = 2;
    protected int mFormat;
    protected String mOutputPath;
    private Object mObject = new Object();
    protected volatile int mNumTracks;
    protected volatile int mNumTracksFinished;
    protected long mFirstPts;
    protected long[] mLastPts;
    private volatile RecordListener mListener;
    private boolean endBeforeStart = false;

    public void setListener(RecordListener listener) {
        this.mListener = listener;
    }

    protected Muxer(String outputPath, int format) throws IOException {
        this.mOutputPath = outputPath;
        this.mFormat = format;
        this.mNumTracks = 0;
        this.mNumTracksFinished = 0;
        this.mFirstPts = 0L;
        this.mLastPts = new long[this.mExpectedNumTracks];
        for (int i = 0; i < this.mLastPts.length; ++i) {
            this.mLastPts[i] = 0L;
        }
        this.mMuxer = new MediaMuxer(outputPath.toString(), 0);
    }

    protected void setExpectedTracks(int num) {
        this.mExpectedNumTracks = num;
    }

    @TargetApi(value=18)
    protected void start() {
        this.mMuxer.start();
        this.mStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    protected void stop() {
        String string = TAG;
        synchronized (TAG) {
            try {
                if (this.mStarted) {
                    this.mMuxer.stop();
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.release(true);
            }
            this.mStarted = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getOutputPath() {
        return this.mOutputPath;
    }

    public void endBeforeStart(boolean endBeforeStart) {
        this.endBeforeStart = endBeforeStart;
    }

    public boolean endBeforeStart() {
        return this.endBeforeStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    public int addTrack(MediaFormat trackFormat) {
        if (this.mStarted) {
            throw new RuntimeException("format changed twice");
        }
        Object object = this.mObject;
        synchronized (object) {
            int track = this.mMuxer.addTrack(trackFormat);
            ++this.mNumTracks;
            if (this.allTracksAdded()) {
                this.start();
            }
            return track;
        }
    }

    public void onEncoderReleased(int trackIndex) {
    }

    public void release(boolean filestatus) {
        if (this.mMuxer == null) {
            return;
        }
        this.mListener.onMessage(filestatus ? 1024 : 1025, this.mOutputPath);
        this.mMuxer.release();
        this.mListener = null;
        this.mMuxer = null;
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSampleData(int trackIndex, ByteBuffer encodedData, MediaCodec.BufferInfo bufferInfo) {
        if ((bufferInfo.flags & 4) != 0) {
            this.signalEndOfTrack();
        }
        if ((bufferInfo.flags & 2) != 0) {
            return;
        }
        if (!this.mStarted) {
            return;
        }
        if (bufferInfo.size == 0) {
            if (this.allTracksFinished()) {
                this.stop();
            }
            return;
        }
        bufferInfo.presentationTimeUs = this.getNextRelativePts(bufferInfo.presentationTimeUs, trackIndex);
        Object object = this.mObject;
        synchronized (object) {
            this.mMuxer.writeSampleData(trackIndex, encodedData, bufferInfo);
        }
        if (this.allTracksFinished()) {
            this.stop();
        }
    }

    protected boolean allTracksFinished() {
        return this.mNumTracks == this.mNumTracksFinished;
    }

    protected boolean allTracksAdded() {
        return this.mNumTracks == this.mExpectedNumTracks;
    }

    protected void signalEndOfTrack() {
        ++this.mNumTracksFinished;
    }

    protected long getNextRelativePts(long absPts, int trackIndex) {
        if (this.mFirstPts == 0L) {
            this.mFirstPts = absPts;
            return 0L;
        }
        return this.getSafePts(absPts - this.mFirstPts, trackIndex);
    }

    private long getSafePts(long pts, int trackIndex) {
        try {
            if (this.mLastPts[trackIndex] >= pts) {
                int n = trackIndex;
                this.mLastPts[n] = this.mLastPts[n] + 9643L;
                return this.mLastPts[trackIndex];
            }
            this.mLastPts[trackIndex] = pts;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pts;
    }
}

