/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine.recorder;

import android.annotation.TargetApi;
import android.media.AudioRecord;
import android.media.MediaCodec;
import cn.easyar.engine.recorder.AVRecorderConfig;
import cn.easyar.engine.recorder.AudioEncorderCore;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MicroPhoneEncoder
implements Runnable {
    private static final boolean TRACE = false;
    private static final boolean DEBUG = false;
    private static final String TAG = "EasyAR";
    private volatile boolean isEnd = false;
    protected static final int SAMPLES_PER_FRAME = 1024;
    protected static final int AUDIO_FORMAT = 2;
    private final Object mReadyFence = new Object();
    private boolean mThreadReady;
    private boolean mThreadRunning;
    private final Object mRecordingFence = new Object();
    private AudioRecord mAudioRecord;
    private AudioEncorderCore mEncoderCore;
    private boolean mRecordingRequested;
    MediaCodec mMediaCodec;
    int audioInputBufferIndex;
    int audioInputLength;
    long audioAbsolutePtsUs;
    long startPTS = 0L;
    long totalSamplesNum = 0L;

    public MicroPhoneEncoder(AVRecorderConfig config) throws RuntimeException {
        this.init(config);
    }

    private void init(AVRecorderConfig config) throws RuntimeException {
        int channelConfig;
        switch (config.getNumAudioChannels()) {
            case 1: {
                channelConfig = 16;
                break;
            }
            case 2: {
                channelConfig = 12;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid channel count. Must be 1 or 2");
            }
        }
        int minBufferSize = AudioRecord.getMinBufferSize((int)config.getAudioSamplerate(), (int)channelConfig, (int)2);
        try {
            this.mEncoderCore = new AudioEncorderCore(config.getNumAudioChannels(), config.getAudioBitrate(), config.getAudioSamplerate(), config.getMuxer());
            this.mAudioRecord = new AudioRecord(5, config.getAudioSamplerate(), channelConfig, 2, minBufferSize * 4);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException");
        }
        catch (IllegalArgumentException e) {
            this.mEncoderCore.release();
            this.mEncoderCore = null;
            throw new RuntimeException("IllegalArgumentException");
        }
        catch (IllegalStateException e) {
            this.mEncoderCore.release();
            this.mAudioRecord.release();
            this.mEncoderCore = null;
            this.mAudioRecord = null;
            throw new RuntimeException("IllegalStateException");
        }
        this.mThreadReady = false;
        this.mThreadRunning = false;
        this.mRecordingRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRecording() throws IllegalStateException {
        try {
            this.mAudioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            this.mEncoderCore.release();
            this.mAudioRecord.release();
            this.mEncoderCore = null;
            this.mAudioRecord = null;
            throw new IllegalStateException();
        }
        this.startThread();
        Object object = this.mRecordingFence;
        synchronized (object) {
            this.totalSamplesNum = 0L;
            this.startPTS = 0L;
            this.mRecordingRequested = true;
            this.mRecordingFence.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording() {
        Object object = this.mRecordingFence;
        synchronized (object) {
            this.mRecordingRequested = false;
            this.isEnd = true;
            this.mRecordingFence.notify();
        }
    }

    public void releaseRecording() {
    }

    public boolean isRecording() {
        return this.mRecordingRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread() {
        Object object = this.mReadyFence;
        synchronized (object) {
            if (this.mThreadRunning) {
                return;
            }
            Thread audioThread = new Thread((Runnable)this, "MicrophoneEncoder");
            audioThread.setPriority(10);
            audioThread.start();
            while (!this.mThreadReady) {
                try {
                    this.mReadyFence.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=18)
    public void run() {
        Object object = this.mReadyFence;
        synchronized (object) {
            this.mThreadReady = true;
            this.mReadyFence.notify();
        }
        object = this.mRecordingFence;
        synchronized (object) {
            while (!this.mRecordingRequested && !this.isEnd) {
                try {
                    this.mRecordingFence.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        while (this.mRecordingRequested) {
            this.mEncoderCore.drainEncoder(false);
            this.sendAudioToEncoder(false);
        }
        this.mThreadReady = false;
        this.sendAudioToEncoder(true);
        this.mEncoderCore.drainEncoder(true);
        this.mEncoderCore.release();
        this.mAudioRecord.stop();
        this.mAudioRecord.release();
        this.mAudioRecord = null;
        this.mEncoderCore = null;
        this.mThreadRunning = false;
    }

    @TargetApi(value=18)
    private void sendAudioToEncoder(boolean endOfStream) {
        if (this.mMediaCodec == null) {
            this.mMediaCodec = this.mEncoderCore.getMediaCodec();
        }
        try {
            ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
            this.audioInputBufferIndex = this.mMediaCodec.dequeueInputBuffer(-1L);
            if (this.audioInputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[this.audioInputBufferIndex];
                inputBuffer.clear();
                this.audioInputLength = this.mAudioRecord.read(inputBuffer, 2048);
                this.audioAbsolutePtsUs = System.nanoTime() / 1000L;
                this.audioAbsolutePtsUs = this.getJitterFreePTS(this.audioAbsolutePtsUs, this.audioInputLength / 2);
                if (this.audioInputLength == -3) {
                    // empty if block
                }
                if (this.audioInputLength == -2) {
                    // empty if block
                }
                if (endOfStream) {
                    this.mMediaCodec.queueInputBuffer(this.audioInputBufferIndex, 0, this.audioInputLength, this.audioAbsolutePtsUs, 4);
                } else {
                    this.mMediaCodec.queueInputBuffer(this.audioInputBufferIndex, 0, this.audioInputLength, this.audioAbsolutePtsUs, 0);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long getJitterFreePTS(long bufferPts, long bufferSamplesNum) {
        long correctedPts = 0L;
        long bufferDuration = 1000000L * bufferSamplesNum / (long)this.mEncoderCore.mSampleRate;
        bufferPts -= bufferDuration;
        if (this.totalSamplesNum == 0L) {
            this.startPTS = bufferPts;
            this.totalSamplesNum = 0L;
        }
        if (bufferPts - (correctedPts = this.startPTS + 1000000L * this.totalSamplesNum / (long)this.mEncoderCore.mSampleRate) >= 2L * bufferDuration) {
            this.startPTS = bufferPts;
            this.totalSamplesNum = 0L;
            correctedPts = this.startPTS;
        }
        this.totalSamplesNum += bufferSamplesNum;
        return correctedPts;
    }
}

