/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine.recorder;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import cn.easyar.engine.recorder.Muxer;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=18)
public class AudioEncorderCore {
    private final String TAG = "EasyAR";
    private static final boolean DEBUG = false;
    protected Muxer mMuxer;
    protected MediaCodec mEncoder;
    protected MediaCodec.BufferInfo mBufferInfo;
    protected int mTrackIndex;
    protected volatile boolean mForceEos = false;
    int mEosSpinCount = 0;
    final int MAX_EOS_SPINS = 10;
    protected static final String MIME_TYPE = "audio/mp4a-latm";
    protected int mChannelConfig;
    protected int mSampleRate;

    public AudioEncorderCore(int numChannels, int bitRate, int sampleRate, Muxer muxer) throws IOException {
        this.mSampleRate = sampleRate;
        this.mBufferInfo = new MediaCodec.BufferInfo();
        this.mMuxer = muxer;
        MediaFormat format = MediaFormat.createAudioFormat((String)MIME_TYPE, (int)this.mSampleRate, (int)numChannels);
        format.setInteger("aac-profile", 2);
        format.setInteger("sample-rate", this.mSampleRate);
        format.setInteger("channel-count", numChannels);
        format.setInteger("bitrate", bitRate);
        format.setInteger("max-input-size", 16384);
        this.mEncoder = MediaCodec.createEncoderByType((String)MIME_TYPE);
        this.mEncoder.configure(format, null, null, 1);
        this.mEncoder.start();
        this.mTrackIndex = -1;
    }

    public MediaCodec getMediaCodec() {
        return this.mEncoder;
    }

    public void signalEndOfStream() {
        this.mForceEos = true;
    }

    public void release() {
        if (this.mMuxer != null) {
            this.mMuxer.onEncoderReleased(this.mTrackIndex);
        }
        if (this.mEncoder != null) {
            this.mEncoder.stop();
            this.mEncoder.release();
            this.mEncoder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainEncoder(boolean endOfStream) {
        if (endOfStream) {
            // empty if block
        }
        Muxer muxer = this.mMuxer;
        synchronized (muxer) {
            block21: {
                if (endOfStream) {
                    // empty if block
                }
                if (!this.mMuxer.isStarted()) {
                    if (endOfStream) {
                        if (!this.mMuxer.endBeforeStart()) {
                            this.mMuxer.endBeforeStart(true);
                        } else {
                            this.mMuxer.release(false);
                        }
                        return;
                    }
                    if (this.mMuxer.endBeforeStart()) {
                        return;
                    }
                }
                int TIMEOUT_USEC = 1000;
                if (endOfStream) {
                    // empty if block
                }
                ByteBuffer[] encoderOutputBuffers = this.mEncoder.getOutputBuffers();
                while (true) {
                    int encoderStatus;
                    if ((encoderStatus = this.mEncoder.dequeueOutputBuffer(this.mBufferInfo, 1000L)) == -1) {
                        if (endOfStream) {
                            ++this.mEosSpinCount;
                            if (this.mEosSpinCount <= 10) continue;
                        }
                        break block21;
                    }
                    if (encoderStatus == -3) {
                        encoderOutputBuffers = this.mEncoder.getOutputBuffers();
                        continue;
                    }
                    if (encoderStatus == -2) {
                        MediaFormat newFormat = this.mEncoder.getOutputFormat();
                        this.mTrackIndex = this.mMuxer.addTrack(newFormat);
                        continue;
                    }
                    if (encoderStatus < 0) continue;
                    ByteBuffer encodedData = encoderOutputBuffers[encoderStatus];
                    if (encodedData == null) {
                        throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                    }
                    if (this.mBufferInfo.size >= 0) {
                        encodedData.position(this.mBufferInfo.offset);
                        encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
                        if (this.mForceEos) {
                            this.mBufferInfo.flags |= 4;
                        }
                        this.mMuxer.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                    }
                    this.mEncoder.releaseOutputBuffer(encoderStatus, false);
                    if ((this.mBufferInfo.flags & 4) != 0) break;
                }
                if (endOfStream) {
                    // empty if block
                }
            }
            if (endOfStream) {
                // empty if block
            }
        }
    }

    public static boolean isKitKat() {
        return Build.VERSION.SDK_INT >= 19;
    }
}

