/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine.recorder;

import cn.easyar.engine.recorder.AudioEncorderConfig;
import cn.easyar.engine.recorder.Muxer;
import cn.easyar.engine.recorder.RecordListener;
import cn.easyar.engine.recorder.VideoEncoderConfig;
import java.io.File;
import java.io.IOException;

public class AVRecorderConfig {
    private final String TAG = this.getClass().getSimpleName();
    private final File mOutputFile;
    private String mPath;
    private AudioEncorderConfig mAudioEncorderConfig;
    private VideoEncoderConfig mVideoEncoderConfig;
    private Muxer mMuxer;
    private boolean mRotationClip;

    public AVRecorderConfig(AudioEncorderConfig audio, VideoEncoderConfig video, boolean rotationClip, String file, RecordListener listener) throws IOException {
        this.mAudioEncorderConfig = audio;
        this.mVideoEncoderConfig = video;
        this.mRotationClip = rotationClip;
        this.mOutputFile = new File(file);
        this.mMuxer = new Muxer(this.mOutputFile.toString(), 0);
        this.mMuxer.setListener(listener);
    }

    public String getPath() {
        return this.mPath;
    }

    public Muxer getMuxer() {
        return this.mMuxer;
    }

    public boolean getRotationClip() {
        return this.mRotationClip;
    }

    public int getNumAudioChannels() {
        return this.mAudioEncorderConfig.getChannel();
    }

    public int getAudioBitrate() {
        return this.mAudioEncorderConfig.getBitRate();
    }

    public int getAudioSamplerate() {
        return this.mAudioEncorderConfig.getSampleRate();
    }

    public int getHeight() {
        return this.mVideoEncoderConfig.getHeight();
    }

    public int getWidth() {
        return this.mVideoEncoderConfig.getWidth();
    }

    public void setHeight(int height) {
        this.mVideoEncoderConfig.setHeight(height);
    }

    public void setWidth(int width) {
        this.mVideoEncoderConfig.setWidth(width);
    }

    public int getTextureWidth() {
        return this.mVideoEncoderConfig.getTextureWidth();
    }

    public int getTextureHeight() {
        return this.mVideoEncoderConfig.getTextureHeight();
    }

    public void setTextureWidth(int texWidth) {
        this.mVideoEncoderConfig.setTextureWidth(texWidth);
    }

    public void setTextureHeight(int texHeight) {
        this.mVideoEncoderConfig.setTextureHeight(texHeight);
    }

    public int getVideoBitRate() {
        return this.mVideoEncoderConfig.getBitRate();
    }

    public int getZoomMode() {
        return this.mVideoEncoderConfig.getZoomMode();
    }
}

