/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine.gl;

import android.opengl.GLES20;
import android.util.Log;
import cn.easyar.engine.gl.GlUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class Texture2dProgram {
    private static final String TAG = "easyar.GlUtil";
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n";
    private static final String FRAGMENT_SHADER_2D = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform sampler2D sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final String FRAGMENT_SHADER_EXT = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final String FRAGMENT_SHADER_EXT_BW = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = tc.r * 0.3 + tc.g * 0.59 + tc.b * 0.11;\n    gl_FragColor = vec4(color, color, color, 1.0);\n}\n";
    public static final int KERNEL_SIZE = 9;
    private static final String FRAGMENT_SHADER_EXT_FILT = "#extension GL_OES_EGL_image_external : require\n#define KERNEL_SIZE 9\nprecision highp float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform float uKernel[KERNEL_SIZE];\nuniform vec2 uTexOffset[KERNEL_SIZE];\nuniform float uColorAdjust;\nvoid main() {\n    int i = 0;\n    vec4 sum = vec4(0.0);\n    if (vTextureCoord.x < vTextureCoord.y - 0.005) {\n        for (i = 0; i < KERNEL_SIZE; i++) {\n            vec4 texc = texture2D(sTexture, vTextureCoord + uTexOffset[i]);\n            sum += texc * uKernel[i];\n        }\n    sum += uColorAdjust;\n    } else if (vTextureCoord.x > vTextureCoord.y + 0.005) {\n        sum = texture2D(sTexture, vTextureCoord);\n    } else {\n        sum.r = 1.0;\n    }\n    gl_FragColor = sum;\n}\n";
    private ProgramType mProgramType;
    private int mProgramHandle;
    private int muMVPMatrixLoc;
    private int muTexMatrixLoc;
    private int muKernelLoc;
    private int muTexOffsetLoc;
    private int muColorAdjustLoc;
    private int maPositionLoc;
    private int maTextureCoordLoc;
    private int mTextureTarget;
    private float[] mKernel = new float[9];
    private float[] mTexOffset;
    private float mColorAdjust;

    public Texture2dProgram(ProgramType programType) {
        this.mProgramType = programType;
        switch (programType) {
            case TEXTURE_2D: {
                this.mTextureTarget = 3553;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_2D);
                break;
            }
            case TEXTURE_EXT: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT);
                break;
            }
            case TEXTURE_EXT_BW: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT_BW);
                break;
            }
            case TEXTURE_EXT_FILT: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GlUtil.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_EXT_FILT);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled type " + (Object)((Object)programType));
            }
        }
        if (this.mProgramHandle == 0) {
            throw new RuntimeException("Unable to create program");
        }
        Log.d((String)TAG, (String)("Created program " + this.mProgramHandle + " (" + (Object)((Object)programType) + ")"));
        this.maPositionLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aPosition");
        GlUtil.checkLocation(this.maPositionLoc, "aPosition");
        this.maTextureCoordLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aTextureCoord");
        GlUtil.checkLocation(this.maTextureCoordLoc, "aTextureCoord");
        this.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uMVPMatrix");
        GlUtil.checkLocation(this.muMVPMatrixLoc, "uMVPMatrix");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexMatrix");
        GlUtil.checkLocation(this.muTexMatrixLoc, "uTexMatrix");
        this.muKernelLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uKernel");
        if (this.muKernelLoc < 0) {
            this.muKernelLoc = -1;
            this.muTexOffsetLoc = -1;
            this.muColorAdjustLoc = -1;
        } else {
            this.muTexOffsetLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexOffset");
            GlUtil.checkLocation(this.muTexOffsetLoc, "uTexOffset");
            this.muColorAdjustLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uColorAdjust");
            GlUtil.checkLocation(this.muColorAdjustLoc, "uColorAdjust");
            this.setKernel(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}, 0.0f);
            this.setTexSize(256, 256);
        }
    }

    public void release() {
        Log.d((String)TAG, (String)("deleting program " + this.mProgramHandle));
        GLES20.glDeleteProgram((int)this.mProgramHandle);
        this.mProgramHandle = -1;
    }

    public ProgramType getProgramType() {
        return this.mProgramType;
    }

    public int createTextureObject() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GlUtil.checkGlError("glGenTextures");
        int texId = textures[0];
        GLES20.glBindTexture((int)this.mTextureTarget, (int)texId);
        GlUtil.checkGlError("glBindTexture " + texId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtil.checkGlError("glTexParameter");
        return texId;
    }

    public void setKernel(float[] values, float colorAdj) {
        if (values.length != 9) {
            throw new IllegalArgumentException("Kernel size is " + values.length + " vs. " + 9);
        }
        System.arraycopy(values, 0, this.mKernel, 0, 9);
        this.mColorAdjust = colorAdj;
    }

    public void setTexSize(int width, int height) {
        float rw = 1.0f / (float)width;
        float rh = 1.0f / (float)height;
        this.mTexOffset = new float[]{-rw, -rh, 0.0f, -rh, rw, -rh, -rw, 0.0f, 0.0f, 0.0f, rw, 0.0f, -rw, rh, 0.0f, rh, rw, rh};
    }

    public void draw(float[] mvpMatrix, FloatBuffer vertexBuffer, int firstVertex, int vertexCount, int coordsPerVertex, int vertexStride, float[] texMatrix, FloatBuffer texBuffer, int textureId, int texStride) {
        GlUtil.checkGlError("draw request");
        GLES20.glUseProgram((int)this.mProgramHandle);
        GlUtil.checkGlError("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)textureId);
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        GlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        GlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)this.maPositionLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maPositionLoc, (int)coordsPerVertex, (int)5126, (boolean)false, (int)vertexStride, (Buffer)vertexBuffer);
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.maTextureCoordLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)texStride, (Buffer)texBuffer);
        GlUtil.checkGlError("glVertexAttribPointer");
        if (this.muKernelLoc >= 0) {
            GLES20.glUniform1fv((int)this.muKernelLoc, (int)9, (float[])this.mKernel, (int)0);
            GLES20.glUniform2fv((int)this.muTexOffsetLoc, (int)9, (float[])this.mTexOffset, (int)0);
            GLES20.glUniform1f((int)this.muColorAdjustLoc, (float)this.mColorAdjust);
        }
        GLES20.glDrawArrays((int)5, (int)firstVertex, (int)vertexCount);
        GlUtil.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.maPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.maTextureCoordLoc);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }

    public static enum ProgramType {
        TEXTURE_2D,
        TEXTURE_EXT,
        TEXTURE_EXT_BW,
        TEXTURE_EXT_FILT;

    }
}

