/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.view.Surface;
import java.io.IOException;

class VideoPlayer
implements MediaPlayer.OnErrorListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnPreparedListener {
    int STATE_ERROR = -1;
    int STATE_PREPARED = 0;
    int STATE_COMPLETED = 1;
    private Context mContext;
    private MediaPlayer mPlayer;
    private int mState;
    private VideoTexture mVideoTexture;
    private int nativeId;
    private float audioVolume = 1.0f;
    private boolean ready = false;
    private boolean readyForUpdate = false;
    private boolean readyForPause = false;
    private boolean renderTextureAvailable = false;

    public VideoPlayer(Context context, int id) {
        this.nativeId = id;
        this.mContext = context.getApplicationContext();
        this.mPlayer = new MediaPlayer();
        this.mPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mVideoTexture = new VideoTexture();
    }

    private void setState(int state) {
        int oldState = this.mState;
        this.mState = state;
        VideoPlayer.onVideoStateChanged(this.nativeId, oldState, this.mState);
    }

    public void prepare(String url, int texture, boolean isAsset) {
        this.ready = false;
        try {
            if (isAsset) {
                AssetFileDescriptor descriptor = this.mContext.getAssets().openFd(url);
                this.mPlayer.setDataSource(descriptor.getFileDescriptor(), descriptor.getStartOffset(), descriptor.getLength());
            } else {
                this.mPlayer.setDataSource(url);
            }
            this.mVideoTexture.init(texture);
            this.mPlayer.prepareAsync();
        }
        catch (IOException e) {
            this.setState(this.STATE_ERROR);
        }
    }

    public boolean start() {
        if (!this.ready) {
            return false;
        }
        this.mPlayer.start();
        this.readyForUpdate = true;
        this.readyForPause = true;
        return true;
    }

    public boolean isRenderTextureAvailable() {
        return this.renderTextureAvailable;
    }

    public void updateFrame() {
        if (!this.readyForUpdate) {
            return;
        }
        this.mVideoTexture.updateTargetTexture();
    }

    public boolean pause() {
        if (!this.ready || !this.readyForPause) {
            return false;
        }
        this.mPlayer.pause();
        this.readyForUpdate = false;
        return true;
    }

    public boolean stop() {
        if (!this.ready || !this.readyForPause) {
            return false;
        }
        this.mPlayer.pause();
        this.mPlayer.seekTo(0);
        this.readyForUpdate = false;
        return true;
    }

    public int getDuration() {
        if (!this.ready) {
            return 0;
        }
        return this.mPlayer.getDuration();
    }

    public int getCurrentPosition() {
        if (!this.ready) {
            return 0;
        }
        return this.mPlayer.getCurrentPosition();
    }

    public boolean seekTo(int position) {
        if (!this.ready) {
            return false;
        }
        this.mPlayer.seekTo(position);
        return true;
    }

    public int getVideoWidth() {
        if (!this.ready) {
            return 0;
        }
        return this.mPlayer.getVideoWidth();
    }

    public int getVideoHeight() {
        if (!this.ready) {
            return 0;
        }
        return this.mPlayer.getVideoHeight();
    }

    public float getVolume() {
        return this.audioVolume;
    }

    public boolean setVolume(float volume) {
        this.audioVolume = volume = Math.max(Math.min(volume, 1.0f), 0.0f);
        this.mPlayer.setVolume(volume, volume);
        return true;
    }

    public void release() {
        if (this.mPlayer != null) {
            this.mPlayer.stop();
            this.mPlayer.release();
        }
        if (this.mVideoTexture != null) {
            this.mVideoTexture.release();
        }
    }

    public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
        this.setState(this.STATE_ERROR);
        return true;
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        this.mPlayer.seekTo(0);
        this.setState(this.STATE_COMPLETED);
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        this.mPlayer.setSurface(new Surface(this.mVideoTexture.getSurfaceTexture()));
        this.setVolume(this.audioVolume);
        this.ready = true;
        this.setState(this.STATE_PREPARED);
    }

    private static native void onVideoStateChanged(int var0, int var1, int var2);

    private static native int nativePlayerInitGL(int var0, int var1);

    private static native void nativePlayerUpdate(int var0, float[] var1);

    class VideoTexture
    implements SurfaceTexture.OnFrameAvailableListener {
        private SurfaceTexture mSurfaceTexture;
        private Boolean mUpdateSurface = false;

        VideoTexture() {
        }

        public void init(int textureId) {
            int mediaTexture = VideoPlayer.nativePlayerInitGL(VideoPlayer.this.nativeId, textureId);
            this.mSurfaceTexture = new SurfaceTexture(mediaTexture);
            this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            Boolean bl = this.mUpdateSurface;
            synchronized (bl) {
                this.mUpdateSurface = true;
            }
        }

        public SurfaceTexture getSurfaceTexture() {
            return this.mSurfaceTexture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateTargetTexture() {
            Boolean bl = this.mUpdateSurface;
            synchronized (bl) {
                if (this.mUpdateSurface.booleanValue()) {
                    this.mSurfaceTexture.updateTexImage();
                    float[] mSTMatrix = new float[16];
                    this.mSurfaceTexture.getTransformMatrix(mSTMatrix);
                    VideoPlayer.nativePlayerUpdate(VideoPlayer.this.nativeId, mSTMatrix);
                    this.mUpdateSurface = false;
                    VideoPlayer.this.renderTextureAvailable = true;
                }
            }
        }

        public void release() {
            if (this.mSurfaceTexture != null) {
                this.mSurfaceTexture.release();
            }
            VideoPlayer.this.renderTextureAvailable = false;
        }
    }
}

