/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

class MotionSensor {
    private SensorManager manager_;
    private Sensor gravitySensor_;
    private Sensor linearAccelerationSensor_;
    private Sensor gyroscopeSensor_;
    private Sensor attitudeSensor_;

    public MotionSensor(Context appContext) {
        this.manager_ = (SensorManager)appContext.getSystemService("sensor");
        this.gravitySensor_ = this.manager_.getDefaultSensor(9);
        this.linearAccelerationSensor_ = this.manager_.getDefaultSensor(10);
        this.gyroscopeSensor_ = this.manager_.getDefaultSensor(4);
        this.attitudeSensor_ = this.manager_.getDefaultSensor(15);
        if (this.attitudeSensor_ == null) {
            this.attitudeSensor_ = this.manager_.getDefaultSensor(11);
        }
    }

    public boolean isAvailable() {
        return this.gravitySensor_ != null && this.linearAccelerationSensor_ != null && this.gyroscopeSensor_ != null && this.attitudeSensor_ != null;
    }

    public IClosable open(int samplingPeriodUs, final IOnUpdated onUpdated) {
        if (!this.isAvailable()) {
            return null;
        }
        final SensorEventListener l_gravitySensor = new SensorEventListener(){

            public void onSensorChanged(SensorEvent sensorEvent) {
                onUpdated.updateGravityData(sensorEvent.values[0], sensorEvent.values[1], sensorEvent.values[2], sensorEvent.timestamp);
            }

            public void onAccuracyChanged(Sensor sensor, int i) {
            }
        };
        final SensorEventListener l_linearAccelerationSensor = new SensorEventListener(){

            public void onSensorChanged(SensorEvent sensorEvent) {
                onUpdated.updateLinearAccelerationData(sensorEvent.values[0], sensorEvent.values[1], sensorEvent.values[2], sensorEvent.timestamp);
            }

            public void onAccuracyChanged(Sensor sensor, int i) {
            }
        };
        final SensorEventListener l_gyroscopeSensor = new SensorEventListener(){

            public void onSensorChanged(SensorEvent sensorEvent) {
                onUpdated.updateGyroscopeData(sensorEvent.values[0], sensorEvent.values[1], sensorEvent.values[2], sensorEvent.timestamp);
            }

            public void onAccuracyChanged(Sensor sensor, int i) {
            }
        };
        final SensorEventListener l_attitudeSensor = new SensorEventListener(){

            public void onSensorChanged(SensorEvent sensorEvent) {
                float d = Math.max(0.0f, 1.0f - (sensorEvent.values[0] * sensorEvent.values[0] + sensorEvent.values[1] * sensorEvent.values[1] + sensorEvent.values[2] * sensorEvent.values[2]));
                onUpdated.updateAttitudeData((float)Math.sqrt(d), sensorEvent.values[0], sensorEvent.values[1], sensorEvent.values[2], sensorEvent.timestamp);
            }

            public void onAccuracyChanged(Sensor sensor, int i) {
            }
        };
        boolean result = this.manager_.registerListener(l_gravitySensor, this.gravitySensor_, samplingPeriodUs);
        if (!result) {
            return null;
        }
        result = this.manager_.registerListener(l_linearAccelerationSensor, this.linearAccelerationSensor_, samplingPeriodUs);
        if (!result) {
            this.manager_.unregisterListener(l_gravitySensor);
            return null;
        }
        result = this.manager_.registerListener(l_gyroscopeSensor, this.gyroscopeSensor_, samplingPeriodUs);
        if (!result) {
            this.manager_.unregisterListener(l_gravitySensor);
            this.manager_.unregisterListener(l_linearAccelerationSensor);
            return null;
        }
        result = this.manager_.registerListener(l_attitudeSensor, this.attitudeSensor_, samplingPeriodUs);
        if (!result) {
            this.manager_.unregisterListener(l_gravitySensor);
            this.manager_.unregisterListener(l_linearAccelerationSensor);
            this.manager_.unregisterListener(l_gyroscopeSensor);
            return null;
        }
        return new IClosable(){

            @Override
            public void close() {
                MotionSensor.this.manager_.unregisterListener(l_gravitySensor);
                MotionSensor.this.manager_.unregisterListener(l_linearAccelerationSensor);
                MotionSensor.this.manager_.unregisterListener(l_gyroscopeSensor);
                MotionSensor.this.manager_.unregisterListener(l_attitudeSensor);
            }
        };
    }

    public static interface IClosable {
        public void close();
    }

    public static class NativeOnUpdated
    implements IOnUpdated {
        public long ptr;

        @Override
        public native void updateGravityData(float var1, float var2, float var3, long var4);

        @Override
        public native void updateLinearAccelerationData(float var1, float var2, float var3, long var4);

        @Override
        public native void updateGyroscopeData(float var1, float var2, float var3, long var4);

        @Override
        public native void updateAttitudeData(float var1, float var2, float var3, float var4, long var5);
    }

    public static interface IOnUpdated {
        public void updateGravityData(float var1, float var2, float var3, long var4);

        public void updateLinearAccelerationData(float var1, float var2, float var3, long var4);

        public void updateGyroscopeData(float var1, float var2, float var3, long var4);

        public void updateAttitudeData(float var1, float var2, float var3, float var4, long var5);
    }
}

