/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.os.Build;
import android.os.Bundle;
import android.os.HandlerThread;
import android.os.Looper;
import cn.easyar.engine.EasyAR;
import cn.easyar.engine.PermissionFragment;
import java.util.ArrayList;

class LocationManager {
    private android.location.LocationManager manager_;
    private HandlerThread thread_;

    public LocationManager(Context appContext) {
        this.manager_ = (android.location.LocationManager)appContext.getSystemService("location");
    }

    public boolean isAvailable() {
        return this.manager_.isProviderEnabled("gps");
    }

    @SuppressLint(value={"MissingPermission"})
    public IClosable open(final IOnUpdated onUpdated) {
        if (this.thread_ != null) {
            return null;
        }
        final LocationListener l = new LocationListener(){

            public void onLocationChanged(Location location) {
                if (Build.VERSION.SDK_INT >= 26) {
                    onUpdated.invoke(location.getLatitude(), location.getLongitude(), location.getAltitude(), location.getAccuracy(), location.getVerticalAccuracyMeters(), location.hasAltitude(), location.hasAccuracy(), location.hasVerticalAccuracy());
                } else {
                    onUpdated.invoke(location.getLatitude(), location.getLongitude(), location.getAltitude(), location.getAccuracy(), 0.0, location.hasAltitude(), location.hasAccuracy(), false);
                }
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
            }

            public void onProviderEnabled(String provider) {
            }

            public void onProviderDisabled(String provider) {
            }
        };
        this.thread_ = new HandlerThread("LocMgr");
        this.thread_.start();
        Looper looper = this.thread_.getLooper();
        try {
            this.manager_.requestLocationUpdates("gps", 1000L, 0.0f, l, looper);
        }
        catch (Exception ex) {
            if (Build.VERSION.SDK_INT >= 18) {
                this.thread_.quitSafely();
            } else {
                this.thread_.quit();
            }
            return null;
        }
        return new IClosable(){

            @Override
            public void close() {
                LocationManager.this.manager_.removeUpdates(l);
                if (Build.VERSION.SDK_INT >= 18) {
                    LocationManager.this.thread_.quitSafely();
                } else {
                    LocationManager.this.thread_.quit();
                }
                LocationManager.this.thread_ = null;
            }
        };
    }

    public static void requestPermissions(long instanceId) {
        if (Build.VERSION.SDK_INT >= 23) {
            Activity context = (Activity)EasyAR.getInitializeActivity().get();
            if (context == null) {
                LocationManager.onPermissionCallback(instanceId, 2, "ContextMiss");
                return;
            }
            ArrayList<String> permissions = new ArrayList<String>();
            if (context.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
                permissions.add("android.permission.ACCESS_FINE_LOCATION");
            }
            if (permissions.size() == 0) {
                LocationManager.onPermissionCallback(instanceId, 0, "");
                return;
            }
            FragmentManager fragmentManager = context.getFragmentManager();
            PermissionFragment.PermissionCallback callback = new PermissionFragment.PermissionCallback(){

                @Override
                public void invoke(long instanceId, int status, String msg) {
                    LocationManager.onPermissionCallback(instanceId, status, msg);
                }
            };
            PermissionFragment request = PermissionFragment.newInstance(instanceId, permissions.toArray(new String[0]), callback, fragmentManager);
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
            fragmentTransaction.add(0, (Fragment)request);
            fragmentTransaction.commit();
        } else {
            LocationManager.onPermissionCallback(instanceId, 0, "");
        }
    }

    private static native void onPermissionCallback(long var0, int var2, String var3);

    public static interface IClosable {
        public void close();
    }

    public static class NativeOnUpdated
    implements IOnUpdated {
        public long ptr;

        @Override
        public native void invoke(double var1, double var3, double var5, double var7, double var9, boolean var11, boolean var12, boolean var13);
    }

    public static interface IOnUpdated {
        public void invoke(double var1, double var3, double var5, double var7, double var9, boolean var11, boolean var12, boolean var13);
    }
}

