/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Build;
import cn.easyar.FunctorOfVoidFromInputFrame;
import cn.easyar.InputFrame;
import cn.easyar.engine.EasyAR;
import cn.easyar.engine.PermissionFragment;
import java.util.ArrayList;
import javax.annotation.Nonnull;

class CameraDeviceUtil {
    CameraDeviceUtil() {
    }

    public static void requestPermissions(long instanceId) {
        if (Build.VERSION.SDK_INT >= 23) {
            Activity context = (Activity)EasyAR.getInitializeActivity().get();
            if (context == null) {
                CameraDeviceUtil.onPermissionCallback(instanceId, 2, "ContextMiss");
                return;
            }
            ArrayList<String> permissions = new ArrayList<String>();
            if (context.checkSelfPermission("android.permission.CAMERA") != 0) {
                permissions.add("android.permission.CAMERA");
            }
            if (permissions.size() == 0) {
                CameraDeviceUtil.onPermissionCallback(instanceId, 0, "");
                return;
            }
            FragmentManager fragmentManager = context.getFragmentManager();
            PermissionFragment.PermissionCallback callback = new PermissionFragment.PermissionCallback(){

                @Override
                public void invoke(long instanceId, int status, String msg) {
                    CameraDeviceUtil.onPermissionCallback(instanceId, status, msg);
                }
            };
            PermissionFragment request = PermissionFragment.newInstance(instanceId, permissions.toArray(new String[0]), callback, fragmentManager);
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
            fragmentTransaction.add(0, (Fragment)request);
            fragmentTransaction.commit();
        } else {
            CameraDeviceUtil.onPermissionCallback(instanceId, 0, "");
        }
    }

    private static native void onPermissionCallback(long var0, int var2, String var3);

    private static class InputFrameHandler
    implements FunctorOfVoidFromInputFrame {
        private long rawPointer = 0L;
        private final Object lock = new Object();

        private InputFrameHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRawPointer(long ptr) {
            Object object = this.lock;
            synchronized (object) {
                this.rawPointer = ptr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(@Nonnull InputFrame inputFrame) {
            Object object = this.lock;
            synchronized (object) {
                InputFrameHandler.nativeInvoke(this.rawPointer, inputFrame);
            }
        }

        private static native void nativeInvoke(long var0, InputFrame var2);
    }
}

