/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import cn.easyar.Buffer;
import cn.easyar.CameraParameters;
import cn.easyar.FunctorOfVoid;
import cn.easyar.FunctorOfVoidFromInputFrame;
import cn.easyar.Image;
import cn.easyar.InputFrame;
import cn.easyar.JniUtility;
import cn.easyar.RefBase;
import cn.easyar.Vec2I;
import cn.easyar.engine.CameraDevice;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=21)
class CameraDeviceCamera2
implements CameraDevice {
    private static final String TAG = "EasyAR";
    private final Context mContext;
    private final FunctorOfVoidFromInputFrame mInputFrameHandler;
    private CameraParameters mCameraParameters;
    private int mBufferCapacity = 8;
    private int mCameraIndex = -1;
    private String mCameraId;
    private boolean firstOpen = true;
    private int mCameraDeviceType = 0;
    private int mCameraOrientation = 0;
    private boolean mIsTimeStampSourceRealTime = true;
    private boolean mIsTimeStampSystemRealTime = false;
    private long mTimeStampOffset = 0L;
    private long mL1;
    private CameraCharacteristics mCharacteristics;
    private Size[] mSupportedSizes;
    private Rect mCameraActiveSize;
    private Range<Integer>[] mSupportedFpsRanges;
    private int mCurrentFpsRange = -1;
    private int mCurrentFocusMode = 0;
    private boolean mFlashSupported = false;
    private boolean mFlashEnabled = false;
    private HandlerThread mBackgroundThread;
    private Handler mBackgroundHandler;
    private android.hardware.camera2.CameraDevice mCameraDevice;
    private ImageReader mImageReader;
    private CameraCaptureSession mCaptureSession;
    private ByteArrayPool mByteArrayPool;
    private boolean mIsStarted = false;
    private Size mCameraSize;

    public CameraDeviceCamera2(Context context, FunctorOfVoidFromInputFrame inputFrameHandler) {
        this.mContext = context;
        this.mInputFrameHandler = inputFrameHandler;
        this.mCameraParameters = CameraParameters.createWithDefaultIntrinsics(new Vec2I(640, 480), 0, 0);
    }

    @Override
    public int getBufferCapacity() {
        return this.mBufferCapacity;
    }

    @Override
    public void setBufferCapacity(int capacity) {
        this.mBufferCapacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean openWithIndex(int index) {
        boolean success;
        block31: {
            this.close();
            success = false;
            try {
                int n;
                CameraManager manager = (CameraManager)this.mContext.getSystemService("camera");
                if (manager == null) {
                    boolean bl = false;
                    return bl;
                }
                String[] ids = manager.getCameraIdList();
                if (index < 0 || index >= ids.length) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    String cameraId = ids[index];
                    Range<Integer>[] characteristics = manager.getCameraCharacteristics(cameraId);
                    this.mCameraId = cameraId;
                    this.mCameraIndex = index;
                    this.mCharacteristics = characteristics;
                }
                catch (CameraAccessException e) {
                    Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
                    boolean cameraId = false;
                    return cameraId;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
                    boolean cameraId = false;
                    return cameraId;
                }
                boolean bl = this.mIsTimeStampSourceRealTime = (Integer)this.mCharacteristics.get(CameraCharacteristics.SENSOR_INFO_TIMESTAMP_SOURCE) == 1;
                if (this.firstOpen && !this.mIsTimeStampSourceRealTime) {
                    this.firstOpen = false;
                    Log.w((String)TAG, (String)"Camera2: Timestamp is not precise.");
                }
                int facing = (Integer)this.mCharacteristics.get(CameraCharacteristics.LENS_FACING);
                this.mCameraDeviceType = 0;
                if (facing == 1) {
                    this.mCameraDeviceType = 1;
                } else if (facing == 0) {
                    this.mCameraDeviceType = 2;
                }
                this.mCameraOrientation = (Integer)this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                this.mSupportedSizes = ((StreamConfigurationMap)this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputSizes(35);
                this.mCameraActiveSize = (Rect)this.mCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                this.mSupportedFpsRanges = (Range[])this.mCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
                this.mFlashSupported = (Boolean)this.mCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                if (this.mCameraSize == null) {
                    this.mCameraSize = this.getOptimalPreviewSize(1280, 720);
                }
                if (this.mCurrentFpsRange < 0 || this.mCurrentFpsRange >= this.mSupportedFpsRanges.length) {
                    this.mCurrentFpsRange = this.mSupportedFpsRanges.length - 1;
                    int i = 0;
                    for (Range<Integer> range : this.mSupportedFpsRanges) {
                        if ((Integer)range.getLower() == 30 && (Integer)range.getUpper() == 30) {
                            this.mCurrentFpsRange = i;
                        }
                        ++i;
                    }
                }
                this.mBackgroundThread = new HandlerThread("CameraBackground");
                this.mBackgroundThread.start();
                this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
                final AutoResetEvent signal = new AutoResetEvent();
                try {
                    manager.openCamera(this.mCameraId, new CameraDevice.StateCallback(){

                        public void onOpened(android.hardware.camera2.CameraDevice cameraDevice) {
                            CameraDeviceCamera2.this.mCameraDevice = cameraDevice;
                            signal.set();
                        }

                        public void onDisconnected(android.hardware.camera2.CameraDevice cameraDevice) {
                            cameraDevice.close();
                            signal.set();
                        }

                        public void onError(android.hardware.camera2.CameraDevice cameraDevice, int error) {
                            cameraDevice.close();
                            signal.set();
                            Log.e((String)CameraDeviceCamera2.TAG, (String)("Camera2: CameraManager.openCamera onError(" + error + ")\n"));
                        }
                    }, this.mBackgroundHandler);
                }
                catch (CameraAccessException e) {
                    Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
                    n = 0;
                    if (!success) {
                        this.close();
                    }
                    return n != 0;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
                    n = 0;
                    if (!success) {
                        this.close();
                    }
                    return n != 0;
                }
                signal.waitOne();
                if (this.mCameraDevice == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (this.mCameraParameters != null) {
                    this.mCameraParameters.dispose();
                }
                this.mCameraParameters = CameraParameters.createWithDefaultIntrinsics(new Vec2I(640, 480), this.mCameraDeviceType, this.mCameraOrientation);
                success = true;
                break block31;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }
        return success;
    }

    @Override
    public boolean openWithSpecificType(int type) {
        CameraManager manager = (CameraManager)this.mContext.getSystemService("camera");
        if (manager == null) {
            return false;
        }
        try {
            String[] ids = manager.getCameraIdList();
            for (int k = 0; k < ids.length; ++k) {
                String cameraId = ids[k];
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
                Integer facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (type == 1 && facing == 1) {
                    return this.openWithIndex(k);
                }
                if (type == 2 && facing == 0) {
                    return this.openWithIndex(k);
                }
                if (type != 0) continue;
                return this.openWithIndex(k);
            }
            return false;
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
    }

    @Override
    public void close() {
        this.stop();
        if (this.mCameraParameters != null) {
            this.mCameraParameters.dispose();
            this.mCameraParameters = null;
        }
    }

    @Override
    public boolean start() {
        if (this.mBackgroundThread == null || this.mBackgroundHandler == null || this.mCameraDevice == null) {
            if (this.mContext == null) {
                return false;
            }
            if (!this.openWithIndex(this.mCameraIndex)) {
                return false;
            }
        }
        if (this.mIsStarted) {
            return true;
        }
        if (this.mCameraSize == null) {
            return false;
        }
        this.mImageReader = ImageReader.newInstance((int)this.mCameraSize.getWidth(), (int)this.mCameraSize.getHeight(), (int)35, (int)2);
        this.mImageReader.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(){
            private boolean notSupportedFired = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onImageAvailable(ImageReader reader) {
                android.media.Image image = reader.acquireLatestImage();
                if (image == null) {
                    return;
                }
                try {
                    ByteArrayPair p;
                    int pixelFormat = 0;
                    if (image.getPlanes().length == 3) {
                        pixelFormat = CameraDeviceCamera2.checkPixelFormat(image.getPlanes()[0], image.getPlanes()[1], image.getPlanes()[2]);
                    }
                    if (pixelFormat == 0) {
                        if (!this.notSupportedFired) {
                            Log.e((String)CameraDeviceCamera2.TAG, (String)"Camera2: Not supported image format.");
                            this.notSupportedFired = true;
                        }
                        return;
                    }
                    Image.Plane[] planes = image.getPlanes();
                    int bufferBlockSize = image.getWidth() * image.getHeight() * 3 / 2;
                    if (CameraDeviceCamera2.this.mByteArrayPool == null || CameraDeviceCamera2.this.mByteArrayPool.getBlockSize() != bufferBlockSize || CameraDeviceCamera2.this.mByteArrayPool.getCapacity() != CameraDeviceCamera2.this.mBufferCapacity) {
                        CameraDeviceCamera2.this.mByteArrayPool = new ByteArrayPool(bufferBlockSize, CameraDeviceCamera2.this.mBufferCapacity);
                    }
                    if ((p = CameraDeviceCamera2.this.mByteArrayPool.tryAcquire()) == null) {
                        return;
                    }
                    byte[] imageBuffer = p.array;
                    CameraDeviceCamera2.fillImageBuffer(planes[0].getBuffer(), planes[1].getBuffer(), planes[2].getBuffer(), planes[0].getRowStride(), planes[1].getRowStride(), planes[2].getRowStride(), pixelFormat, image.getWidth(), image.getHeight(), imageBuffer);
                    Buffer b = p.buffer;
                    Image i = null;
                    RefBase inputFrame = null;
                    RefBase camParams = null;
                    try {
                        i = new Image(b, pixelFormat, image.getWidth(), image.getHeight());
                        long timestamp = image.getTimestamp() + CameraDeviceCamera2.this.mTimeStampOffset + CameraDeviceCamera2.this.mL1;
                        double double_timestamp = timestamp == 0L ? (double)SystemClock.elapsedRealtimeNanos() * 1.0E-9 : (double)timestamp * 1.0E-9;
                        camParams = CameraDeviceCamera2.this.mCameraParameters.getResized(new Vec2I(image.getWidth(), image.getHeight()));
                        inputFrame = InputFrame.createWithImageAndCameraParametersAndTemporal(i, (CameraParameters)camParams, double_timestamp);
                        CameraDeviceCamera2.this.mInputFrameHandler.invoke((InputFrame)inputFrame);
                    }
                    finally {
                        if (camParams != null) {
                            camParams.dispose();
                        }
                        if (inputFrame != null) {
                            inputFrame.dispose();
                        }
                        if (i != null) {
                            i.dispose();
                        }
                        if (b != null) {
                            b.dispose();
                        }
                    }
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    image.close();
                }
            }
        }, this.mBackgroundHandler);
        final AutoResetEvent signal = new AutoResetEvent();
        try {
            this.mCameraDevice.createCaptureSession(Collections.singletonList(this.mImageReader.getSurface()), new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    CameraDeviceCamera2.this.mCaptureSession = cameraCaptureSession;
                    signal.set();
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                    Log.e((String)CameraDeviceCamera2.TAG, (String)"Camera2: createCaptureSession onConfigureFailed!");
                    signal.set();
                }

                public void onClosed(CameraCaptureSession session) {
                }
            }, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
        signal.waitOne();
        if (this.mCaptureSession == null) {
            this.close();
            return false;
        }
        if (!this.runRequest()) {
            this.close();
            return false;
        }
        this.mIsStarted = true;
        return true;
    }

    @Override
    public void stop() {
        this.mIsStarted = false;
        if (this.mCaptureSession != null) {
            try {
                this.mCaptureSession.stopRepeating();
            }
            catch (CameraAccessException cameraAccessException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mCaptureSession.abortCaptures();
            }
            catch (CameraAccessException cameraAccessException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mCaptureSession.close();
            this.mCaptureSession = null;
        }
        if (this.mImageReader != null) {
            this.mImageReader.close();
            this.mImageReader = null;
        }
        if (this.mCameraDevice != null) {
            this.mCameraDevice.close();
            this.mCameraDevice = null;
        }
        if (this.mBackgroundThread != null) {
            this.mBackgroundThread.quitSafely();
            try {
                this.mBackgroundThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
    }

    @Override
    public int getIndex() {
        return this.mCameraIndex;
    }

    @Override
    public int getType() {
        return this.mCameraDeviceType;
    }

    @Override
    public int getCameraOrientation() {
        return this.mCameraOrientation;
    }

    @Override
    public CameraParameters getCameraParameters() {
        return new CameraParameters(this.mCameraParameters.size(), this.mCameraParameters.focalLength(), this.mCameraParameters.principalPoint(), this.mCameraParameters.cameraDeviceType(), this.mCameraParameters.cameraOrientation());
    }

    @Override
    public void setCameraParameters(CameraParameters cameraParameters) {
        if (cameraParameters == null) {
            return;
        }
        if (this.mCameraParameters != null) {
            this.mCameraParameters.dispose();
        }
        this.mCameraParameters = new CameraParameters(cameraParameters.size(), cameraParameters.focalLength(), cameraParameters.principalPoint(), cameraParameters.cameraDeviceType(), cameraParameters.cameraOrientation());
    }

    @Override
    public int getSizeWidth() {
        if (this.mCameraSize == null) {
            return 0;
        }
        return this.mCameraSize.getWidth();
    }

    @Override
    public int getSizeHeight() {
        if (this.mCameraSize == null) {
            return 0;
        }
        return this.mCameraSize.getHeight();
    }

    @Override
    public boolean setSize(int width, int height) {
        if (this.mSupportedSizes == null) {
            return false;
        }
        this.mCameraSize = this.getOptimalPreviewSize(width, height);
        if (this.mIsStarted) {
            this.close();
            this.start();
        }
        return true;
    }

    @Override
    public int getNumSupportedSize() {
        if (this.mSupportedSizes == null) {
            return 0;
        }
        return this.mSupportedSizes.length;
    }

    @Override
    public int getSupportedSizeWidth(int index) {
        if (this.mSupportedSizes == null || index < 0 || index >= this.mSupportedSizes.length) {
            return 0;
        }
        return this.mSupportedSizes[index].getWidth();
    }

    @Override
    public int getSupportedSizeHeight(int index) {
        if (this.mSupportedSizes == null || index < 0 || index >= this.mSupportedSizes.length) {
            return 0;
        }
        return this.mSupportedSizes[index].getHeight();
    }

    @Override
    public int getNumSupportedFrameRateRange() {
        if (this.mSupportedFpsRanges == null) {
            return 0;
        }
        return this.mSupportedFpsRanges.length;
    }

    @Override
    public float getSupportedFrameRateRangeLower(int index) {
        if (this.mSupportedFpsRanges == null) {
            return 0.0f;
        }
        if (index < 0 || index >= this.mSupportedFpsRanges.length) {
            return 0.0f;
        }
        return ((Integer)this.mSupportedFpsRanges[index].getLower()).intValue();
    }

    @Override
    public float getSupportedFrameRateRangeUpper(int index) {
        if (this.mSupportedFpsRanges == null) {
            return 0.0f;
        }
        if (index < 0 || index >= this.mSupportedFpsRanges.length) {
            return 0.0f;
        }
        return ((Integer)this.mSupportedFpsRanges[index].getUpper()).intValue();
    }

    @Override
    public int getFrameRateRange() {
        if (this.mSupportedFpsRanges == null) {
            return -1;
        }
        return this.mCurrentFpsRange;
    }

    @Override
    public boolean setFrameRateRange(int index) {
        if (this.mSupportedFpsRanges == null) {
            return false;
        }
        if (index < 0 || index >= this.mSupportedFpsRanges.length) {
            return false;
        }
        this.mCurrentFpsRange = index;
        if (this.mIsStarted) {
            this.runRequest();
        }
        return true;
    }

    @Override
    public boolean setFlashTorchMode(boolean on) {
        if (!this.mFlashSupported) {
            return false;
        }
        this.mFlashEnabled = on;
        if (this.mIsStarted) {
            this.runRequest();
        }
        return true;
    }

    @Override
    public boolean setFocusMode(int focusMode) {
        boolean focusModeSupport = true;
        if (this.mCharacteristics == null) {
            return false;
        }
        if (focusMode != 0) {
            if (focusMode == 2) {
                if (!CameraDeviceCamera2.contains((int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES), 4) && !CameraDeviceCamera2.contains((int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES), 3)) {
                    Log.e((String)TAG, (String)String.format("Camera2: FocusMode.Continousauto not supported", new Object[0]));
                    focusModeSupport = false;
                }
            } else if (focusMode == 3) {
                if (!CameraDeviceCamera2.contains((int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES), 1)) {
                    Log.e((String)TAG, (String)String.format("Camera2: FocusMode.Infinity not supported: manual sensor not available", new Object[0]));
                    focusModeSupport = false;
                }
            } else if (focusMode != 4) {
                if (focusMode == 5) {
                    if (!CameraDeviceCamera2.contains((int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES), 1)) {
                        Log.e((String)TAG, (String)String.format("Camera2: FocusMode.Medium not supported: manual sensor not available", new Object[0]));
                        focusModeSupport = false;
                    }
                } else {
                    return false;
                }
            }
        }
        this.mCurrentFocusMode = focusMode;
        if (this.mIsStarted) {
            this.runRequest();
        }
        return focusModeSupport;
    }

    @Override
    public boolean autoFocus() {
        this.runRequest(false);
        this.runRequest(true);
        return true;
    }

    private boolean runRequest() {
        return this.runRequest(true);
    }

    private boolean runRequest(boolean repeating) {
        CaptureRequest.Builder builder;
        if (this.mCameraDevice == null) {
            return false;
        }
        if (this.mCaptureSession == null) {
            return false;
        }
        try {
            builder = this.mCameraDevice.createCaptureRequest(1);
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
        builder.addTarget(this.mImageReader.getSurface());
        int newWidth = (int)Math.round(Math.ceil(this.mCameraActiveSize.width() / 8)) * 8;
        int newHeight = (int)Math.round(Math.ceil(this.mCameraActiveSize.height() / 8)) * 8;
        int left = this.mCameraActiveSize.left + (this.mCameraActiveSize.width() - newWidth) / 2;
        int top = this.mCameraActiveSize.top + (this.mCameraActiveSize.height() - newHeight) / 2;
        int right = left + newWidth;
        int bottom = top + newHeight;
        builder.set(CaptureRequest.SCALER_CROP_REGION, (Object)new Rect(left, top, right, bottom));
        builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        builder.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, (Object)0);
        builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
        builder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
        builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, this.mSupportedFpsRanges[this.mCurrentFpsRange]);
        if (this.mFlashEnabled) {
            builder.set(CaptureRequest.FLASH_MODE, (Object)2);
        }
        builder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        if (this.mCurrentFocusMode == 0) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            if (!repeating) {
                builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            }
        } else if (this.mCurrentFocusMode == 2) {
            if (CameraDeviceCamera2.contains((int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES), 4)) {
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            } else if (CameraDeviceCamera2.contains((int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES), 3)) {
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            } else {
                builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            }
        } else if (this.mCurrentFocusMode == 3) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            if (CameraDeviceCamera2.contains((int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES), 1)) {
                builder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(0.0f));
            }
        } else if (this.mCurrentFocusMode == 4) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)2);
            if (!repeating) {
                builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            }
        } else if (this.mCurrentFocusMode == 5) {
            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
            if (CameraDeviceCamera2.contains((int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES), 1)) {
                builder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(0.6f));
            }
        } else {
            return false;
        }
        try {
            CameraCaptureSession.CaptureCallback callback = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureStarted(CameraCaptureSession session, CaptureRequest request, long timestamp, long frameNumber) {
                    if (!CameraDeviceCamera2.this.mIsTimeStampSourceRealTime && CameraDeviceCamera2.this.mTimeStampOffset == 0L && !CameraDeviceCamera2.this.mIsTimeStampSystemRealTime) {
                        CameraDeviceCamera2.this.mTimeStampOffset = SystemClock.elapsedRealtimeNanos() - timestamp;
                        if (Math.abs(CameraDeviceCamera2.this.mTimeStampOffset) < 1000000000L) {
                            CameraDeviceCamera2.this.mTimeStampOffset = 0L;
                            CameraDeviceCamera2.this.mIsTimeStampSystemRealTime = true;
                        }
                    }
                }

                public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
                }

                public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
                    long SKEW = 0L;
                    if (result.get(CaptureResult.SENSOR_ROLLING_SHUTTER_SKEW) != null) {
                        SKEW = (Long)result.get(CaptureResult.SENSOR_ROLLING_SHUTTER_SKEW);
                    }
                    long EXPOSURE_TIME = 0L;
                    if (result.get(CaptureResult.SENSOR_EXPOSURE_TIME) != null) {
                        EXPOSURE_TIME = (Long)result.get(CaptureResult.SENSOR_EXPOSURE_TIME);
                    }
                    CameraDeviceCamera2.this.mL1 = (SKEW + EXPOSURE_TIME) / 2L;
                }
            };
            if (repeating) {
                this.mCaptureSession.setRepeatingRequest(builder.build(), callback, this.mBackgroundHandler);
            } else {
                this.mCaptureSession.capture(builder.build(), callback, this.mBackgroundHandler);
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera2: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
        return true;
    }

    private static float getRatioError(float x, float x0) {
        float a = x / Math.max(x0, 1.0f) - 1.0f;
        float b = x0 / Math.max(x, 1.0f) - 1.0f;
        return a * a + b * b;
    }

    private Size getOptimalPreviewSize(int width, int height) {
        if (this.mSupportedSizes == null) {
            return null;
        }
        Size s = null;
        float minError = Float.MAX_VALUE;
        for (Size size : this.mSupportedSizes) {
            float error = CameraDeviceCamera2.getRatioError(width, size.getWidth()) + CameraDeviceCamera2.getRatioError(height, size.getHeight());
            if (!(error < minError)) continue;
            minError = error;
            s = size;
        }
        return s;
    }

    private static boolean contains(int[] values, int value) {
        for (int v : values) {
            if (v != value) continue;
            return true;
        }
        return false;
    }

    private static int checkPixelFormat(Image.Plane p1, Image.Plane p2, Image.Plane p3) {
        int ps1 = p1.getPixelStride();
        int ps2 = p2.getPixelStride();
        int ps3 = p3.getPixelStride();
        int rs2 = p2.getRowStride();
        int rs3 = p3.getRowStride();
        if (ps1 != 1 || ps2 != ps3 || rs2 != rs3) {
            return 0;
        }
        long raw1 = CameraDeviceCamera2.getDirectBufferAddress(p1.getBuffer());
        long raw2 = CameraDeviceCamera2.getDirectBufferAddress(p2.getBuffer());
        long raw3 = CameraDeviceCamera2.getDirectBufferAddress(p3.getBuffer());
        if (raw1 == 0L || raw2 == 0L || raw3 == 0L) {
            return 0;
        }
        if (ps2 == 2) {
            if (raw2 + 1L == raw3) {
                return 3;
            }
            if (raw3 + 1L == raw2) {
                return 2;
            }
        } else if (ps2 == ps1 && ps2 == 1) {
            if (raw2 < raw3) {
                return 4;
            }
            return 5;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getDirectBufferAddress(ByteBuffer buffer) {
        long ptr = JniUtility.newJniGlobalPointer(buffer);
        try {
            long l = JniUtility.getDirectBufferAddress(ptr);
            return l;
        }
        finally {
            JniUtility.deleteJniGlobalPointer(ptr);
        }
    }

    private static void fillImageBuffer(ByteBuffer dataY, ByteBuffer dataU, ByteBuffer dataV, int rowStrideY, int rowStrideU, int rowStrideV, int pixelFormat, int width, int height, byte[] imageBuffer) {
        int dst;
        int row;
        int stride;
        long rawByteY = CameraDeviceCamera2.getDirectBufferAddress(dataY);
        long rawByteU = CameraDeviceCamera2.getDirectBufferAddress(dataU);
        long rawByteV = CameraDeviceCamera2.getDirectBufferAddress(dataV);
        if (rawByteY == 0L || rawByteU == 0L || rawByteV == 0L) {
            throw new RuntimeException("NotSupported");
        }
        int dataLen = width * height * 3 / 2;
        int yLen = width * height;
        int uvLen = yLen / 2;
        if (rowStrideY == width) {
            dataY.position(0);
            dataY.get(imageBuffer, 0, yLen);
        } else {
            int dst2 = 0;
            int src = 0;
            for (int i = 0; i < height; ++i) {
                dataY.position(src);
                dataY.get(imageBuffer, dst2, width);
                dst2 += width;
                src += rowStrideY;
            }
        }
        if (pixelFormat == 3) {
            stride = width;
            if (rowStrideU == stride) {
                dataU.position(0);
                dataU.get(imageBuffer, yLen, uvLen - 1);
                dataV.position(dataU.position() - 1);
                dataV.get(imageBuffer, yLen + uvLen - 1, 1);
            } else {
                row = height / 2;
                dst = yLen;
                int src = 0;
                for (int i = 0; i < row; ++i) {
                    dataU.position(src);
                    dataU.get(imageBuffer, dst, i == row - 1 ? stride - 1 : stride);
                    dst += stride;
                    src += rowStrideU;
                }
                dataV.position(dataU.position() - 1);
                dataV.get(imageBuffer, yLen + uvLen - 1, 1);
            }
        } else if (pixelFormat == 2) {
            stride = width;
            if (rowStrideU == stride) {
                dataV.position(0);
                dataV.get(imageBuffer, yLen, uvLen - 1);
                dataU.position(dataV.position() - 1);
                dataU.get(imageBuffer, yLen + uvLen - 1, 1);
            } else {
                row = height / 2;
                dst = yLen;
                int src = 0;
                for (int i = 0; i < row; ++i) {
                    dataV.position(src);
                    dataV.get(imageBuffer, dst, i == row - 1 ? stride - 1 : stride);
                    dst += stride;
                    src += rowStrideV;
                }
                dataU.position(dataV.position() - 1);
                dataU.get(imageBuffer, yLen + uvLen - 1, 1);
            }
        } else if (pixelFormat == 4) {
            stride = width / 2;
            if (rowStrideU == stride) {
                dataU.position(0);
                dataU.get(imageBuffer, yLen, uvLen / 2);
                dataV.position(0);
                dataV.get(imageBuffer, yLen + uvLen / 2, uvLen / 2);
            } else {
                row = height / 2;
                int dstU = yLen;
                int srcU = 0;
                for (int i = 0; i < row; ++i) {
                    dataU.position(srcU);
                    dataU.get(imageBuffer, dstU, stride);
                    dstU += stride;
                    srcU += rowStrideU;
                }
                int dstV = yLen + uvLen / 2;
                int srcV = 0;
                for (int i = 0; i < row; ++i) {
                    dataV.position(srcV);
                    dataV.get(imageBuffer, dstV, stride);
                    dstV += stride;
                    srcV += rowStrideV;
                }
            }
        } else if (pixelFormat == 5) {
            stride = width / 2;
            if (rowStrideU == stride) {
                dataV.position(0);
                dataV.get(imageBuffer, yLen, uvLen / 2);
                dataU.position(0);
                dataU.get(imageBuffer, yLen + uvLen / 2, uvLen / 2);
            } else {
                row = height / 2;
                int dstV = yLen;
                int srcV = 0;
                for (int i = 0; i < row; ++i) {
                    dataV.position(srcV);
                    dataV.get(imageBuffer, dstV, stride);
                    dstV += stride;
                    srcV += rowStrideV;
                }
                int dstU = yLen + uvLen / 2;
                int srcU = 0;
                for (int i = 0; i < row; ++i) {
                    dataU.position(srcU);
                    dataU.get(imageBuffer, dstU, stride);
                    dstU += stride;
                    srcU += rowStrideU;
                }
            }
        } else {
            throw new RuntimeException("NotSupported");
        }
    }

    private static class ByteArrayPool {
        private final Lock lock = new ReentrantLock();
        private final int blockSize;
        private final int capacity;
        private int size;
        private final Queue<byte[]> queue;

        public ByteArrayPool(int blockSize, int capacity) {
            this.blockSize = blockSize;
            this.capacity = capacity;
            this.queue = new LinkedList<byte[]>();
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getSize() {
            this.lock.lock();
            try {
                int n = this.size;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        public ByteArrayPair tryAcquire() {
            byte[] block = null;
            this.lock.lock();
            try {
                if (this.size >= this.capacity) {
                    ByteArrayPair byteArrayPair = null;
                    return byteArrayPair;
                }
                block = this.queue.poll();
                ++this.size;
            }
            finally {
                this.lock.unlock();
            }
            if (block == null) {
                block = new byte[this.blockSize];
            }
            final byte[] finalBlock = block;
            Buffer buffer = Buffer.wrapByteArray(block, 0, block.length, true, new FunctorOfVoid(){

                @Override
                public void invoke() {
                    Arrays.fill(finalBlock, (byte)0);
                    lock.lock();
                    try {
                        size = size - 1;
                        if (size >= capacity) {
                            return;
                        }
                        queue.add(finalBlock);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            });
            ByteArrayPair pair = new ByteArrayPair();
            pair.array = block;
            pair.buffer = buffer;
            return pair;
        }
    }

    private static class ByteArrayPair {
        public byte[] array;
        public Buffer buffer;

        private ByteArrayPair() {
        }
    }

    private static class AutoResetEvent {
        private Lock lock = new ReentrantLock();
        private Condition condition = this.lock.newCondition();
        private boolean signaled = false;

        public void set() {
            this.lock.lock();
            try {
                this.signaled = true;
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void waitOne() {
            while (true) {
                this.lock.lock();
                try {
                    if (this.signaled) {
                        this.signaled = false;
                        return;
                    }
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }
    }
}

