/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.SystemClock;
import android.util.Log;
import cn.easyar.Buffer;
import cn.easyar.CameraParameters;
import cn.easyar.FunctorOfVoidFromInputFrame;
import cn.easyar.Image;
import cn.easyar.InputFrame;
import cn.easyar.RefBase;
import cn.easyar.Vec2I;
import cn.easyar.engine.CameraDevice;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class CameraDeviceCamera
implements CameraDevice,
Camera.PreviewCallback {
    private static final String TAG = "EasyAR";
    private final FunctorOfVoidFromInputFrame mInputFrameHandler;
    private CameraParameters mCameraParameters;
    private int mBufferCapacity = 8;
    private AtomicInteger mBufferSize = new AtomicInteger(8);
    private int mCameraIndex = -1;
    private int mCameraDeviceType = 0;
    private int mCameraOrientation = 0;
    private List<Camera.Size> mSupportedPreviewSizes;
    private List<int[]> mSupportedPreviewFpsRanges;
    private int mWidth = 1280;
    private int mHeight = 960;
    private Vec2I mSizeToSet = new Vec2I(this.mWidth, this.mHeight);
    private int mCurrentFpsRange = -1;
    private Boolean mFlashTorchMode = null;
    private Integer mFocusMode = null;
    private boolean mStarted = false;
    private volatile Camera mCameraDevice;
    private SurfaceTexture mSurfaceTexture;

    public CameraDeviceCamera(Context context, FunctorOfVoidFromInputFrame inputFrameHandler) {
        this.mInputFrameHandler = inputFrameHandler;
        this.mCameraParameters = CameraParameters.createWithDefaultIntrinsics(new Vec2I(640, 480), 0, 0);
    }

    @Override
    public int getBufferCapacity() {
        return this.mBufferCapacity;
    }

    @Override
    public void setBufferCapacity(int capacity) {
        this.mBufferCapacity = capacity;
        if (this.ready()) {
            for (int k = this.mBufferSize.get(); k < capacity; ++k) {
                this.mCameraDevice.addCallbackBuffer(new byte[this.mWidth * this.mHeight * 3 / 2]);
            }
            this.mBufferSize.set(this.mBufferCapacity);
        }
    }

    @Override
    public boolean openWithIndex(int index) {
        try {
            this.close();
            this.mSurfaceTexture = new SurfaceTexture(0);
            this.mCameraDevice = Camera.open((int)index);
            if (this.mCameraDevice != null) {
                this.mCameraIndex = index;
                Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)this.mCameraIndex, (Camera.CameraInfo)cameraInfo);
                this.mCameraDeviceType = 0;
                if (cameraInfo.facing == 0) {
                    this.mCameraDeviceType = 1;
                } else if (cameraInfo.facing == 1) {
                    this.mCameraDeviceType = 2;
                }
                this.mCameraOrientation = cameraInfo.orientation;
                if (this.mCameraParameters != null) {
                    this.mCameraParameters.dispose();
                }
                this.mCameraParameters = CameraParameters.createWithDefaultIntrinsics(new Vec2I(this.mWidth, this.mHeight), this.mCameraDeviceType, this.mCameraOrientation);
                Camera.Parameters params = this.mCameraDevice.getParameters();
                params.setPreviewFormat(17);
                this.mSupportedPreviewSizes = params.getSupportedPreviewSizes();
                this.mSupportedPreviewFpsRanges = params.getSupportedPreviewFpsRange();
                if (this.mCurrentFpsRange < 0 || this.mCurrentFpsRange >= this.mSupportedPreviewFpsRanges.size()) {
                    this.mCurrentFpsRange = this.mSupportedPreviewFpsRanges.size() - 1;
                    int i = 0;
                    for (int[] range : this.mSupportedPreviewFpsRanges) {
                        if (range[0] == 30000 && range[1] == 30000) {
                            this.mCurrentFpsRange = i;
                        }
                        ++i;
                    }
                    params.setPreviewFpsRange(this.mSupportedPreviewFpsRanges.get(this.mCurrentFpsRange)[0], this.mSupportedPreviewFpsRanges.get(this.mCurrentFpsRange)[1]);
                }
                Camera.Size size = this.getOptimalPreviewSize(this.mSizeToSet.data[0], this.mSizeToSet.data[1]);
                params.setPreviewSize(size.width, size.height);
                this.mCameraDevice.setParameters(params);
                params = this.mCameraDevice.getParameters();
                size = params.getPreviewSize();
                this.mWidth = size.width;
                this.mHeight = size.height;
                if (this.mCameraParameters != null) {
                    this.mCameraParameters.dispose();
                }
                this.mCameraParameters = CameraParameters.createWithDefaultIntrinsics(new Vec2I(this.mWidth, this.mHeight), this.mCameraDeviceType, this.mCameraOrientation);
                this.mCameraDevice.setParameters(params);
                this.setFrameRateRange(this.mCurrentFpsRange);
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera1: \n" + Log.getStackTraceString((Throwable)e)));
            if (this.mCameraDevice != null) {
                try {
                    this.mCameraDevice.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mCameraDevice = null;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean openWithSpecificType(int type) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int cameraCount = Camera.getNumberOfCameras();
        for (int k = 0; k < cameraCount; ++k) {
            Camera.getCameraInfo((int)k, (Camera.CameraInfo)cameraInfo);
            if (type == 1 && cameraInfo.facing == 0) {
                return this.openWithIndex(k);
            }
            if (type == 2 && cameraInfo.facing == 1) {
                return this.openWithIndex(k);
            }
            if (type != 0) continue;
            return this.openWithIndex(k);
        }
        return false;
    }

    @Override
    public void close() {
        this.stop();
        if (this.mCameraParameters != null) {
            this.mCameraParameters.dispose();
            this.mCameraParameters = null;
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
    }

    @Override
    public boolean start() {
        if (!this.ready() && !this.openWithIndex(this.mCameraIndex)) {
            return false;
        }
        try {
            this.mCameraDevice.setPreviewTexture(this.mSurfaceTexture);
            this.mCameraDevice.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            for (int i = 0; i < this.mBufferCapacity; ++i) {
                this.mCameraDevice.addCallbackBuffer(new byte[this.mWidth * this.mHeight * 3 / 2]);
            }
            this.mBufferSize.set(this.mBufferCapacity);
            this.mCameraDevice.startPreview();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera1: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
        if (this.mFlashTorchMode != null) {
            this.setFlashTorchMode(this.mFlashTorchMode);
        }
        if (this.mFocusMode != null) {
            this.setFocusMode(this.mFocusMode);
        }
        this.mStarted = true;
        return true;
    }

    @Override
    public void stop() {
        if (!this.ready()) {
            return;
        }
        this.mStarted = false;
        try {
            this.mCameraDevice.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mCameraDevice.setPreviewCallback(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mCameraDevice.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mCameraDevice = null;
    }

    @Override
    public int getIndex() {
        return this.mCameraIndex;
    }

    @Override
    public int getType() {
        return this.mCameraDeviceType;
    }

    @Override
    public int getCameraOrientation() {
        return this.mCameraOrientation;
    }

    @Override
    public CameraParameters getCameraParameters() {
        return new CameraParameters(this.mCameraParameters.size(), this.mCameraParameters.focalLength(), this.mCameraParameters.principalPoint(), this.mCameraParameters.cameraDeviceType(), this.mCameraParameters.cameraOrientation());
    }

    @Override
    public void setCameraParameters(CameraParameters cameraParameters) {
        if (cameraParameters == null) {
            return;
        }
        if (this.mCameraParameters != null) {
            this.mCameraParameters.dispose();
        }
        this.mCameraParameters = new CameraParameters(cameraParameters.size(), cameraParameters.focalLength(), cameraParameters.principalPoint(), cameraParameters.cameraDeviceType(), cameraParameters.cameraOrientation());
    }

    @Override
    public int getSizeWidth() {
        return this.mWidth;
    }

    @Override
    public int getSizeHeight() {
        return this.mHeight;
    }

    @Override
    public int getNumSupportedSize() {
        if (this.mSupportedPreviewSizes == null) {
            return 0;
        }
        return this.mSupportedPreviewSizes.size();
    }

    @Override
    public int getSupportedSizeWidth(int index) {
        if (this.mSupportedPreviewSizes == null) {
            return 0;
        }
        if (index < 0 || index >= this.mSupportedPreviewSizes.size()) {
            return 0;
        }
        Camera.Size size = this.mSupportedPreviewSizes.get(index);
        return size.width;
    }

    @Override
    public int getSupportedSizeHeight(int index) {
        if (this.mSupportedPreviewSizes == null) {
            return 0;
        }
        if (index < 0 || index >= this.mSupportedPreviewSizes.size()) {
            return 0;
        }
        Camera.Size size = this.mSupportedPreviewSizes.get(index);
        return size.height;
    }

    @Override
    public boolean setSize(int width, int height) {
        this.mSizeToSet = new Vec2I(width, height);
        if (!this.ready()) {
            return false;
        }
        try {
            boolean started = this.mStarted;
            if (started) {
                this.close();
                this.start();
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera1: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
    }

    @Override
    public int getNumSupportedFrameRateRange() {
        if (this.mSupportedPreviewFpsRanges == null) {
            return 0;
        }
        return this.mSupportedPreviewFpsRanges.size();
    }

    @Override
    public float getSupportedFrameRateRangeLower(int index) {
        if (this.mSupportedPreviewFpsRanges == null) {
            return 0.0f;
        }
        if (index < 0 || index >= this.mSupportedPreviewFpsRanges.size()) {
            return 0.0f;
        }
        return (float)this.mSupportedPreviewFpsRanges.get(index)[0] / 1000.0f;
    }

    @Override
    public float getSupportedFrameRateRangeUpper(int index) {
        if (this.mSupportedPreviewFpsRanges == null) {
            return 0.0f;
        }
        if (index < 0 || index >= this.mSupportedPreviewFpsRanges.size()) {
            return 0.0f;
        }
        return (float)this.mSupportedPreviewFpsRanges.get(index)[1] / 1000.0f;
    }

    @Override
    public int getFrameRateRange() {
        if (this.mSupportedPreviewFpsRanges == null) {
            return -1;
        }
        return this.mCurrentFpsRange;
    }

    @Override
    public boolean setFrameRateRange(int index) {
        if (this.mSupportedPreviewFpsRanges == null) {
            return false;
        }
        if (index < 0 || index >= this.mSupportedPreviewFpsRanges.size()) {
            return false;
        }
        this.mCurrentFpsRange = index;
        try {
            Camera.Parameters params = this.mCameraDevice.getParameters();
            params.setPreviewFpsRange(this.mSupportedPreviewFpsRanges.get(this.mCurrentFpsRange)[0], this.mSupportedPreviewFpsRanges.get(this.mCurrentFpsRange)[1]);
            this.mCameraDevice.setParameters(params);
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera1: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
    }

    @Override
    public boolean setFlashTorchMode(boolean on) {
        if (!this.ready()) {
            this.mFlashTorchMode = on;
            return false;
        }
        try {
            Camera.Parameters params = this.mCameraDevice.getParameters();
            String mode = null;
            mode = on ? "torch" : "off";
            List supported = this.mCameraDevice.getParameters().getSupportedFlashModes();
            if (supported != null && supported.contains(mode)) {
                params.setFlashMode(mode);
                this.mCameraDevice.setParameters(params);
                this.mFlashTorchMode = on;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera1: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
    }

    @Override
    public boolean setFocusMode(int focusMode) {
        if (!this.ready()) {
            this.mFocusMode = focusMode;
            return false;
        }
        try {
            Camera.Parameters params = this.mCameraDevice.getParameters();
            List modes = params.getSupportedFocusModes();
            switch (focusMode) {
                case 0: {
                    if (modes.contains("auto")) {
                        params.setFocusMode("auto");
                        break;
                    }
                    return false;
                }
                case 2: {
                    if (modes.contains("continuous-picture")) {
                        params.setFocusMode("continuous-picture");
                        break;
                    }
                    if (modes.contains("continuous-video")) {
                        params.setFocusMode("continuous-video");
                        break;
                    }
                    return false;
                }
                case 3: {
                    if (modes.contains("infinity")) {
                        params.setFocusMode("infinity");
                        break;
                    }
                    return false;
                }
                case 4: {
                    if (modes.contains("macro")) {
                        params.setFocusMode("macro");
                        break;
                    }
                    return false;
                }
                case 5: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            this.mFocusMode = focusMode;
            this.mCameraDevice.setParameters(params);
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera1: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
    }

    @Override
    public boolean autoFocus() {
        try {
            this.mCameraDevice.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    if (CameraDeviceCamera.this.mFocusMode != null) {
                        CameraDeviceCamera.this.setFocusMode(CameraDeviceCamera.this.mFocusMode);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Camera1: autoFocus must call after startPreview and in appropriate focus mode");
            return false;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Camera1: \n" + Log.getStackTraceString((Throwable)e)));
            return false;
        }
        return true;
    }

    public boolean ready() {
        return this.mCameraDevice != null;
    }

    private float getRatioError(float x, float x0) {
        float a = x / Math.max(x0, 1.0f) - 1.0f;
        float b = x0 / Math.max(x, 1.0f) - 1.0f;
        return a * a + b * b;
    }

    private Camera.Size getOptimalPreviewSize(int width, int height) {
        Camera.Size s = null;
        float minError = Float.MAX_VALUE;
        for (Camera.Size size : this.mSupportedPreviewSizes) {
            float error = this.getRatioError(width, size.width) + this.getRatioError(height, size.height);
            if (!(error < minError)) continue;
            minError = error;
            s = size;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] data, Camera camera) {
        if (data == null) {
            return;
        }
        Buffer b = null;
        RefBase i = null;
        RefBase inputFrame = null;
        RefBase camParams = null;
        try {
            b = Buffer.wrapByteArray(data);
            i = new Image(b, 2, this.mWidth, this.mHeight);
            double double_timestamp = (double)SystemClock.elapsedRealtimeNanos() * 1.0E-9;
            camParams = this.mCameraParameters.getResized(new Vec2I(this.mWidth, this.mHeight));
            inputFrame = InputFrame.createWithImageAndCameraParametersAndTemporal((Image)i, (CameraParameters)camParams, double_timestamp);
            this.mInputFrameHandler.invoke((InputFrame)inputFrame);
        }
        finally {
            if (camParams != null) {
                camParams.dispose();
            }
            if (inputFrame != null) {
                inputFrame.dispose();
            }
            if (i != null) {
                i.dispose();
            }
            if (b != null) {
                b.dispose();
            }
        }
        if (this.mBufferSize.get() <= this.mBufferCapacity) {
            camera.addCallbackBuffer(data);
        } else {
            this.mBufferSize.getAndDecrement();
        }
    }
}

