/*
 * Decompiled with CFR 0.152.
 */
package cn.easyar.engine;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

class Accelerometer {
    private SensorManager manager_;
    private Sensor sensor_;

    public Accelerometer(Context appContext) {
        this.manager_ = (SensorManager)appContext.getSystemService("sensor");
        this.sensor_ = this.manager_.getDefaultSensor(1);
    }

    public boolean isAvailable() {
        return this.sensor_ != null;
    }

    public IClosable open(int samplingPeriodUs, final IOnUpdated onUpdated) {
        if (this.sensor_ == null) {
            return null;
        }
        final SensorEventListener l = new SensorEventListener(){

            public void onSensorChanged(SensorEvent sensorEvent) {
                onUpdated.invoke(sensorEvent.values[0], sensorEvent.values[1], sensorEvent.values[2], sensorEvent.timestamp);
            }

            public void onAccuracyChanged(Sensor sensor, int i) {
            }
        };
        boolean result = this.manager_.registerListener(l, this.sensor_, samplingPeriodUs);
        if (!result) {
            return null;
        }
        return new IClosable(){

            @Override
            public void close() {
                Accelerometer.this.manager_.unregisterListener(l);
            }
        };
    }

    public static interface IClosable {
        public void close();
    }

    public static class NativeOnUpdated
    implements IOnUpdated {
        public long ptr;

        @Override
        public native void invoke(float var1, float var2, float var3, long var4);
    }

    public static interface IOnUpdated {
        public void invoke(float var1, float var2, float var3, long var4);
    }
}

