/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.dynamite.client;

import android.content.Context;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import com.google.vr.dynamite.client.ILoadedInstanceCreator;
import com.google.vr.dynamite.client.INativeLibraryLoader;
import com.google.vr.dynamite.client.ObjectWrapper;
import com.google.vr.dynamite.client.UsedByNative;
import com.google.vr.dynamite.client.c;
import com.google.vr.dynamite.client.d;
import com.google.vr.dynamite.client.e;
import com.google.vr.dynamite.client.f;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UsedByNative
public final class DynamiteClient {
    private static final ArrayMap<e, d> a = new ArrayMap();

    private DynamiteClient() {
    }

    @UsedByNative
    public static synchronized int checkVersion(Context context, String string2, String string3, String string4) {
        f f2;
        String string5 = string4;
        if (string5 == null || string5.isEmpty()) {
            f2 = null;
        } else {
            Matcher matcher = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)").matcher(string5);
            if (!matcher.matches()) {
                String string6 = String.valueOf(string5);
                Log.w((String)"Version", (String)(string6.length() != 0 ? "Failed to parse version from: ".concat(string6) : new String("Failed to parse version from: ")));
                f2 = null;
            } else {
                f2 = new f(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            }
        }
        if (f2 == null) {
            String string7 = String.valueOf(string4);
            throw new IllegalArgumentException(string7.length() != 0 ? "Improperly formatted minVersion string: ".concat(string7) : new String("Improperly formatted minVersion string: "));
        }
        e e2 = new e(string2, string3);
        d d2 = DynamiteClient.getRemoteLibraryLoaderFromInfo(e2);
        try {
            Context context2 = d2.b(context);
            ILoadedInstanceCreator iLoadedInstanceCreator = d2.a(context);
            INativeLibraryLoader iNativeLibraryLoader = iLoadedInstanceCreator.newNativeLibraryLoader(ObjectWrapper.a(context2), ObjectWrapper.a(context));
            if (iNativeLibraryLoader == null) {
                String string8 = String.valueOf(e2);
                Log.e((String)"DynamiteClient", (String)new StringBuilder(72 + String.valueOf(string8).length()).append("Failed to load native library ").append(string8).append(" from remote package: no loader available.").toString());
                return -1;
            }
            return iNativeLibraryLoader.checkVersion(string4);
        }
        catch (RemoteException | c | IllegalArgumentException | IllegalStateException | SecurityException | UnsatisfiedLinkError throwable) {
            String string9 = String.valueOf(e2);
            Log.e((String)"DynamiteClient", (String)new StringBuilder(54 + String.valueOf(string9).length()).append("Failed to load native library ").append(string9).append(" from remote package:\n  ").toString(), (Throwable)throwable);
            return -1;
        }
    }

    @UsedByNative
    public static synchronized long loadNativeRemoteLibrary(Context context, String string2, String string3) {
        e e2 = new e(string2, string3);
        d d2 = DynamiteClient.getRemoteLibraryLoaderFromInfo(e2);
        try {
            Context context2 = d2.b(context);
            ILoadedInstanceCreator iLoadedInstanceCreator = d2.a(context);
            INativeLibraryLoader iNativeLibraryLoader = iLoadedInstanceCreator.newNativeLibraryLoader(ObjectWrapper.a(context2), ObjectWrapper.a(context));
            if (iNativeLibraryLoader == null) {
                String string4 = String.valueOf(e2);
                Log.e((String)"DynamiteClient", (String)new StringBuilder(72 + String.valueOf(string4).length()).append("Failed to load native library ").append(string4).append(" from remote package: no loader available.").toString());
                return 0L;
            }
            return iNativeLibraryLoader.initializeAndLoadNativeLibrary(string3);
        }
        catch (RemoteException | c | IllegalArgumentException | IllegalStateException | SecurityException | UnsatisfiedLinkError throwable) {
            String string5 = String.valueOf(e2);
            Log.e((String)"DynamiteClient", (String)new StringBuilder(54 + String.valueOf(string5).length()).append("Failed to load native library ").append(string5).append(" from remote package:\n  ").toString(), (Throwable)throwable);
            return 0L;
        }
    }

    @UsedByNative
    public static synchronized ClassLoader getRemoteClassLoader(Context context, String string2, String string3) {
        Context context2 = DynamiteClient.getRemoteContext(context, string2, string3);
        if (context2 == null) {
            return null;
        }
        return context2.getClassLoader();
    }

    @UsedByNative
    public static synchronized ClassLoader getRemoteDexClassLoader(Context context, String string2) {
        Context context2 = DynamiteClient.getRemoteContext(context, string2, null);
        if (context2 == null) {
            return null;
        }
        String string3 = context2.getPackageCodePath();
        try {
            File file = context.getCodeCacheDir();
            return new DexClassLoader(string3, file.getAbsolutePath(), context2.getApplicationInfo().nativeLibraryDir, context.getClassLoader());
        }
        catch (RuntimeException runtimeException) {
            Log.e((String)"DynamiteClient", (String)"Failed to create class loader for remote package\n ", (Throwable)runtimeException);
            return null;
        }
    }

    @UsedByNative
    public static synchronized Context getRemoteContext(Context context, String string2, String string3) {
        e e2 = new e(string2, string3);
        d d2 = DynamiteClient.getRemoteLibraryLoaderFromInfo(e2);
        try {
            return d2.b(context);
        }
        catch (c c2) {
            String string4 = String.valueOf(e2);
            Log.e((String)"DynamiteClient", (String)new StringBuilder(52 + String.valueOf(string4).length()).append("Failed to get remote Context").append(string4).append(" from remote package:\n  ").toString(), (Throwable)c2);
            return null;
        }
    }

    @UsedByNative
    private static synchronized d getRemoteLibraryLoaderFromInfo(e e2) {
        d d2 = (d)a.get((Object)e2);
        if (d2 == null) {
            d2 = new d(e2);
            a.put((Object)e2, (Object)d2);
        }
        return d2;
    }
}

