/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Surface;
import com.google.ar.core.Session;
import com.google.ar.core.ak;
import com.google.ar.core.al;
import com.google.ar.core.aq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SharedCamera {
    private static final String TAG = "ArSdk-SharedCamera";
    private final a sharedCameraInfo = new a(0);
    private boolean cameraSharedWithAr = false;
    private final long sessionNativeHandle;
    private Handler sharedCameraHandler;

    SharedCamera(Session session) {
        HandlerThread handlerThread = new HandlerThread("SharedCameraHandlerThread");
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        this.sharedCameraHandler = new Handler(looper);
        this.sessionNativeHandle = session.nativeHandle;
    }

    private void close() {
        this.sharedCameraHandler.removeCallbacksAndMessages(null);
        this.sharedCameraHandler.getLooper().quit();
        this.sharedCameraHandler = null;
    }

    public void setAppSurfaces(String string2, List<Surface> list) {
        this.sharedCameraInfo.a(string2, list);
        this.nativeSharedCameraSetAppSurfaces(this.sessionNativeHandle, string2, list);
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.sharedCameraInfo.b();
    }

    public List<Surface> getArCoreSurfaces() {
        ArrayList<Surface> arrayList = new ArrayList<Surface>();
        arrayList.add(this.sharedCameraInfo.c());
        ImageReader imageReader = this.getCpuImageReaderMotionTracking();
        if (imageReader != null) {
            arrayList.add(imageReader.getSurface());
        }
        arrayList.add(this.getCpuImageReader().getSurface());
        return arrayList;
    }

    public CameraDevice.StateCallback createARDeviceStateCallback(CameraDevice.StateCallback stateCallback, Handler handler) {
        return new al(this, handler, stateCallback);
    }

    public CameraCaptureSession.StateCallback createARSessionStateCallback(CameraCaptureSession.StateCallback stateCallback, Handler handler) {
        return new aq(this, handler, stateCallback);
    }

    void pause() {
        if (this.sharedCameraInfo.a() != null) {
            this.setDummyListenerToAvoidImageBufferStarvation();
        }
    }

    private void setDummyOnImageAvailableListener(ImageReader imageReader) {
        if (imageReader != null) {
            imageReader.setOnImageAvailableListener(ak.a, this.sharedCameraHandler);
        }
    }

    private void setDummyListenerToAvoidImageBufferStarvation() {
        this.setDummyOnImageAvailableListener(this.getCpuImageReader());
        this.setDummyOnImageAvailableListener(this.getCpuImageReaderMotionTracking());
    }

    private void onDeviceOpened(CameraDevice cameraDevice) {
        this.sharedCameraInfo.a(cameraDevice);
        this.cameraSharedWithAr = true;
        this.nativeSharedCameraOnOpened(this.sessionNativeHandle, cameraDevice);
    }

    private void onDeviceClosed(CameraDevice cameraDevice) {
        this.nativeSharedCameraOnClosed(this.sessionNativeHandle, cameraDevice);
        this.cameraSharedWithAr = false;
    }

    private void onDeviceDisconnected(CameraDevice cameraDevice) {
        this.nativeSharedCameraOnDisconnected(this.sessionNativeHandle, cameraDevice);
        this.cameraSharedWithAr = false;
        this.sharedCameraInfo.a((CameraDevice)null);
    }

    private void onCaptureSessionActive(CameraCaptureSession cameraCaptureSession) {
        this.nativeSharedCameraCaptureSessionActive(this.sessionNativeHandle, cameraCaptureSession);
    }

    private void onCaptureSessionClosed(CameraCaptureSession cameraCaptureSession) {
        this.nativeSharedCameraCaptureSessionClosed(this.sessionNativeHandle, cameraCaptureSession);
    }

    private void onCaptureSessionConfigureFailed(CameraCaptureSession cameraCaptureSession) {
        this.nativeSharedCameraCaptureSessionConfigureFailed(this.sessionNativeHandle, cameraCaptureSession);
    }

    private void onCaptureSessionConfigured(CameraCaptureSession cameraCaptureSession) {
        this.nativeSharedCameraCaptureSessionConfigured(this.sessionNativeHandle, cameraCaptureSession);
    }

    private void onCaptureSessionReady(CameraCaptureSession cameraCaptureSession) {
        this.nativeSharedCameraCaptureSessionReady(this.sessionNativeHandle, cameraCaptureSession);
    }

    private ImageReader getCpuImageReader() {
        return this.nativeSharedCameraGetImageReader(this.sessionNativeHandle, this.sharedCameraInfo.a());
    }

    private ImageReader getCpuImageReaderMotionTracking() {
        return this.nativeSharedCameraGetImageReaderMotionTracking(this.sessionNativeHandle, this.sharedCameraInfo.a());
    }

    private SurfaceTexture getGpuSurfaceTexture() {
        return this.nativeSharedCameraGetSurfaceTexture(this.sessionNativeHandle, this.sharedCameraInfo.a());
    }

    private Surface getGpuSurface() {
        return this.nativeSharedCameraGetSurface(this.sessionNativeHandle, this.sharedCameraInfo.a());
    }

    public void setCaptureCallback(CameraCaptureSession.CaptureCallback captureCallback, Handler handler) {
        this.nativeSharedCameraSetCaptureCallback(this.sessionNativeHandle, captureCallback, handler);
    }

    private native void nativeSharedCameraOnOpened(long var1, CameraDevice var3);

    private native void nativeSharedCameraOnClosed(long var1, CameraDevice var3);

    private native void nativeSharedCameraOnDisconnected(long var1, CameraDevice var3);

    private native ImageReader nativeSharedCameraGetImageReader(long var1, CameraDevice var3);

    private native ImageReader nativeSharedCameraGetImageReaderMotionTracking(long var1, CameraDevice var3);

    private native SurfaceTexture nativeSharedCameraGetSurfaceTexture(long var1, CameraDevice var3);

    private native Surface nativeSharedCameraGetSurface(long var1, CameraDevice var3);

    private native void nativeSharedCameraSetAppSurfaces(long var1, String var3, List<Surface> var4);

    private native void nativeSharedCameraCaptureSessionActive(long var1, CameraCaptureSession var3);

    private native void nativeSharedCameraCaptureSessionClosed(long var1, CameraCaptureSession var3);

    private native void nativeSharedCameraCaptureSessionConfigureFailed(long var1, CameraCaptureSession var3);

    private native void nativeSharedCameraCaptureSessionConfigured(long var1, CameraCaptureSession var3);

    private native void nativeSharedCameraCaptureSessionReady(long var1, CameraCaptureSession var3);

    private native void nativeSharedCameraSetCaptureCallback(long var1, CameraCaptureSession.CaptureCallback var3, Handler var4);

    static final /* synthetic */ void lambda$setDummyOnImageAvailableListener$0$SharedCamera(ImageReader imageReader) {
        Image image = imageReader.acquireLatestImage();
        if (image != null) {
            image.close();
        }
    }

    static /* synthetic */ void access$100(SharedCamera sharedCamera, CameraDevice cameraDevice) {
        sharedCamera.onDeviceClosed(cameraDevice);
    }

    static /* synthetic */ a access$200(SharedCamera sharedCamera) {
        return sharedCamera.sharedCameraInfo;
    }

    static /* synthetic */ void access$300(SharedCamera sharedCamera, CameraDevice cameraDevice) {
        sharedCamera.onDeviceOpened(cameraDevice);
    }

    static /* synthetic */ SurfaceTexture access$400(SharedCamera sharedCamera) {
        return sharedCamera.getGpuSurfaceTexture();
    }

    static /* synthetic */ Surface access$500(SharedCamera sharedCamera) {
        return sharedCamera.getGpuSurface();
    }

    static /* synthetic */ void access$600(SharedCamera sharedCamera, CameraDevice cameraDevice) {
        sharedCamera.onDeviceDisconnected(cameraDevice);
    }

    static /* synthetic */ void access$700(SharedCamera sharedCamera) {
        sharedCamera.close();
    }

    static /* synthetic */ void access$800(SharedCamera sharedCamera, CameraCaptureSession cameraCaptureSession) {
        sharedCamera.onCaptureSessionClosed(cameraCaptureSession);
    }

    static /* synthetic */ void access$900(SharedCamera sharedCamera, CameraCaptureSession cameraCaptureSession) {
        sharedCamera.onCaptureSessionConfigured(cameraCaptureSession);
    }

    static /* synthetic */ void access$1000(SharedCamera sharedCamera) {
        sharedCamera.setDummyListenerToAvoidImageBufferStarvation();
    }

    static /* synthetic */ void access$1100(SharedCamera sharedCamera, CameraCaptureSession cameraCaptureSession) {
        sharedCamera.onCaptureSessionConfigureFailed(cameraCaptureSession);
    }

    static /* synthetic */ void access$1200(SharedCamera sharedCamera, CameraCaptureSession cameraCaptureSession) {
        sharedCamera.onCaptureSessionReady(cameraCaptureSession);
    }

    static /* synthetic */ void access$1300(SharedCamera sharedCamera, CameraCaptureSession cameraCaptureSession) {
        sharedCamera.onCaptureSessionActive(cameraCaptureSession);
    }

    static final class a {
        private CameraDevice a = null;
        private final Map<String, List<Surface>> b = new HashMap<String, List<Surface>>();
        private SurfaceTexture c = null;
        private Surface d = null;

        private a() {
        }

        public final CameraDevice a() {
            return this.a;
        }

        public final void a(CameraDevice cameraDevice) {
            this.a = cameraDevice;
        }

        public final void a(String string2, List<Surface> list) {
            this.b.put(string2, list);
        }

        public final SurfaceTexture b() {
            return this.c;
        }

        public final void a(SurfaceTexture surfaceTexture) {
            this.c = surfaceTexture;
        }

        public final Surface c() {
            return this.d;
        }

        public final void a(Surface surface) {
            this.d = surface;
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

