/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.content.Context;
import android.os.Build;
import com.google.ar.core.Anchor;
import com.google.ar.core.ArImage;
import com.google.ar.core.AugmentedFace;
import com.google.ar.core.AugmentedImage;
import com.google.ar.core.CameraConfig;
import com.google.ar.core.Config;
import com.google.ar.core.Frame;
import com.google.ar.core.ImageMetadata;
import com.google.ar.core.Plane;
import com.google.ar.core.Point;
import com.google.ar.core.Pose;
import com.google.ar.core.SharedCamera;
import com.google.ar.core.Trackable;
import com.google.ar.core.TrackableBase;
import com.google.ar.core.ad;
import com.google.ar.core.ae;
import com.google.ar.core.af;
import com.google.ar.core.ag;
import com.google.ar.core.ah;
import com.google.ar.core.ai;
import com.google.ar.core.annotations.UsedByNative;
import com.google.ar.core.exceptions.AnchorNotSupportedForHostingException;
import com.google.ar.core.exceptions.CameraNotAvailableException;
import com.google.ar.core.exceptions.CloudAnchorsNotConfiguredException;
import com.google.ar.core.exceptions.DataInvalidFormatException;
import com.google.ar.core.exceptions.DataUnsupportedVersionException;
import com.google.ar.core.exceptions.DeadlineExceededException;
import com.google.ar.core.exceptions.FatalException;
import com.google.ar.core.exceptions.ImageInsufficientQualityException;
import com.google.ar.core.exceptions.MissingGlContextException;
import com.google.ar.core.exceptions.NotTrackingException;
import com.google.ar.core.exceptions.NotYetAvailableException;
import com.google.ar.core.exceptions.ResourceExhaustedException;
import com.google.ar.core.exceptions.SessionNotPausedException;
import com.google.ar.core.exceptions.SessionPausedException;
import com.google.ar.core.exceptions.TextureNotSetException;
import com.google.ar.core.exceptions.UnavailableApkTooOldException;
import com.google.ar.core.exceptions.UnavailableArcoreNotInstalledException;
import com.google.ar.core.exceptions.UnavailableDeviceNotCompatibleException;
import com.google.ar.core.exceptions.UnavailableSdkTooOldException;
import com.google.ar.core.exceptions.UnavailableUserDeclinedInstallationException;
import com.google.ar.core.exceptions.UnsupportedConfigurationException;
import com.google.ar.core.i;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Session {
    private static final String TAG = "ARCore-Session";
    private Context context;
    long nativeHandle;
    private final Object syncObject = new Object();
    final i faceCache = new i();
    private SharedCamera sharedCamera = null;

    public Session(Context context) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException {
        System.loadLibrary("arcore_sdk_jni");
        this.context = context;
        this.nativeHandle = Session.nativeCreateSession(context.getApplicationContext());
        Session.loadDynamicSymbolsAfterSessionCreate();
    }

    public Session(Context context, Set<Feature> set) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException, IllegalArgumentException {
        System.loadLibrary("arcore_sdk_jni");
        int[] nArray = new int[set.size() + 1];
        int n2 = 0;
        for (Feature feature : set) {
            nArray[n2] = feature.nativeCode;
            ++n2;
        }
        nArray[n2] = a.a.b;
        this.context = context;
        this.nativeHandle = Session.nativeCreateSessionWithFeatures(context, nArray);
        if (set.contains((Object)Feature.SHARED_CAMERA)) {
            this.sharedCamera = new SharedCamera(this);
        }
        Session.loadDynamicSymbolsAfterSessionCreate();
    }

    Session(long l2) {
        this.nativeHandle = l2;
    }

    protected Session() {
        this.nativeHandle = 0L;
        this.context = null;
    }

    @Deprecated
    public static Session createForSharedCamera(Context context) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException {
        System.loadLibrary("arcore_sdk_jni");
        Session session = new Session();
        new Session().context = context;
        session.nativeHandle = Session.nativeCreateSessionForSharedCamera(context);
        session.sharedCamera = new SharedCamera(session);
        Session.loadDynamicSymbolsAfterSessionCreate();
        return session;
    }

    public SharedCamera getSharedCamera() {
        if (this.sharedCamera == null) {
            throw new IllegalStateException("Shared camera is not in use, please create session using new Session(context, EnumSet.of(Session.Feature.SHARED_CAMERA)).");
        }
        return this.sharedCamera;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            this.nativeDestroySession(this.nativeHandle);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    public void close() {
        this.nativeCloseSession(this.nativeHandle);
    }

    Trackable createTrackable(long l2) {
        c c2;
        c c3;
        block2: {
            int n2 = TrackableBase.internalGetType(this.nativeHandle, l2);
            for (c c4 : c.values()) {
                if (c4.b != n2) continue;
                c3 = c4;
                break block2;
            }
            c3 = c2 = null;
        }
        if (c3 == null) {
            TrackableBase.internalReleaseNativeHandle(l2);
            return null;
        }
        return c2.a(l2, this);
    }

    public void configure(Config config) {
        this.nativeConfigure(this.nativeHandle, config.nativeHandle);
    }

    public Config getConfig() {
        Config config = new Config(this);
        this.getConfig(config);
        return config;
    }

    public void getConfig(Config config) {
        this.nativeGetConfig(this.nativeHandle, config.nativeHandle);
    }

    public void resume() throws CameraNotAvailableException {
        this.nativeResume(this.nativeHandle);
    }

    boolean isSharedCameraUsed() {
        return this.sharedCamera != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame update() throws CameraNotAvailableException {
        Object object = this.syncObject;
        synchronized (object) {
            Frame frame = new Frame(this);
            this.nativeUpdate(this.nativeHandle, frame.nativeHandle);
            return frame;
        }
    }

    public void pause() {
        this.pauseSharedCameraIfInUse();
        this.nativePause(this.nativeHandle);
    }

    private void pauseSharedCameraIfInUse() {
        if (this.sharedCamera != null) {
            this.sharedCamera.pause();
        }
    }

    public void setCameraTextureName(int n2) {
        this.nativeSetCameraTextureName(this.nativeHandle, n2);
    }

    public void setDisplayGeometry(int n2, int n3, int n4) {
        this.nativeSetDisplayGeometry(this.nativeHandle, n2, n3, n4);
    }

    @Deprecated
    public boolean isSupported(Config config) {
        return this.nativeIsSupported(this.nativeHandle, config.nativeHandle);
    }

    public Collection<Anchor> getAllAnchors() {
        return this.convertNativeAnchorsToCollection(this.nativeAcquireAllAnchors(this.nativeHandle));
    }

    public <T extends Trackable> Collection<T> getAllTrackables(Class<T> clazz) {
        c c2 = c.a(clazz);
        if (c2 == c.a) {
            return Collections.emptyList();
        }
        long[] lArray = this.nativeAcquireAllTrackables(this.nativeHandle, c2.b);
        return this.convertNativeTrackablesToCollection(clazz, lArray);
    }

    public Anchor createAnchor(Pose pose) {
        long l2 = this.nativeCreateAnchor(this.nativeHandle, pose);
        return new Anchor(l2, this);
    }

    public Anchor hostCloudAnchor(Anchor anchor) {
        long l2 = this.nativeHostCloudAnchor(this.nativeHandle, anchor.nativeHandle);
        return new Anchor(l2, this);
    }

    public Anchor resolveCloudAnchor(String string2) {
        long l2 = this.nativeResolveCloudAnchor(this.nativeHandle, string2);
        return new Anchor(l2, this);
    }

    Collection<Anchor> convertNativeAnchorsToCollection(long[] lArray) {
        ArrayList<Anchor> arrayList = new ArrayList<Anchor>(lArray.length);
        long[] lArray2 = lArray;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            arrayList.add(new Anchor(l2, this));
        }
        return Collections.unmodifiableList(arrayList);
    }

    <T extends Trackable> Collection<T> convertNativeTrackablesToCollection(Class<T> clazz, long[] lArray) {
        ArrayList<Trackable> arrayList = new ArrayList<Trackable>(lArray.length);
        long[] lArray2 = lArray;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            Trackable trackable = this.createTrackable(l2);
            if (trackable == null) continue;
            arrayList.add((Trackable)clazz.cast(trackable));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<CameraConfig> getSupportedCameraConfigs() {
        long[] lArray = this.nativeGetSupportedCameraConfigs(this.nativeHandle);
        return this.convertNativeCameraConfigsToCollection(lArray);
    }

    public void setCameraConfig(CameraConfig cameraConfig) {
        this.nativeSetCameraConfig(this.nativeHandle, cameraConfig.nativeHandle);
    }

    public CameraConfig getCameraConfig() {
        long l2 = this.nativeGetCameraConfig(this.nativeHandle);
        CameraConfig cameraConfig = new CameraConfig(this, l2);
        return cameraConfig;
    }

    List<CameraConfig> convertNativeCameraConfigsToCollection(long[] lArray) {
        ArrayList<CameraConfig> arrayList = new ArrayList<CameraConfig>(lArray.length);
        long[] lArray2 = lArray;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            CameraConfig cameraConfig = new CameraConfig(this, l2);
            arrayList.add(cameraConfig);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @UsedByNative(value="session_jni.cc")
    static void throwExceptionFromArStatus(int n2) throws Exception {
        b b22;
        block4: {
            int n3 = n2;
            for (b b22 : b.values()) {
                if (b22.j != n3) {
                    continue;
                }
                break block4;
            }
            throw new FatalException(new StringBuilder(34).append("Unexpected error code: ").append(n3).toString());
        }
        b b3 = b22;
        if (b3.k != null) {
            if (b3.l != null) {
                throw b3.k.getConstructor(String.class).newInstance(b3.l);
            }
            throw b3.k.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    static void loadDynamicSymbolsAfterSessionCreate() {
        if (Build.VERSION.SDK_INT >= 24) {
            ArImage.nativeLoadSymbols();
            ImageMetadata.nativeLoadSymbols();
        }
    }

    static ByteBuffer directByteBufferOrDefault(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
        }
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    private static native long nativeCreateSession(Context var0);

    private static native long nativeCreateSessionWithFeatures(Context var0, int[] var1) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException;

    private native void nativeDestroySession(long var1);

    private native void nativeCloseSession(long var1);

    private native boolean nativeIsSupported(long var1, long var3);

    private native void nativeConfigure(long var1, long var3);

    private native void nativeGetConfig(long var1, long var3);

    private native void nativeResume(long var1);

    private native void nativePause(long var1);

    private native void nativeSetCameraTextureName(long var1, int var3);

    private native void nativeSetDisplayGeometry(long var1, int var3, int var4, int var5);

    private native void nativeUpdate(long var1, long var3);

    private native long nativeCreateAnchor(long var1, Pose var3);

    private native long[] nativeAcquireAllAnchors(long var1);

    native long[] nativeAcquireAllTrackables(long var1, int var3);

    private native long nativeHostCloudAnchor(long var1, long var3);

    private native long nativeResolveCloudAnchor(long var1, String var3);

    private native long[] nativeGetSupportedCameraConfigs(long var1);

    private native int nativeSetCameraConfig(long var1, long var3);

    private native long nativeGetCameraConfig(long var1);

    private static native long nativeCreateSessionForSharedCamera(Context var0);

    static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b(0, null);
        public static final /* enum */ b b = new b(-1, IllegalArgumentException.class);
        public static final /* enum */ b c = new b(-2, FatalException.class);
        private static final /* enum */ b m = new b(-3, SessionPausedException.class);
        private static final /* enum */ b n = new b(-4, SessionNotPausedException.class);
        private static final /* enum */ b o = new b(-5, NotTrackingException.class);
        private static final /* enum */ b p = new b(-6, TextureNotSetException.class);
        private static final /* enum */ b q = new b(-7, MissingGlContextException.class);
        private static final /* enum */ b r = new b(-8, UnsupportedConfigurationException.class);
        private static final /* enum */ b s = new b(-9, SecurityException.class, "Camera permission is not granted");
        private static final /* enum */ b t = new b(-10, DeadlineExceededException.class);
        public static final /* enum */ b d = new b(-11, ResourceExhaustedException.class);
        private static final /* enum */ b u = new b(-12, NotYetAvailableException.class);
        private static final /* enum */ b v = new b(-13, CameraNotAvailableException.class);
        private static final /* enum */ b w = new b(-16, AnchorNotSupportedForHostingException.class);
        private static final /* enum */ b x = new b(-17, ImageInsufficientQualityException.class);
        private static final /* enum */ b y = new b(-18, DataInvalidFormatException.class);
        private static final /* enum */ b z = new b(-19, DataUnsupportedVersionException.class);
        private static final /* enum */ b A = new b(-20, IllegalStateException.class);
        private static final /* enum */ b B = new b(-14, CloudAnchorsNotConfiguredException.class);
        private static final /* enum */ b C = new b(-15, SecurityException.class, "Internet permission is not granted");
        public static final /* enum */ b e = new b(-100, UnavailableArcoreNotInstalledException.class);
        public static final /* enum */ b f = new b(-101, UnavailableDeviceNotCompatibleException.class);
        public static final /* enum */ b g = new b(-103, UnavailableApkTooOldException.class);
        public static final /* enum */ b h = new b(-104, UnavailableSdkTooOldException.class);
        public static final /* enum */ b i = new b(-105, UnavailableUserDeclinedInstallationException.class);
        final int j;
        final Class<? extends Exception> k;
        final String l;
        private static final /* synthetic */ b[] D;

        public static b[] values() {
            return (b[])D.clone();
        }

        private b(int n3, Class<? extends Exception> clazz) {
            this(n3, clazz, null);
        }

        private b(int n3, Class<? extends Exception> clazz, String string3) {
            this.j = n3;
            this.k = clazz;
            this.l = string3;
        }

        static {
            D = new b[]{a, b, c, m, n, o, p, q, r, s, t, d, u, v, w, x, y, z, A, B, C, e, f, g, h, i};
        }
    }

    static abstract class c
    extends Enum<c> {
        private static final /* enum */ c c = new ad(1095893248, Trackable.class);
        public static final /* enum */ c a = new ae(-1, null);
        private static final /* enum */ c d = new af(1095893249, Plane.class);
        private static final /* enum */ c e = new ag(1095893250, Point.class);
        private static final /* enum */ c f = new ah(1095893252, AugmentedImage.class);
        private static final /* enum */ c g = new ai(1095893253, AugmentedFace.class);
        final int b;
        private final Class<?> h;
        private static final /* synthetic */ c[] i;

        public static c[] values() {
            return (c[])i.clone();
        }

        private c(int n3, Class<? extends Trackable> clazz) {
            this.b = n3;
            this.h = clazz;
        }

        public abstract Trackable a(long var1, Session var3);

        public static c a(Class<? extends Trackable> clazz) {
            for (c c2 : com.google.ar.core.Session$c.values()) {
                if (c2.h == null || !c2.h.equals(clazz)) continue;
                return c2;
            }
            return a;
        }

        /* synthetic */ c(String string2, int n2, int n3, Class clazz, byte by) {
            this(n3, clazz);
        }

        static {
            i = new c[]{c, a, d, e, f, g};
        }
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a(0);
        final int b;
        private static final /* synthetic */ a[] c;

        public static a[] values() {
            return (a[])c.clone();
        }

        private a(int n3) {
            this.b = 0;
        }

        static {
            c = new a[]{a};
        }
    }

    public static enum Feature {
        FRONT_CAMERA(1),
        SHARED_CAMERA(1000);

        final int nativeCode;

        private Feature(int n3) {
            this.nativeCode = n3;
        }
    }
}

