/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Quaternion;
import com.google.ar.core.annotations.UsedByNative;
import java.util.Locale;

@UsedByNative(value="session_jni_wrapper.cc")
public class Pose {
    public static final Pose IDENTITY = new Pose(new float[]{0.0f, 0.0f, 0.0f}, Quaternion.a);
    @UsedByNative(value="session_jni_wrapper.cc")
    private final Quaternion quaternion;
    @UsedByNative(value="session_jni_wrapper.cc")
    private final float[] translation;

    private Pose(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.quaternion = new Quaternion(f5, f6, f7, f8);
        this.translation = new float[]{f2, f3, f4};
    }

    public Pose(float[] fArray, float[] fArray2) {
        this(fArray[0], fArray[1], fArray[2], fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
    }

    @UsedByNative(value="session_jni_wrapper.cc")
    private Pose(float[] fArray, Quaternion quaternion) {
        this.translation = fArray;
        this.quaternion = quaternion;
    }

    public static Pose makeTranslation(float f2, float f3, float f4) {
        return new Pose(new float[]{f2, f3, f4}, Pose.IDENTITY.quaternion);
    }

    public static Pose makeTranslation(float[] fArray) {
        return Pose.makeTranslation(fArray[0], fArray[1], fArray[2]);
    }

    public static Pose makeRotation(float f2, float f3, float f4, float f5) {
        return new Pose(Pose.IDENTITY.translation, new Quaternion(f2, f3, f4, f5));
    }

    public static Pose makeRotation(float[] fArray) {
        return Pose.makeRotation(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public Pose compose(Pose pose) {
        Pose pose2 = this;
        float[] fArray = new float[3];
        Quaternion.a(pose2.quaternion, pose.translation, 0, fArray, 0);
        fArray[0] = fArray[0] + pose2.translation[0];
        fArray[1] = fArray[1] + pose2.translation[1];
        fArray[2] = fArray[2] + pose2.translation[2];
        return new Pose(fArray, pose2.quaternion.a(pose.quaternion));
    }

    public static Pose makeInterpolated(Pose pose, Pose pose2, float f2) {
        if (f2 == 0.0f) {
            return pose;
        }
        if (f2 == 1.0f) {
            return pose2;
        }
        float[] fArray = new float[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            fArray[i2] = pose.translation[i2] * (1.0f - f2) + pose2.translation[i2] * f2;
        }
        Quaternion quaternion = Quaternion.a(pose.quaternion, pose2.quaternion, f2);
        return new Pose(fArray, quaternion);
    }

    public Pose inverse() {
        float[] fArray = new float[3];
        Quaternion quaternion = this.quaternion.e();
        Quaternion.a(quaternion, this.translation, 0, fArray, 0);
        fArray[0] = -fArray[0];
        fArray[1] = -fArray[1];
        fArray[2] = -fArray[2];
        return new Pose(fArray, quaternion);
    }

    public Pose extractRotation() {
        return new Pose(Pose.IDENTITY.translation, this.quaternion);
    }

    public Pose extractTranslation() {
        return new Pose(this.translation, Pose.IDENTITY.quaternion);
    }

    public void toMatrix(float[] fArray, int n2) {
        this.quaternion.a(fArray, n2, 4);
        fArray[n2 + 12] = this.translation[0];
        fArray[n2 + 1 + 12] = this.translation[1];
        fArray[n2 + 2 + 12] = this.translation[2];
        fArray[n2 + 3] = 0.0f;
        fArray[n2 + 7] = 0.0f;
        fArray[n2 + 11] = 0.0f;
        fArray[n2 + 15] = 1.0f;
    }

    public float tx() {
        return this.translation[0];
    }

    public float ty() {
        return this.translation[1];
    }

    public float tz() {
        return this.translation[2];
    }

    public float qx() {
        return this.quaternion.a();
    }

    public float qy() {
        return this.quaternion.b();
    }

    public float qz() {
        return this.quaternion.c();
    }

    public float qw() {
        return this.quaternion.d();
    }

    public void getTranslation(float[] fArray, int n2) {
        System.arraycopy(this.translation, 0, fArray, n2, 3);
    }

    public float[] getTranslation() {
        float[] fArray = new float[3];
        this.getTranslation(fArray, 0);
        return fArray;
    }

    public void getRotationQuaternion(float[] fArray, int n2) {
        this.quaternion.a(fArray, n2);
    }

    public float[] getRotationQuaternion() {
        float[] fArray = new float[4];
        this.getRotationQuaternion(fArray, 0);
        return fArray;
    }

    public void rotateVector(float[] fArray, int n2, float[] fArray2, int n3) {
        Quaternion.a(this.quaternion, fArray, n2, fArray2, n3);
    }

    public float[] rotateVector(float[] fArray) {
        float[] fArray2 = new float[3];
        this.rotateVector(fArray, 0, fArray2, 0);
        return fArray2;
    }

    public void transformPoint(float[] fArray, int n2, float[] fArray2, int n3) {
        this.rotateVector(fArray, n2, fArray2, n3);
        for (int i2 = 0; i2 < 3; ++i2) {
            int n4 = i2 + n3;
            fArray2[n4] = fArray2[n4] + this.translation[i2];
        }
    }

    public float[] transformPoint(float[] fArray) {
        float[] fArray2 = new float[3];
        this.transformPoint(fArray, 0, fArray2, 0);
        return fArray2;
    }

    public void getTransformedAxis(int n2, float f2, float[] fArray, int n3) {
        int n4 = n3;
        float[] fArray2 = fArray;
        float f3 = f2;
        int n5 = n2;
        Quaternion quaternion = this.quaternion;
        float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f};
        float[] fArray4 = fArray3;
        fArray3[n5] = f3;
        Quaternion.a(quaternion, fArray4, 0, fArray2, n4);
    }

    public float[] getTransformedAxis(int n2, float f2) {
        float[] fArray = new float[3];
        this.getTransformedAxis(n2, f2, fArray, 0);
        return fArray;
    }

    public float[] getXAxis() {
        return this.getTransformedAxis(0, 1.0f);
    }

    public float[] getYAxis() {
        return this.getTransformedAxis(1, 1.0f);
    }

    public float[] getZAxis() {
        return this.getTransformedAxis(2, 1.0f);
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "t:[x:%.3f, y:%.3f, z:%.3f], q:[x:%.2f, y:%.2f, z:%.2f, w:%.2f]", Float.valueOf(this.translation[0]), Float.valueOf(this.translation[1]), Float.valueOf(this.translation[2]), Float.valueOf(this.quaternion.a()), Float.valueOf(this.quaternion.b()), Float.valueOf(this.quaternion.c()), Float.valueOf(this.quaternion.d()));
    }

    Quaternion getQuaternion() {
        return this.quaternion;
    }
}

