/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.TrackableBase;
import com.google.ar.core.exceptions.FatalException;

public class Point
extends TrackableBase {
    Point(long l2, Session session) {
        super(l2, session);
    }

    protected Point() {
        super(0L, null);
    }

    Pose getPose() {
        return this.nativeGetPose(this.session.nativeHandle, this.nativeHandle);
    }

    public OrientationMode getOrientationMode() {
        return OrientationMode.fromNumber(this.nativeGetOrientationMode(this.session.nativeHandle, this.nativeHandle));
    }

    private native Pose nativeGetPose(long var1, long var3);

    private native int nativeGetOrientationMode(long var1, long var3);

    public static enum OrientationMode {
        INITIALIZED_TO_IDENTITY(0),
        ESTIMATED_SURFACE_NORMAL(1);

        private final int nativeCode;

        private OrientationMode(int n3) {
            this.nativeCode = n3;
        }

        static OrientationMode fromNumber(int n2) {
            for (OrientationMode orientationMode : OrientationMode.values()) {
                if (orientationMode.nativeCode != n2) continue;
                return orientationMode;
            }
            throw new FatalException(new StringBuilder(69).append("Unexpected value for native Point Orientation Mode, value=").append(n2).toString());
        }
    }
}

