/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;

public class LightEstimate {
    private final Session session;
    long nativeHandle = 0L;

    LightEstimate(Session session) {
        this.session = session;
        this.nativeHandle = LightEstimate.nativeCreateLightEstimate(session.nativeHandle);
    }

    protected LightEstimate() {
        this.session = null;
        this.nativeHandle = 0L;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            LightEstimate.nativeDestroyLightEstimate(this.nativeHandle);
        }
        super.finalize();
    }

    public State getState() {
        return State.forNumber(this.nativeGetState(this.session.nativeHandle, this.nativeHandle));
    }

    public float getPixelIntensity() {
        return this.nativeGetPixelIntensity(this.session.nativeHandle, this.nativeHandle);
    }

    public void getColorCorrection(float[] fArray, int n2) {
        this.nativeGetColorCorrection(this.session.nativeHandle, this.nativeHandle, fArray, n2);
    }

    private static native long nativeCreateLightEstimate(long var0);

    private static native void nativeDestroyLightEstimate(long var0);

    private native int nativeGetState(long var1, long var3);

    private native float nativeGetPixelIntensity(long var1, long var3);

    private native void nativeGetColorCorrection(long var1, long var3, float[] var5, int var6);

    public static enum State {
        NOT_VALID(0),
        VALID(1);

        final int nativeCode;

        private State(int n3) {
            this.nativeCode = n3;
        }

        static State forNumber(int n2) {
            for (State state : State.values()) {
                if (state.nativeCode != n2) continue;
                return state;
            }
            throw new FatalException(new StringBuilder(66).append("Unexpected value for native LightEstimate.State, value=").append(n2).toString());
        }
    }
}

