/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Anchor;
import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.Trackable;

public class HitResult {
    private final Session session;
    long nativeHandle;

    HitResult(long l2, Session session) {
        this.session = session;
        this.nativeHandle = l2;
    }

    protected HitResult() {
        this.session = null;
        this.nativeHandle = 0L;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        HitResult hitResult = (HitResult)object;
        return hitResult.nativeHandle == this.nativeHandle;
    }

    public int hashCode() {
        return Long.valueOf(this.nativeHandle).hashCode();
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            HitResult.nativeDestroyHitResult(this.nativeHandle);
        }
        super.finalize();
    }

    public Pose getHitPose() {
        return this.nativeGetPose(this.session.nativeHandle, this.nativeHandle);
    }

    public float getDistance() {
        return this.nativeGetDistance(this.session.nativeHandle, this.nativeHandle);
    }

    public Trackable getTrackable() {
        long l2 = this.nativeAcquireTrackable(this.session.nativeHandle, this.nativeHandle);
        return this.session.createTrackable(l2);
    }

    public Anchor createAnchor() {
        long l2 = this.nativeCreateAnchor(this.session.nativeHandle, this.nativeHandle);
        return new Anchor(l2, this.session);
    }

    private static native void nativeDestroyHitResult(long var0);

    private native Pose nativeGetPose(long var1, long var3);

    private native float nativeGetDistance(long var1, long var3);

    native long nativeAcquireTrackable(long var1, long var3);

    private native long nativeCreateAnchor(long var1, long var3);
}

