/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.util.Size;
import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;

public class CameraConfig {
    final Session session;
    long nativeHandle;

    CameraConfig(Session session, long l2) {
        this.session = session;
        this.nativeHandle = l2;
    }

    protected CameraConfig() {
        this.session = null;
        this.nativeHandle = 0L;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            CameraConfig.nativeDestroyCameraConfig(this.nativeHandle);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    public Size getImageSize() {
        int[] nArray = new int[2];
        this.nativeGetImageDimensions(this.session.nativeHandle, this.nativeHandle, nArray);
        return new Size(nArray[0], nArray[1]);
    }

    public Size getTextureSize() {
        int[] nArray = new int[2];
        this.nativeGetTextureDimensions(this.session.nativeHandle, this.nativeHandle, nArray);
        return new Size(nArray[0], nArray[1]);
    }

    public String getCameraId() {
        return this.nativeGetCameraId(this.session.nativeHandle, this.nativeHandle);
    }

    public FacingDirection getFacingDirection() {
        return FacingDirection.forNumber(this.nativeGetFacingDirection(this.session.nativeHandle, this.nativeHandle));
    }

    private static native void nativeDestroyCameraConfig(long var0);

    private native void nativeGetImageDimensions(long var1, long var3, int[] var5);

    private native void nativeGetTextureDimensions(long var1, long var3, int[] var5);

    private native String nativeGetCameraId(long var1, long var3);

    private native int nativeGetFacingDirection(long var1, long var3);

    public static enum FacingDirection {
        BACK(0),
        FRONT(1);

        final int nativeCode;

        private FacingDirection(int n3) {
            this.nativeCode = n3;
        }

        static FacingDirection forNumber(int n2) {
            for (FacingDirection facingDirection : FacingDirection.values()) {
                if (facingDirection.nativeCode != n2) continue;
                return facingDirection;
            }
            throw new FatalException(new StringBuilder(62).append("Unexpected value for native FacingDirection, value=").append(n2).toString());
        }
    }
}

