/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.TrackingState;
import com.google.ar.core.exceptions.FatalException;

public class Anchor {
    private final Session session;
    long nativeHandle;

    Anchor(long l2, Session session) {
        this.session = session;
        this.nativeHandle = l2;
    }

    protected Anchor() {
        this.session = null;
        this.nativeHandle = 0L;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Anchor anchor = (Anchor)object;
        return anchor.nativeHandle == this.nativeHandle;
    }

    public int hashCode() {
        return Long.valueOf(this.nativeHandle).hashCode();
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            Anchor.nativeReleaseAnchor(this.nativeHandle);
        }
        super.finalize();
    }

    public Pose getPose() {
        return this.nativeGetPose(this.session.nativeHandle, this.nativeHandle);
    }

    public TrackingState getTrackingState() {
        return TrackingState.forNumber(this.nativeGetTrackingState(this.session.nativeHandle, this.nativeHandle));
    }

    public String getCloudAnchorId() {
        return this.nativeGetCloudAnchorId(this.session.nativeHandle, this.nativeHandle);
    }

    public CloudAnchorState getCloudAnchorState() {
        return CloudAnchorState.forNumber(this.nativeGetCloudAnchorState(this.session.nativeHandle, this.nativeHandle));
    }

    public void detach() {
        this.nativeDetach(this.session.nativeHandle, this.nativeHandle);
    }

    private static native void nativeReleaseAnchor(long var0);

    private native Pose nativeGetPose(long var1, long var3);

    private native int nativeGetTrackingState(long var1, long var3);

    private native void nativeDetach(long var1, long var3);

    private native String nativeGetCloudAnchorId(long var1, long var3);

    private native int nativeGetCloudAnchorState(long var1, long var3);

    public static enum CloudAnchorState {
        NONE(0),
        TASK_IN_PROGRESS(1),
        SUCCESS(2),
        ERROR_INTERNAL(-1),
        ERROR_NOT_AUTHORIZED(-2),
        ERROR_SERVICE_UNAVAILABLE(-3),
        ERROR_RESOURCE_EXHAUSTED(-4),
        ERROR_HOSTING_DATASET_PROCESSING_FAILED(-5),
        ERROR_CLOUD_ID_NOT_FOUND(-6),
        ERROR_RESOLVING_LOCALIZATION_NO_MATCH(-7),
        ERROR_RESOLVING_SDK_VERSION_TOO_OLD(-8),
        ERROR_RESOLVING_SDK_VERSION_TOO_NEW(-9);

        final int nativeCode;

        private CloudAnchorState(int n3) {
            this.nativeCode = n3;
        }

        public final boolean isError() {
            return this.nativeCode < 0;
        }

        public static CloudAnchorState forNumber(int n2) {
            for (CloudAnchorState cloudAnchorState : CloudAnchorState.values()) {
                if (cloudAnchorState.nativeCode != n2) continue;
                return cloudAnchorState;
            }
            throw new FatalException(new StringBuilder(63).append("Unexpected value for native CloudAnchorState, value=").append(n2).toString());
        }
    }
}

