---
layout: default
title: "Animate"
permalink: /guide/animate/
---

# Animate
When you select the Animate tab, a timeline window will show up at the bottom of your screen.

[picture here]()


Animation is performed by creating **keyframes** and **interpolating** between them.

### Posing
Once you have [rigged](../rig) an object with a skeleton, it can now be posed by selecting a joint and changing its pose i.e., joint rotation.
Once you've implemented **inverse kinematics** and **skinning**, as you change the pose, the mesh will deform. 

[picture/video here](TODO)

Different poses can be set as keyframes to animate the object.

### Keyframes
A keyframe associates an object's pose with a specific frame in the timeline.
Keyframes can be associated with all the objects (including the camera and rig joints associated with an object) in the scene.

To create a keyframe for an object:

- Select a frame location along that objects timeline by clicking on the timeline. Remember to do this *before* editing the pose.
- Change the pose of the selected object and press `Set`. To associate keyframes with all the objects, use `Set All`.  Note that for rig joints, only joint rotation can be performed.
- Click on a keyframe in the timeline, and press `Clear` to remove it. 


[gif/video here](TODO)

To see your animation, press `Play [space]` . Once you've implemented **spline interpolation**,  intermediate frames are generated by interpolating object poses between keyframes.

Check `Draw Splines` to visualize the spline along which objects are animated.
[picture here](TODO)

`Add Frames` inserts 90 empty frames into the timeline. `Crop End` deletes frames from the selected location to the end of the timeline.


