---
layout: default
title: "Animate"
permalink: /guide/animate_mode/
parent: User Guide
---

# Animate

When you select the Animate tab, a timeline window will show up at the bottom of your screen.
Animation is performed by creating **keyframes** and **interpolating** between them.

### Keyframes
A keyframe associates an object's pose and properties with a specific frame in the timeline.
Keyframes can be associated with all objects (including the camera and individual joints associated with an object) in the scene.

To create a keyframe for an object:

- Select a frame location along that objects timeline by clicking on the timeline. Remember to do this *before* editing the pose.
- Change the pose or properties of the selected object and press `Set`. To set a keyframe for every object in the scene, use `Set All`. Note that only the poses (rotations) of joints can be animated, not their extents.

To remove a keyframe in the timeline, click on it and press `Clear` to remove it. Press `Clear All` to clear the current keyframe of every object in the scene.

![animating-cow](../../animation/task1_media/animate_cow.gif)

To see your animation, press `Play [space]` . Once you've implemented **spline interpolation**,  intermediate frames are generated by interpolating object poses between keyframes.

Check `Draw Splines` to visualize the spline along which objects are animated.

![view-spline](../animate_mode/guide-animate-spline.png)

`Add Frames` inserts 90 empty frames into the timeline. `Crop End` deletes frames from the selected location to the end of the timeline.

### Posing
Once you have [rigged](../rig) an object with a skeleton, it can now be posed by selecting a joint and changing its pose i.e., rotating the joint. This is called Forward Kinematics.
Joint poses can also be indirectly changed by using the IK (Inverse Kinematics) handles to provide target positions.
Note that IK handles need to be explicitly enabled using the checkbox.

Once you've implemented **forward kinematics**, **inverse kinematics** and **skinning**, as you change the pose, the mesh will deform.
Different poses can be set as keyframes to animate the object.

<video src="{{ site.baseurl }}/guide/animate_mode/guide-posing-rig.mp4" controls preload muted loop style="max-width: 100%; margin: 0 auto;"></video>

