package emu.grasscutter.server.packet.send;

import java.util.List;

import emu.grasscutter.data.common.ItemParamData;
import emu.grasscutter.game.gacha.GachaBanner;
import emu.grasscutter.game.gacha.PlayerGachaBannerInfo;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.packet.PacketOpcodes;
import emu.grasscutter.net.proto.DoGachaRspOuterClass.DoGachaRsp;
import emu.grasscutter.net.proto.GachaItemOuterClass.GachaItem;
import emu.grasscutter.net.proto.RetcodeOuterClass.Retcode;
import emu.grasscutter.net.proto.RetcodeOuterClass;

public class PacketDoGachaRsp extends BasePacket {
	
	public PacketDoGachaRsp(GachaBanner banner, List<GachaItem> list, PlayerGachaBannerInfo gachaInfo) {
		super(PacketOpcodes.DoGachaRsp);

		ItemParamData costItem = banner.getCost(1);
		ItemParamData costItem10 = banner.getCost(10);
		DoGachaRsp.Builder rsp = DoGachaRsp.newBuilder()
				.setGachaType(banner.getGachaType())
				.setGachaScheduleId(banner.getScheduleId())
				.setGachaTimes(list.size())
				.setNewGachaRandom(12345)
				.setLeftGachaTimes(Integer.MAX_VALUE)
				.setCostItemId(costItem.getId())
	            .setCostItemNum(costItem.getCount())
	            .setTenCostItemId(costItem10.getId())
	            .setTenCostItemNum(costItem10.getCount())
	            .addAllGachaItemList(list);

		if(banner.hasEpitomized()) {
			rsp.setWishItemId(gachaInfo.getWishItemId())
				.setWishProgress(gachaInfo.getFailedChosenItemPulls())
				.setWishMaxProgress(banner.getWishMaxProgress());
		}
		
		this.setData(rsp.build());
	}

	public PacketDoGachaRsp() {
		super(PacketOpcodes.DoGachaRsp);

		DoGachaRsp p = DoGachaRsp.newBuilder()
				.setRetcode(RetcodeOuterClass.Retcode.RET_SVR_ERROR_VALUE)
				.build();
		
		this.setData(p);
	}

	public PacketDoGachaRsp(Retcode retcode) {
		super(PacketOpcodes.DoGachaRsp);

		DoGachaRsp p = DoGachaRsp.newBuilder()
				.setRetcode(retcode.getNumber())
				.build();

		this.setData(p);
	}
}
