/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http.staticfiles;

import io.javalin.Javalin;
import io.javalin.core.util.Util;
import io.javalin.http.JavalinResponseWrapper;
import io.javalin.http.staticfiles.AliasHandler;
import io.javalin.http.staticfiles.PrecompressingResourceHandler;
import io.javalin.http.staticfiles.PrefixableHandler;
import io.javalin.http.staticfiles.ResourceHandler;
import io.javalin.http.staticfiles.StaticFileConfig;
import io.javalin.http.staticfiles.WebjarHandler;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\u00020\u0003*\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u0003*\u0004\u0018\u00010\u0018H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lio/javalin/http/staticfiles/JettyResourceHandler;", "Lio/javalin/http/staticfiles/ResourceHandler;", "precompressStaticFiles", "", "aliasCheck", "Lorg/eclipse/jetty/server/handler/ContextHandler$AliasCheck;", "(ZLorg/eclipse/jetty/server/handler/ContextHandler$AliasCheck;)V", "handlers", "", "Lorg/eclipse/jetty/server/handler/ResourceHandler;", "getHandlers", "()Ljava/util/List;", "getPrecompressStaticFiles", "()Z", "addStaticFileConfig", "", "config", "Lio/javalin/http/staticfiles/StaticFileConfig;", "handle", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "httpResponse", "Ljavax/servlet/http/HttpServletResponse;", "isDirectoryWithWelcomeFile", "Lorg/eclipse/jetty/util/resource/Resource;", "handler", "target", "", "isFile", "javalin"})
public final class JettyResourceHandler
implements ResourceHandler {
    @NotNull
    private final List<org.eclipse.jetty.server.handler.ResourceHandler> handlers;
    private final boolean precompressStaticFiles;
    private final ContextHandler.AliasCheck aliasCheck;

    @NotNull
    public final List<org.eclipse.jetty.server.handler.ResourceHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    public void addStaticFileConfig(@NotNull StaticFileConfig config) {
        Intrinsics.checkParameterIsNotNull(config, "config");
        org.eclipse.jetty.server.handler.ResourceHandler resourceHandler = Intrinsics.areEqual(config.getPath(), "/webjars") ? (org.eclipse.jetty.server.handler.ResourceHandler)new WebjarHandler() : (this.aliasCheck != null ? (org.eclipse.jetty.server.handler.ResourceHandler)new AliasHandler(config, this.aliasCheck) : (org.eclipse.jetty.server.handler.ResourceHandler)new PrefixableHandler(config));
        List<org.eclipse.jetty.server.handler.ResourceHandler> list = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        org.eclipse.jetty.server.handler.ResourceHandler $this$apply = resourceHandler;
        boolean bl3 = false;
        $this$apply.start();
        org.eclipse.jetty.server.handler.ResourceHandler resourceHandler2 = resourceHandler;
        list.add(resourceHandler2);
    }

    @Override
    public boolean handle(@NotNull HttpServletRequest httpRequest, @NotNull HttpServletResponse httpResponse) {
        Intrinsics.checkParameterIsNotNull(httpRequest, "httpRequest");
        Intrinsics.checkParameterIsNotNull(httpResponse, "httpResponse");
        Object object = httpRequest.getAttribute("jetty-target");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String target = (String)object;
        Object object2 = httpRequest.getAttribute("jetty-request");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.eclipse.jetty.server.Request");
        }
        Request baseRequest = (Request)object2;
        for (org.eclipse.jetty.server.handler.ResourceHandler handler : this.handlers) {
            try {
                Resource resource = handler.getResource(target);
                if (!this.isFile(resource) && !this.isDirectoryWithWelcomeFile(resource, handler, target)) continue;
                int maxAge = StringsKt.startsWith$default(target, "/immutable/", false, 2, null) || handler instanceof WebjarHandler ? 31622400 : 0;
                httpResponse.setHeader("Cache-Control", "max-age=" + maxAge);
                if (this.precompressStaticFiles) {
                    Resource resource2 = resource;
                    Intrinsics.checkExpressionValueIsNotNull(resource2, "resource");
                    if (PrecompressingResourceHandler.INSTANCE.handle(resource2, httpRequest, httpResponse)) {
                        return true;
                    }
                }
                httpResponse.setContentType(null);
                handler.handle(target, baseRequest, httpRequest, httpResponse);
                httpRequest.setAttribute("handled-as-static-file", true);
                HttpServletResponse httpServletResponse = httpResponse;
                if (httpServletResponse == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.javalin.http.JavalinResponseWrapper");
                }
                ((JavalinResponseWrapper)httpServletResponse).getOutputStream().finalize();
                return true;
            }
            catch (Exception e) {
                if (Util.INSTANCE.isClientAbortException(e)) continue;
                Logger logger = Javalin.log;
                if (logger == null) continue;
                logger.info("Exception occurred while handling static resource", (Throwable)e);
            }
        }
        return false;
    }

    private final boolean isFile(@Nullable Resource $this$isFile) {
        return $this$isFile != null && $this$isFile.exists() && !$this$isFile.isDirectory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDirectoryWithWelcomeFile(@Nullable Resource $this$isDirectoryWithWelcomeFile, org.eclipse.jetty.server.handler.ResourceHandler handler, String target) {
        if ($this$isDirectoryWithWelcomeFile == null) return false;
        if (!$this$isDirectoryWithWelcomeFile.isDirectory()) return false;
        Resource resource = handler.getResource(StringsKt.removeSuffix(target, (CharSequence)"/") + "/index.html");
        if (resource == null) return false;
        if (!resource.exists()) return false;
        return true;
    }

    public final boolean getPrecompressStaticFiles() {
        return this.precompressStaticFiles;
    }

    public JettyResourceHandler(boolean precompressStaticFiles, @Nullable ContextHandler.AliasCheck aliasCheck) {
        List list;
        this.precompressStaticFiles = precompressStaticFiles;
        this.aliasCheck = aliasCheck;
        JettyResourceHandler jettyResourceHandler = this;
        boolean bl = false;
        jettyResourceHandler.handlers = list = (List)new ArrayList();
    }

    public /* synthetic */ JettyResourceHandler(boolean bl, ContextHandler.AliasCheck aliasCheck, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            aliasCheck = null;
        }
        this(bl, aliasCheck);
    }

    public JettyResourceHandler() {
        this(false, null, 3, null);
    }
}

