/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.security;

import io.javalin.core.security.Role;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.util.ContextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J'\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\r\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u0010"}, d2={"Lio/javalin/core/security/SecurityUtil;", "", "()V", "noopAccessManager", "", "handler", "Lio/javalin/http/Handler;", "ctx", "Lio/javalin/http/Context;", "permittedRoles", "", "Lio/javalin/core/security/Role;", "roles", "", "([Lio/javalin/core/security/Role;)Ljava/util/Set;", "sslRedirect", "javalin"})
public final class SecurityUtil {
    public static final SecurityUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final Set<Role> roles(Role ... roles) {
        Intrinsics.checkParameterIsNotNull(roles, "roles");
        return SetsKt.setOf(Arrays.copyOf(roles, roles.length));
    }

    @JvmStatic
    public static final void noopAccessManager(@NotNull Handler handler, @NotNull Context ctx, @NotNull Set<? extends Role> permittedRoles) {
        Intrinsics.checkParameterIsNotNull(handler, "handler");
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        Intrinsics.checkParameterIsNotNull(permittedRoles, "permittedRoles");
        Collection collection = permittedRoles;
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new IllegalStateException("No access manager configured. Add an access manager using 'Javalin.create(c -> c.accessManager(...))'.");
        }
        handler.handle(ctx);
    }

    @JvmStatic
    public static final void sslRedirect(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        if (ContextUtil.INSTANCE.isLocalhost(ctx)) {
            return;
        }
        String xForwardedProto = ctx.header("x-forwarded-proto");
        if (Intrinsics.areEqual(xForwardedProto, "http") || xForwardedProto == null && Intrinsics.areEqual(ctx.scheme(), "http")) {
            ctx.redirect(StringsKt.replace$default(ctx.fullUrl(), "http", "https", false, 4, null), 301);
        }
    }

    private SecurityUtil() {
    }

    static {
        SecurityUtil securityUtil;
        INSTANCE = securityUtil = new SecurityUtil();
    }
}

