/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.HashedWheelTimer;
import io.netty.util.TimerTask;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kcp.highway.ChannelConfig;
import kcp.highway.IChannelManager;
import kcp.highway.KcpListener;
import kcp.highway.KcpOutPutImp;
import kcp.highway.ScheduleTask;
import kcp.highway.ServerConvChannelManager;
import kcp.highway.Ukcp;
import kcp.highway.User;
import kcp.highway.erasure.fec.Fec;
import kcp.highway.threadPool.IMessageExecutor;
import kcp.highway.threadPool.IMessageExecutorPool;
import kcp.highway.threadPool.ITask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerChannelHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ServerChannelHandler.class);
    private final ServerConvChannelManager channelManager;
    private final ChannelConfig channelConfig;
    private final IMessageExecutorPool iMessageExecutorPool;
    private final KcpListener kcpListener;
    private final HashedWheelTimer hashedWheelTimer;
    private final ConcurrentLinkedQueue<HandshakeWaiter> handshakeWaiters = new ConcurrentLinkedQueue();
    private final SecureRandom secureRandom = new SecureRandom();

    public void handshakeWaitersAppend(HandshakeWaiter handshakeWaiter) {
        if (this.handshakeWaiters.size() > 10) {
            this.handshakeWaiters.poll();
        }
        this.handshakeWaiters.add(handshakeWaiter);
    }

    public void handshakeWaitersRemove(HandshakeWaiter handshakeWaiter) {
        this.handshakeWaiters.remove(handshakeWaiter);
    }

    public HandshakeWaiter handshakeWaitersFind(long conv) {
        for (HandshakeWaiter waiter : this.handshakeWaiters) {
            if (waiter.convId != conv) continue;
            return waiter;
        }
        return null;
    }

    public HandshakeWaiter handshakeWaitersFind(InetSocketAddress address) {
        for (HandshakeWaiter waiter : this.handshakeWaiters) {
            if (!waiter.address.equals(address)) continue;
            return waiter;
        }
        return null;
    }

    public static void handleEnet(ByteBuf data, Ukcp ukcp, User user, long conv) {
        if (data == null || data.readableBytes() != 20) {
            return;
        }
        int code = data.readInt();
        data.readUnsignedInt();
        data.readUnsignedInt();
        int enet = data.readInt();
        data.readUnsignedInt();
        try {
            switch (code) {
                case 255: {
                    if (user == null) break;
                    Ukcp.sendHandshakeRsp(user, enet, conv);
                    break;
                }
                case 404: {
                    if (ukcp == null) break;
                    ukcp.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ServerChannelHandler(IChannelManager channelManager, ChannelConfig channelConfig, IMessageExecutorPool iMessageExecutorPool, KcpListener kcpListener, HashedWheelTimer hashedWheelTimer) {
        this.channelManager = (ServerConvChannelManager)channelManager;
        this.channelConfig = channelConfig;
        this.iMessageExecutorPool = iMessageExecutorPool;
        this.kcpListener = kcpListener;
        this.hashedWheelTimer = hashedWheelTimer;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object object) {
        ChannelConfig channelConfig = this.channelConfig;
        DatagramPacket msg = (DatagramPacket)object;
        ByteBuf byteBuf = (ByteBuf)msg.content();
        User user = new User(ctx.channel(), (InetSocketAddress)msg.sender(), (InetSocketAddress)msg.recipient());
        Ukcp ukcp = this.channelManager.get(msg);
        if (byteBuf.readableBytes() == 20) {
            long convId;
            HandshakeWaiter waiter = this.handshakeWaitersFind(user.getRemoteAddress());
            if (waiter == null) {
                ServerConvChannelManager serverConvChannelManager = this.channelManager;
                synchronized (serverConvChannelManager) {
                    while (this.channelManager.convExists(convId = this.secureRandom.nextLong()) || this.handshakeWaitersFind(convId) != null) {
                    }
                }
                this.handshakeWaitersAppend(new HandshakeWaiter(convId, user.getRemoteAddress()));
            } else {
                convId = waiter.convId;
            }
            ServerChannelHandler.handleEnet(byteBuf, ukcp, user, convId);
            msg.release();
            return;
        }
        boolean newConnection = false;
        IMessageExecutor iMessageExecutor = this.iMessageExecutorPool.getIMessageExecutor();
        if (ukcp == null) {
            HandshakeWaiter waiter = this.handshakeWaitersFind(byteBuf.getLong(0));
            if (waiter == null) {
                msg.release();
                return;
            }
            this.handshakeWaitersRemove(waiter);
            int sn = this.getSn(byteBuf, channelConfig);
            if (sn != 0) {
                msg.release();
                return;
            }
            KcpOutPutImp kcpOutput = new KcpOutPutImp();
            Ukcp newUkcp = new Ukcp(kcpOutput, this.kcpListener, iMessageExecutor, channelConfig, this.channelManager);
            newUkcp.user(user);
            newUkcp.setConv(waiter.convId);
            this.channelManager.New(msg.sender(), newUkcp, msg);
            this.hashedWheelTimer.newTimeout((TimerTask)new ScheduleTask(iMessageExecutor, newUkcp, this.hashedWheelTimer), (long)newUkcp.getInterval(), TimeUnit.MILLISECONDS);
            ukcp = newUkcp;
            newConnection = true;
        }
        iMessageExecutor.execute(new UckpEventSender(newConnection, ukcp, byteBuf, (InetSocketAddress)msg.sender()));
    }

    private int getSn(ByteBuf byteBuf, ChannelConfig channelConfig) {
        int headerSize = 0;
        if (channelConfig.getFecAdapt() != null) {
            headerSize += Fec.fecHeaderSizePlus2;
        }
        return byteBuf.getIntLE(byteBuf.readerIndex() + 16 + headerSize);
    }

    record HandshakeWaiter(long convId, InetSocketAddress address) {
    }

    static class UckpEventSender
    implements ITask {
        private final boolean newConnection;
        private final Ukcp uckp;
        private final ByteBuf byteBuf;
        private final InetSocketAddress sender;

        UckpEventSender(boolean newConnection, Ukcp ukcp, ByteBuf byteBuf, InetSocketAddress sender) {
            this.newConnection = newConnection;
            this.uckp = ukcp;
            this.byteBuf = byteBuf;
            this.sender = sender;
        }

        @Override
        public void execute() {
            if (this.newConnection) {
                try {
                    this.uckp.getKcpListener().onConnected(this.uckp);
                }
                catch (Throwable throwable) {
                    this.uckp.getKcpListener().handleException(throwable, this.uckp);
                }
            }
            this.uckp.user().setRemoteAddress(this.sender);
            this.uckp.read(this.byteBuf);
        }
    }
}

