/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.TimerTask;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kcp.highway.ChannelConfig;
import kcp.highway.ClientAddressChannelManager;
import kcp.highway.ClientChannelHandler;
import kcp.highway.ClientConvChannelManager;
import kcp.highway.Crc32Decode;
import kcp.highway.Crc32Encode;
import kcp.highway.IChannelManager;
import kcp.highway.KcpListener;
import kcp.highway.KcpOutPutImp;
import kcp.highway.ScheduleTask;
import kcp.highway.Ukcp;
import kcp.highway.User;
import kcp.highway.erasure.fec.Fec;
import kcp.highway.threadPool.IMessageExecutor;
import kcp.highway.threadPool.IMessageExecutorPool;

public class KcpClient {
    private IMessageExecutorPool iMessageExecutorPool;
    private Bootstrap bootstrap;
    private EventLoopGroup nioEventLoopGroup;
    private IChannelManager channelManager;
    private HashedWheelTimer hashedWheelTimer;

    public void init(final ChannelConfig channelConfig) {
        if (channelConfig.isUseConvChannel()) {
            int convIndex = 0;
            if (channelConfig.getFecAdapt() != null) {
                convIndex += Fec.fecHeaderSizePlus2;
            }
            this.channelManager = new ClientConvChannelManager(convIndex);
        } else {
            this.channelManager = new ClientAddressChannelManager();
        }
        this.iMessageExecutorPool = channelConfig.getiMessageExecutorPool();
        this.nioEventLoopGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors());
        this.hashedWheelTimer = new HashedWheelTimer((ThreadFactory)new TimerThreadFactory(), 1L, TimeUnit.MILLISECONDS);
        this.bootstrap = new Bootstrap();
        this.bootstrap.channel(NioDatagramChannel.class);
        this.bootstrap.group(this.nioEventLoopGroup);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

            protected void initChannel(NioDatagramChannel ch) {
                ChannelPipeline cp = ch.pipeline();
                if (channelConfig.isCrc32Check()) {
                    Crc32Encode crc32Encode = new Crc32Encode();
                    Crc32Decode crc32Decode = new Crc32Decode();
                    cp.addLast(new ChannelHandler[]{crc32Encode});
                    cp.addLast(new ChannelHandler[]{crc32Decode});
                }
                cp.addLast(new ChannelHandler[]{new ClientChannelHandler(KcpClient.this.channelManager)});
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stop()));
    }

    public void reconnect(Ukcp ukcp) {
        if (!(this.channelManager instanceof ClientConvChannelManager)) {
            throw new UnsupportedOperationException("reconnect can only be used in convChannel");
        }
        ukcp.getiMessageExecutor().execute(() -> {
            User user = ukcp.user();
            user.getChannel().close();
            InetSocketAddress localAddress = new InetSocketAddress(0);
            ChannelFuture channelFuture = this.bootstrap.connect((SocketAddress)user.getRemoteAddress(), (SocketAddress)localAddress);
            user.setChannel(channelFuture.channel());
        });
    }

    public Ukcp connect(InetSocketAddress localAddress, InetSocketAddress remoteAddress, ChannelConfig channelConfig, KcpListener kcpListener) {
        if (localAddress == null) {
            localAddress = new InetSocketAddress(0);
        }
        ChannelFuture channelFuture = this.bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)localAddress);
        ChannelFuture sync = channelFuture.syncUninterruptibly();
        NioDatagramChannel channel = (NioDatagramChannel)sync.channel();
        localAddress = channel.localAddress();
        User user = new User((Channel)channel, remoteAddress, localAddress);
        IMessageExecutor iMessageExecutor = this.iMessageExecutorPool.getIMessageExecutor();
        KcpOutPutImp kcpOutput = new KcpOutPutImp();
        Ukcp ukcp = new Ukcp(kcpOutput, kcpListener, iMessageExecutor, channelConfig, this.channelManager);
        ukcp.user(user);
        this.channelManager.New(localAddress, ukcp, null);
        iMessageExecutor.execute(() -> {
            try {
                ukcp.getKcpListener().onConnected(ukcp);
            }
            catch (Throwable throwable) {
                ukcp.getKcpListener().handleException(throwable, ukcp);
            }
        });
        ScheduleTask scheduleTask = new ScheduleTask(iMessageExecutor, ukcp, this.hashedWheelTimer);
        this.hashedWheelTimer.newTimeout((TimerTask)scheduleTask, (long)ukcp.getInterval(), TimeUnit.MILLISECONDS);
        return ukcp;
    }

    public Ukcp connect(InetSocketAddress remoteAddress, ChannelConfig channelConfig, KcpListener kcpListener) {
        return this.connect(null, remoteAddress, channelConfig, kcpListener);
    }

    public void stop() {
        this.channelManager.getAll().forEach(ukcp -> {
            try {
                ukcp.close();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        });
        if (this.iMessageExecutorPool != null) {
            this.iMessageExecutorPool.stop();
        }
        if (this.nioEventLoopGroup != null) {
            this.nioEventLoopGroup.shutdownGracefully();
        }
        if (this.hashedWheelTimer != null) {
            this.hashedWheelTimer.stop();
        }
    }

    public IChannelManager getChannelManager() {
        return this.channelManager;
    }

    private static class TimerThreadFactory
    implements ThreadFactory {
        private AtomicInteger timeThreadName = new AtomicInteger(0);

        private TimerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "KcpClientTimerThread " + this.timeThreadName.addAndGet(1));
            return thread;
        }
    }
}

