/*
 * Decompiled with CFR 0.152.
 */
package nosqlite;

import com.aventrix.jnanoid.jnanoid.NanoIdUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nosqlite.DbHelper;
import nosqlite.annotations.Id;
import nosqlite.annotations.Transient;
import nosqlite.exceptions.IdAnnotationMissingException;
import nosqlite.exceptions.TypeMismatchException;
import nosqlite.handlers.DeleteOptions;
import nosqlite.handlers.DeleteOptionsHandler;
import nosqlite.handlers.FindOptions;
import nosqlite.handlers.FindOptionsHandler;
import nosqlite.handlers.WatchHandler;

public class Collection {
    private Class klass;
    private String collName;
    private DbHelper db;
    private ObjectMapper mapper = new ObjectMapper();
    private String idField;
    private boolean hasTransient = false;

    Collection(DbHelper db, Class klass, String collName) {
        this.klass = klass;
        this.db = db;
        this.collName = collName;
        if (klass == null) {
            this.idField = "_id";
        } else {
            for (Field field : klass.getDeclaredFields()) {
                if (field.isAnnotationPresent(Transient.class)) {
                    this.hasTransient = true;
                }
                if (!field.isAnnotationPresent(Id.class)) continue;
                this.idField = field.getName();
            }
            if (this.idField == null) {
                try {
                    throw new IdAnnotationMissingException("No @Id in " + collName);
                }
                catch (IdAnnotationMissingException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        db.run("create", "CREATE TABLE IF NOT EXISTS " + collName + "(key TEXT PRIMARY KEY UNIQUE NOT NULL, value JSON NOT NULL)", klass, collName);
    }

    public Connection conn() {
        return this.db.conn;
    }

    public void close() {
        this.db.close();
    }

    public <T> T get(String key, Class<T> klass) {
        String json2 = this.get(key);
        if (json2 == null) {
            return null;
        }
        return this.JSONparse(json2, klass);
    }

    public String get(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String query = "SELECT value FROM " + this.collName + " WHERE key = ?";
        Object[] params = new Object[]{key};
        return this.db.get(query, params);
    }

    public String put(String key, Object value) {
        boolean exists = this.get(key) != null;
        boolean isJson = false;
        if (value instanceof String) {
            Object[] params = new Object[]{value};
            isJson = this.db.get("SELECT json_valid(?)", params).equals("1");
        }
        if (!isJson) {
            value = this.JSONstringify(value);
        }
        String query = String.format("INSERT INTO %s values(?, json(?))ON CONFLICT(key) DO UPDATE SET value=json(excluded.value)", this.collName);
        Object[] params = new Object[]{key, value};
        return this.db.run(exists ? "insert" : "update", query, params, this.klass, this.collName);
    }

    public String putIfAbsent(String key, Object value) {
        boolean exists;
        boolean bl = exists = this.get(key) != null;
        if (exists) {
            return '\'' + key + "' already exists";
        }
        return this.put(key, value);
    }

    public String remove(String key) {
        String query = String.format("DELETE FROM %1$s WHERE key = ?", this.collName);
        Object[] params = new Object[]{key};
        return this.db.run("delete", query, params, this.klass, this.collName);
    }

    public String save(String json2) {
        String exists;
        if (json2 == null) {
            throw new NullPointerException();
        }
        Object[] jsonParams = new Object[]{json2, "$." + this.idField};
        String jsonId = this.db.get("SELECT json_extract(json(?), ?)", jsonParams);
        if (jsonId == null) {
            Map<String, String> field = this.klass == null ? this.getIdField(new HashMap()) : this.getIdField();
            jsonId = field.get("id");
        }
        if (json2.equals(exists = this.get(jsonId))) {
            return json2;
        }
        String query = String.format("INSERT INTO %s VALUES(?, json(json_set(?, '$.%s', ?))) ON CONFLICT(key) DO UPDATE SET value=json(excluded.value)", this.collName, this.idField);
        Object[] params = new Object[]{jsonId, json2, jsonId};
        return this.db.run(exists != null ? "update" : "insert", query, params, this.klass, this.collName);
    }

    public <T> T save(Object document) {
        String exists;
        if (document == null) {
            throw new NullPointerException();
        }
        if (document.getClass() != this.klass) {
            try {
                throw new TypeMismatchException(String.format("'%s' cannot be saved in a '%s' collection", document.getClass().getSimpleName(), this.collName));
            }
            catch (TypeMismatchException e) {
                e.printStackTrace();
                return null;
            }
        }
        List<Object[]> transientFields = this.getTransientFields(document);
        Map<String, String> field = this.getIdField(document);
        String json2 = this.JSONstringify(document);
        if (json2.equals(exists = this.get(field.get("id")))) {
            return (T)document;
        }
        String query = String.format("INSERT INTO %s VALUES(?, json(?)) ON CONFLICT(key) DO UPDATE SET value=json(excluded.value)", this.collName);
        Object[] params = new Object[]{field.get("id"), json2};
        this.db.run(exists != null ? "update" : "insert", query, params, this.klass, this.collName);
        this.setTransientFields(document, transientFields);
        return (T)document;
    }

    public <T> List<T> save(List<T> documents) {
        return Arrays.asList(this.save(documents.toArray()));
    }

    public <T> T[] save(Object[] documents) {
        return this.saveMany(documents);
    }

    public <T> T[] saveMany(Object[] documents) {
        if (documents == null) {
            throw new NullPointerException();
        }
        HashMap<Object, List<Object[]>> documentsTransientFields = new HashMap<Object, List<Object[]>>();
        boolean isJson = false;
        if (documents instanceof String[] || documents[0] instanceof String) {
            Object[] params = new Object[]{documents[0]};
            isJson = this.db.get("SELECT json_valid(?)", params).equals("1");
        }
        if (!isJson) {
            for (Object doc : documents) {
                if (doc == null) {
                    throw new NullPointerException();
                }
                if (doc.getClass() != this.klass) {
                    try {
                        System.out.println(doc.getClass());
                        System.out.println(this.klass);
                        throw new TypeMismatchException(String.format("'%s' cannot be saved in a '%s' collection", documents[0].getClass().getSimpleName(), this.collName));
                    }
                    catch (TypeMismatchException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                if (!this.hasTransient) continue;
                documentsTransientFields.put(doc, this.getTransientFields(doc));
            }
        }
        String q = "INSERT INTO " + this.collName + " VALUES(?, json(?)) ON CONFLICT(key) DO UPDATE SET value=json(excluded.value)";
        this.db.run("queryMany", q, documents, this.klass, this.collName);
        if (!isJson && this.hasTransient) {
            for (Object doc : documents) {
                this.setTransientFields(doc, (List)documentsTransientFields.get(doc));
            }
        }
        return documents;
    }

    public <T> List<T> find() {
        return this.find(null, null, 0, 0);
    }

    public <T> List<T> find(int limit, int offset) {
        return this.find(null, null, limit, offset);
    }

    public <T> List<T> find(String filter) {
        return this.find(filter, null, 0, 0);
    }

    public <T> List<T> find(String filter, int limit) {
        return this.find(filter, null, limit, 0);
    }

    public <T> List<T> find(String filter, int limit, int offset) {
        return this.find(filter, null, limit, offset);
    }

    public <T> List<T> find(String filter, String sort, int limit, int offset) {
        String jsonArray = this.findAsJson(filter, sort, limit, offset);
        if (jsonArray == null || jsonArray.equals("[]")) {
            return new ArrayList();
        }
        try {
            return (List)this.mapper.readValue(jsonArray, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, this.klass));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }

    public <T> List<T> find(FindOptionsHandler option) {
        FindOptions op = new FindOptions();
        option.handle(op);
        return this.find(op.filter, op.sort, op.limit, op.offset);
    }

    public <T> T findOne(String filter) {
        List<T> docs = this.find(filter, 1);
        return docs.size() > 0 ? (T)docs.get(0) : null;
    }

    public String findAsJson(FindOptionsHandler option) {
        FindOptions op = new FindOptions();
        option.handle(op);
        return this.findAsJson(op.filter, op.sort, op.limit, op.offset);
    }

    public String findAsJson() {
        return this.findAsJson(null, null, 0, 0);
    }

    public String findAsJson(int limit, int offset) {
        return this.findAsJson(null, null, limit, offset);
    }

    public String findAsJson(String filter) {
        return this.findAsJson(filter, null, 0, 0);
    }

    public String findAsJson(String filter, int limit, int offset) {
        return this.findAsJson(filter, null, limit, offset);
    }

    public String findAsJson(String filter, String sort, int limit, int offset) {
        String json2 = this.db.findAsJson(this.collName, filter, sort, limit, offset);
        if (json2 == null) {
            return "[]";
        }
        return "[" + json2 + "]";
    }

    public String findOneAsJson(String filter) {
        return this.db.findAsJson(this.collName, filter, null, 1, 0);
    }

    public <T> T findById(String id) {
        String json2 = this.findByIdAsJson(id);
        if (json2 == null) {
            return null;
        }
        try {
            return this.mapper.readValue(json2, this.klass);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String findByIdAsJson(String id) {
        return this.get(id);
    }

    public String delete(Object document) {
        if (document == null) {
            throw new NullPointerException();
        }
        Map<String, String> field = this.getIdField(document);
        return this.deleteById(field.get("id"));
    }

    public String deleteById(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        return this.delete("key=" + id);
    }

    public String deleteOne(String filter) {
        return this.db.deleteDocs(this.collName, filter, 1, this.klass);
    }

    public String delete(String filter) {
        return this.db.deleteDocs(this.collName, filter, 0, this.klass);
    }

    public String delete() {
        return this.db.deleteDocs(this.collName, null, 0, this.klass);
    }

    public String delete(DeleteOptionsHandler option) {
        DeleteOptions op = new DeleteOptions();
        option.handle(op);
        return this.db.deleteDocs(this.collName, op.filter, op.limit, this.klass);
    }

    public String updateFieldById(String id, String field, Object value) {
        if (id == null) {
            throw new NullPointerException();
        }
        return this.updateField(id, field, value);
    }

    public String updateField(Object document, String field, Object value) {
        Map<String, String> idField = this.getIdField(document);
        if (this.get(idField.get("id")) == null) {
            throw new NullPointerException();
        }
        return this.updateFieldById(idField.get("id"), field, value);
    }

    public String updateField(String field, Object value) {
        return this.updateField(null, field, value);
    }

    public String updateField(String filter, String field, Object value) {
        Object[] params;
        if (field == null) {
            throw new NullPointerException();
        }
        boolean isJson = false;
        if (!(value instanceof String) && !value.getClass().isPrimitive()) {
            value = this.JSONstringify(value);
            params = new Object[]{value};
            isJson = this.db.get("SELECT json_valid(?)", params).equals("1");
        }
        if (filter != null) {
            params = new Object[]{"$." + field, filter};
            String oldValue = this.db.get("SELECT json_extract(value, ?) FROM " + this.collName + " WHERE key = ?", params);
            if (value.equals(oldValue)) {
                return "same value";
            }
        }
        if (filter != null && filter.matches("[\\w_]+")) {
            params = new Object[]{"$." + field, value, filter};
            return this.db.run("update", "UPDATE " + this.collName + " SET value = json_replace(value, ?, " + (isJson ? "json(?)" : "?") + ") WHERE key = ?", params, this.klass, this.collName);
        }
        String query = "UPDATE " + this.collName + " SET value = json_replace(value, ?, " + (isJson ? "json(?))" : "?)");
        List params2 = new ArrayList<Object>();
        if (filter != null) {
            Map<String, List<String>> filters = this.db.generateWhereClause(filter);
            params2 = this.db.populateParams(filters);
            query = query + filters.get("query").get(0);
        }
        params2.add(0, value);
        params2.add(0, "$." + field);
        return this.db.run("update", query, params2.toArray(), this.klass, this.collName);
    }

    public String removeField(String field) {
        Object[] params = new Object[]{"$." + field};
        return this.db.run("update", "UPDATE " + this.collName + " SET value = json_remove(value, ?)", params, this.klass, this.collName);
    }

    public String changeFieldName(String newField, String oldField) {
        Object[] params1 = new Object[]{"$." + newField};
        String fieldTaken = this.db.get("SELECT json_extract(value, ?) FROM " + this.collName + " LIMIT 1", params1);
        if (fieldTaken != null) {
            System.err.printf("Field '%s' is already in use in document '%s'\n", newField, this.collName);
            return null;
        }
        Object[] params2 = new Object[]{"$." + newField, "$." + oldField};
        this.db.run("update", String.format("UPDATE %1$s SET value = json_insert(value, ?, json_extract(value, ?))", this.collName), params2, this.klass, this.collName);
        Object[] params3 = new Object[]{"$." + oldField};
        return this.db.run("update", String.format("UPDATE %1$s SET value = json_remove(value, ?)", this.collName), params3, this.klass, this.collName);
    }

    public int count() {
        try {
            PreparedStatement stmt = this.db.conn.prepareStatement("SELECT count(*) FROM " + this.collName);
            ResultSet rs = stmt.executeQuery();
            return rs.getInt(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void watch(WatchHandler watcher) {
        this.db.watch(this.collName, watcher);
    }

    public void watch(String event, WatchHandler watcher) {
        this.db.watch(this.collName, event, watcher);
    }

    private String JSONstringify(Object value) {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T2> T2 JSONparse(String json2, Class<T2> klass) {
        try {
            return this.mapper.readValue(json2, klass);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Object[]> getTransientFields(Object document) {
        if (!this.hasTransient) {
            return null;
        }
        ArrayList<Object[]> transientFields = new ArrayList<Object[]>();
        try {
            for (Field field : document.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Transient.class)) continue;
                field.setAccessible(true);
                Object[] transientField = new Object[]{field.getName(), field.get(document)};
                transientFields.add(transientField);
                field.set(document, null);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        return transientFields;
    }

    private void setTransientFields(Object document, List<Object[]> transientFields) {
        if (!this.hasTransient) {
            return;
        }
        try {
            for (Object[] fieldMap : transientFields) {
                Field field = document.getClass().getDeclaredField((String)fieldMap[0]);
                field.setAccessible(true);
                field.set(document, fieldMap[1]);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getIdField() {
        try {
            return this.getIdField(this.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Map<String, String> getIdField(Object model) {
        HashMap<String, String> idValues = new HashMap<String, String>();
        if (model instanceof Map) {
            idValues.put("name", "_id");
            idValues.put("id", NanoIdUtils.randomNanoId());
            return idValues;
        }
        if (this.idField != null) {
            try {
                Field field = model.getClass().getDeclaredField(this.idField);
                field.setAccessible(true);
                if (field.get(model) == null) {
                    field.set(model, NanoIdUtils.randomNanoId());
                }
                idValues.put("name", field.getName());
                idValues.put("id", (String)field.get(model));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        } else {
            try {
                for (Field field : model.getClass().getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Id.class)) continue;
                    field.setAccessible(true);
                    if (field.get(model) == null) {
                        field.set(model, NanoIdUtils.randomNanoId());
                    }
                    idValues.put("name", field.getName());
                    idValues.put("id", (String)field.get(model));
                    break;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return idValues;
    }
}

