/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;
import kcp.highway.Ukcp;
import kcp.highway.threadPool.IMessageExecutor;
import kcp.highway.threadPool.ITask;

public class ScheduleTask
implements ITask,
Runnable,
TimerTask {
    private final IMessageExecutor messageExecutor;
    private final Ukcp ukcp;
    private final HashedWheelTimer hashedWheelTimer;

    public ScheduleTask(IMessageExecutor messageExecutor, Ukcp ukcp, HashedWheelTimer hashedWheelTimer) {
        this.messageExecutor = messageExecutor;
        this.ukcp = ukcp;
        this.hashedWheelTimer = hashedWheelTimer;
    }

    @Override
    public void execute() {
        try {
            Ukcp ukcp = this.ukcp;
            long now = System.currentTimeMillis();
            if (ukcp.getTimeoutMillis() != 0L && now - ukcp.getTimeoutMillis() > ukcp.getLastRecieveTime()) {
                ukcp.internalClose();
            }
            if (!ukcp.isActive()) {
                return;
            }
            long timeLeft = ukcp.getTsUpdate() - now;
            if (timeLeft > 0L) {
                this.hashedWheelTimer.newTimeout((TimerTask)this, timeLeft, TimeUnit.MILLISECONDS);
                return;
            }
            long next = ukcp.flush(now);
            this.hashedWheelTimer.newTimeout((TimerTask)this, next, TimeUnit.MILLISECONDS);
            if (!ukcp.getWriteBuffer().isEmpty() && ukcp.canSend(false)) {
                ukcp.notifyWriteEvent();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.messageExecutor.execute(this);
    }

    public void run(Timeout timeout) {
        this.run();
    }
}

