/*
 * Decompiled with CFR 0.152.
 */
package org.reflections8.scanners;

import java.util.Optional;
import java.util.function.Predicate;
import org.reflections8.Configuration;
import org.reflections8.ReflectionsException;
import org.reflections8.adapters.MetadataAdapter;
import org.reflections8.scanners.Scanner;
import org.reflections8.util.AlwaysTruePredicate;
import org.reflections8.util.SetMultimap;
import org.reflections8.vfs.Vfs;

public abstract class AbstractScanner
implements Scanner {
    private Configuration configuration;
    private SetMultimap<String, String> store;
    private Predicate<String> resultFilter = new AlwaysTruePredicate<String>();

    @Override
    public boolean acceptsInput(String file) {
        return this.getMetadataAdapter().acceptsInput(file);
    }

    @Override
    public Object scan(Vfs.File file, Optional<Object> classObject) {
        if (!classObject.isPresent()) {
            try {
                classObject = Optional.of(this.configuration.getMetadataAdapter().getOrCreateClassObject(file));
            }
            catch (Exception e) {
                throw new ReflectionsException("could not create class object from file " + file.getRelativePath(), e);
            }
        }
        this.scan(classObject.get());
        return classObject.get();
    }

    public abstract void scan(Object var1);

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public SetMultimap<String, String> getStore() {
        return this.store;
    }

    @Override
    public void setStore(SetMultimap<String, String> store) {
        this.store = store;
    }

    public Predicate<String> getResultFilter() {
        return this.resultFilter;
    }

    public void setResultFilter(Predicate<String> resultFilter) {
        this.resultFilter = resultFilter;
    }

    @Override
    public Scanner filterResultsBy(Predicate<String> filter) {
        this.setResultFilter(filter);
        return this;
    }

    @Override
    public boolean acceptResult(String fqn) {
        return fqn != null && this.resultFilter.test(fqn);
    }

    protected MetadataAdapter getMetadataAdapter() {
        return this.configuration.getMetadataAdapter();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

