/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.apibuilder;

import io.javalin.Javalin;
import io.javalin.apibuilder.CrudFunction;
import io.javalin.apibuilder.CrudHandler;
import io.javalin.apibuilder.CrudHandlerKt;
import io.javalin.apibuilder.EndpointGroup;
import io.javalin.core.security.Role;
import io.javalin.http.Handler;
import io.javalin.http.sse.SseClient;
import io.javalin.websocket.WsHandler;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ApiBuilder {
    private static final ThreadLocal<Javalin> staticJavalin = new ThreadLocal();
    private static final ThreadLocal<Deque<String>> pathDeque = ThreadLocal.withInitial(ArrayDeque::new);

    public static void setStaticJavalin(@NotNull Javalin javalin) {
        staticJavalin.set(javalin);
    }

    public static void clearStaticJavalin() {
        staticJavalin.remove();
    }

    public static void path(@NotNull String path, @NotNull EndpointGroup endpointGroup) {
        path = path.startsWith("/") ? path : "/" + path;
        pathDeque.get().addLast(path);
        endpointGroup.addEndpoints();
        pathDeque.get().removeLast();
    }

    public static String prefixPath(@NotNull String path) {
        return String.join((CharSequence)"", (Iterable<? extends CharSequence>)pathDeque.get()) + (path.startsWith("/") || path.isEmpty() ? path : "/" + path);
    }

    public static Javalin staticInstance() {
        Javalin javalin = staticJavalin.get();
        if (javalin == null) {
            throw new IllegalStateException("The static API can only be used within a routes() call.");
        }
        return javalin;
    }

    public static void get(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(path), handler);
    }

    public static void get(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void get(@NotNull Handler handler) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(""), handler);
    }

    public static void get(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void post(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(path), handler);
    }

    public static void post(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void post(@NotNull Handler handler) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(""), handler);
    }

    public static void post(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void put(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(path), handler);
    }

    public static void put(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void put(@NotNull Handler handler) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(""), handler);
    }

    public static void put(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void patch(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(path), handler);
    }

    public static void patch(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void patch(@NotNull Handler handler) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(""), handler);
    }

    public static void patch(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void delete(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(path), handler);
    }

    public static void delete(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void delete(@NotNull Handler handler) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(""), handler);
    }

    public static void delete(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void head(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().head(ApiBuilder.prefixPath(path), handler);
    }

    public static void head(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().head(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void head(@NotNull Handler handler) {
        ApiBuilder.staticInstance().head(ApiBuilder.prefixPath(""), handler);
    }

    public static void head(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().head(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void before(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().before(ApiBuilder.prefixPath(path), handler);
    }

    public static void before(@NotNull Handler handler) {
        ApiBuilder.staticInstance().before(ApiBuilder.prefixPath("/*"), handler);
    }

    public static void after(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().after(ApiBuilder.prefixPath(path), handler);
    }

    public static void after(@NotNull Handler handler) {
        ApiBuilder.staticInstance().after(ApiBuilder.prefixPath("/*"), handler);
    }

    public static void ws(@NotNull String path, @NotNull Consumer<WsHandler> ws) {
        ApiBuilder.staticInstance().ws(ApiBuilder.prefixPath(path), ws);
    }

    public static void ws(@NotNull String path, @NotNull Consumer<WsHandler> ws, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().ws(ApiBuilder.prefixPath(path), ws, permittedRoles);
    }

    public static void ws(@NotNull Consumer<WsHandler> ws) {
        ApiBuilder.staticInstance().ws(ApiBuilder.prefixPath(""), ws);
    }

    public static void ws(@NotNull Consumer<WsHandler> ws, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().ws(ApiBuilder.prefixPath(""), ws, permittedRoles);
    }

    public Javalin wsBefore(@NotNull String path, @NotNull Consumer<WsHandler> wsHandler) {
        return ApiBuilder.staticInstance().wsBefore(ApiBuilder.prefixPath(path), wsHandler);
    }

    public Javalin wsBefore(@NotNull Consumer<WsHandler> wsHandler) {
        return ApiBuilder.staticInstance().wsBefore(ApiBuilder.prefixPath("/*"), wsHandler);
    }

    public Javalin wsAfter(@NotNull String path, @NotNull Consumer<WsHandler> wsHandler) {
        return ApiBuilder.staticInstance().wsAfter(ApiBuilder.prefixPath(path), wsHandler);
    }

    public Javalin wsAfter(@NotNull Consumer<WsHandler> wsHandler) {
        return ApiBuilder.staticInstance().wsAfter(ApiBuilder.prefixPath("/*"), wsHandler);
    }

    public static void sse(@NotNull String path, @NotNull Consumer<SseClient> client) {
        ApiBuilder.staticInstance().sse(ApiBuilder.prefixPath(path), client);
    }

    public static void sse(@NotNull String path, @NotNull Consumer<SseClient> client, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().sse(ApiBuilder.prefixPath(path), client, permittedRoles);
    }

    public static void sse(@NotNull Consumer<SseClient> client) {
        ApiBuilder.staticInstance().sse(ApiBuilder.prefixPath(""), client);
    }

    public static void sse(@NotNull Consumer<SseClient> client, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().sse(ApiBuilder.prefixPath(""), client, permittedRoles);
    }

    public static void crud(@NotNull CrudHandler crudHandler) {
        ApiBuilder.crud("", crudHandler, new HashSet<Role>());
    }

    public static void crud(@NotNull CrudHandler crudHandler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.crud("", crudHandler, permittedRoles);
    }

    public static void crud(@NotNull String path, @NotNull CrudHandler crudHandler) {
        ApiBuilder.crud(path, crudHandler, new HashSet<Role>());
    }

    public static void crud(@NotNull String path, @NotNull CrudHandler crudHandler, @NotNull Set<Role> permittedRoles) {
        String fullPath = ApiBuilder.prefixPath(path);
        String[] subPaths = (String[])Arrays.stream(fullPath.split("/")).filter(it -> !it.isEmpty()).toArray(String[]::new);
        if (subPaths.length < 2) {
            throw new IllegalArgumentException("CrudHandler requires a path like '/resource/:resource-id'");
        }
        String resourceId = subPaths[subPaths.length - 1];
        if (!resourceId.startsWith(":")) {
            throw new IllegalArgumentException("CrudHandler requires a path-parameter at the end of the provided path, e.g. '/users/:user-id'");
        }
        if (subPaths[subPaths.length - 2].startsWith(":")) {
            throw new IllegalArgumentException("CrudHandler requires a resource base at the beginning of the provided path, e.g. '/users/:user-id'");
        }
        Map<CrudFunction, Handler> crudFunctions = CrudHandlerKt.getCrudFunctions(crudHandler, resourceId);
        ApiBuilder.staticInstance().get(fullPath, crudFunctions.get((Object)CrudFunction.GET_ONE), permittedRoles);
        ApiBuilder.staticInstance().get(fullPath.replace(resourceId, ""), crudFunctions.get((Object)CrudFunction.GET_ALL), permittedRoles);
        ApiBuilder.staticInstance().post(fullPath.replace(resourceId, ""), crudFunctions.get((Object)CrudFunction.CREATE), permittedRoles);
        ApiBuilder.staticInstance().patch(fullPath, crudFunctions.get((Object)CrudFunction.UPDATE), permittedRoles);
        ApiBuilder.staticInstance().delete(fullPath, crudFunctions.get((Object)CrudFunction.DELETE), permittedRoles);
    }
}

