/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty;

import io.jpower.kcp.netty.Consts;
import io.jpower.kcp.netty.DefaultUkcpServerChannelConfig;
import io.jpower.kcp.netty.Kcp;
import io.jpower.kcp.netty.KcpException;
import io.jpower.kcp.netty.KcpOutput;
import io.jpower.kcp.netty.Ukcp;
import io.jpower.kcp.netty.UkcpPacket;
import io.jpower.kcp.netty.UkcpServerChannelConfig;
import io.jpower.kcp.netty.UkcpServerChildChannel;
import io.jpower.kcp.netty.Utils;
import io.jpower.kcp.netty.internal.CodecOutputList;
import io.jpower.kcp.netty.internal.ReItrHashMap;
import io.jpower.kcp.netty.internal.ReusableIterator;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.AbstractNioMessageChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class UkcpServerChannel
extends AbstractNioMessageChannel
implements ServerChannel,
Runnable {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(UkcpServerChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ')';
    private final DefaultUkcpServerChannelConfig config;
    private final ReItrHashMap<SocketAddress, UkcpServerChildChannel> childChannelMap = new ReItrHashMap();
    private final ReusableIterator<Map.Entry<SocketAddress, UkcpServerChildChannel>> childChannelMapItr = this.childChannelMap.entrySet().iterator();
    private final ReItrHashMap<SocketAddress, CloseWaitKcp> closeWaitKcpMap = new ReItrHashMap();
    private final ReusableIterator<Map.Entry<SocketAddress, CloseWaitKcp>> closeWaitKcpMapItr = this.closeWaitKcpMap.entrySet().iterator();
    private final KcpOutput output = new UkcpServerOutput();
    private int tsUpdate;
    private boolean scheduleUpdate;
    private boolean scheduleCloseWait = false;
    private List<UkcpServerChildChannel> writeChannels = new ArrayList<UkcpServerChildChannel>();
    private List<Object> closeChildList = new ArrayList<Object>();
    private Runnable closeWaitRunner = new CloseWaitRun();

    private static DatagramChannel newSocket(SelectorProvider provider) {
        try {
            return provider.openDatagramChannel();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", (Throwable)e);
        }
    }

    public UkcpServerChannel() {
        this(UkcpServerChannel.newSocket(DEFAULT_SELECTOR_PROVIDER));
    }

    public UkcpServerChannel(SelectorProvider provider) {
        this(UkcpServerChannel.newSocket(provider));
    }

    public UkcpServerChannel(DatagramChannel socket) {
        super(null, (SelectableChannel)socket, 1);
        this.config = new DefaultUkcpServerChannelConfig(this, socket.socket());
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    public UkcpServerChannelConfig config() {
        return this.config;
    }

    protected UkcpServerUnsafe newUnsafe() {
        return new UkcpServerUnsafe();
    }

    public boolean isActive() {
        DatagramChannel ch = this.javaChannel();
        return ch.isOpen() && ch.socket().isBound();
    }

    protected DatagramChannel javaChannel() {
        return (DatagramChannel)super.javaChannel();
    }

    protected SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    protected SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        this.doBind0(localAddress);
    }

    private void doBind0(SocketAddress localAddress) throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            SocketUtils.bind((DatagramChannel)this.javaChannel(), (SocketAddress)localAddress);
        } else {
            this.javaChannel().socket().bind(localAddress);
        }
    }

    protected void doClose() throws Exception {
        Exception exception = null;
        try {
            this.javaChannel().close();
        }
        catch (Exception t) {
            exception = t;
        }
        ReusableIterator<Map.Entry<SocketAddress, UkcpServerChildChannel>> itr = this.childChannelMapItr.rewind();
        while (itr.hasNext()) {
            UkcpServerChildChannel childCh = (UkcpServerChildChannel)((Map.Entry)itr.next()).getValue();
            UkcpServerChildChannel.UkcpServerChildUnsafe childUnsafe = childCh.unsafe();
            try {
                childUnsafe.close(childUnsafe.voidPromise());
            }
            catch (Exception e) {
                log.error("Failed to close a child channel. childChannel={}", (Object)childCh);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected int doReadMessages(List<Object> buf) throws Exception {
        DatagramChannel ch = this.javaChannel();
        UkcpServerChannelConfig config = this.config();
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        ByteBuf data = allocHandle.allocate(config.getAllocator());
        allocHandle.attemptedBytesRead(data.writableBytes());
        boolean free = true;
        try {
            ByteBuffer nioData = data.internalNioBuffer(data.writerIndex(), data.writableBytes());
            int pos = nioData.position();
            InetSocketAddress remoteAddress = (InetSocketAddress)ch.receive(nioData);
            if (remoteAddress == null) {
                return 0;
            }
            allocHandle.lastBytesRead(nioData.position() - pos);
            buf.add((Object)UkcpPacket.newInstance(data.writerIndex(data.writerIndex() + allocHandle.lastBytesRead()), remoteAddress));
            free = false;
            return 1;
        }
        catch (Throwable cause) {
            PlatformDependent.throwException((Throwable)cause);
            return -1;
        }
        finally {
            if (free) {
                data.release();
            }
        }
    }

    protected boolean doWriteMessage(Object msg, ChannelOutboundBuffer in) throws Exception {
        UkcpPacket packet = (UkcpPacket)((Object)msg);
        InetSocketAddress remoteAddress = packet.remoteAddress();
        ByteBuf data = packet.content();
        int dataLen = data.readableBytes();
        if (dataLen == 0) {
            return true;
        }
        ByteBuffer nioData = data.internalNioBuffer(data.readerIndex(), dataLen);
        int writtenBytes = this.javaChannel().send(nioData, remoteAddress);
        return writtenBytes > 0;
    }

    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof UkcpPacket) {
            UkcpPacket p = (UkcpPacket)((Object)msg);
            ByteBuf content = p.content();
            if (UkcpServerChannel.isSingleDirectBuffer(content)) {
                return p;
            }
            content.retain();
            UkcpPacket np = UkcpPacket.newInstance(this.newDirectBuffer(content), p.remoteAddress());
            p.release();
            return np;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg) + EXPECTED_TYPES);
    }

    private static boolean isSingleDirectBuffer(ByteBuf buf) {
        return buf.isDirect() && buf.nioBufferCount() == 1;
    }

    protected boolean continueOnWriteError() {
        return true;
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    protected boolean closeOnReadError(Throwable cause) {
        if (cause instanceof SocketException) {
            return false;
        }
        return super.closeOnReadError(cause);
    }

    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doFinishConnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doDisconnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    private UkcpServerChildChannel getOrCreateUkcpChannel(InetSocketAddress remoteAddress) {
        UkcpServerChildChannel ch = this.childChannelMap.get(remoteAddress);
        if (ch == null) {
            ch = this.createChildChannel(remoteAddress);
            this.childChannelMap.put(remoteAddress, ch);
        }
        return ch;
    }

    private UkcpServerChildChannel createChildChannel(InetSocketAddress remoteAddress) {
        Ukcp ukcp = new Ukcp(0L, this.output);
        UkcpServerChildChannel ch = new UkcpServerChildChannel((Channel)this, ukcp, remoteAddress);
        ChannelPipeline pipeline = this.pipeline();
        pipeline.fireChannelRead((Object)ch);
        pipeline.fireChannelReadComplete();
        if (log.isDebugEnabled()) {
            log.debug("Create childChannel. remoteAddress={}", (Object)remoteAddress);
        }
        if (!this.scheduleUpdate) {
            int current = Utils.milliSeconds();
            int tsUp = ch.kcpCheck(current);
            ch.kcpTsUpdate(tsUp);
            this.scheduleUpdate(tsUp, current);
        }
        return ch;
    }

    private void scheduleUpdate(int tsUpdate, int current) {
        if (Consts.sheduleUpdateLog.isDebugEnabled()) {
            Consts.sheduleUpdateLog.debug("schedule delay: " + (tsUpdate - current));
        }
        this.tsUpdate = tsUpdate;
        this.scheduleUpdate = true;
        this.eventLoop().schedule((Runnable)this, (long)(tsUpdate - current), TimeUnit.MILLISECONDS);
    }

    void doCloseChildChannel(UkcpServerChildChannel childChannel) {
        UkcpServerChildChannel rmCh = this.childChannelMap.remove(childChannel.remoteAddress());
        if (rmCh == null) {
            log.error("Not found childChannel. remoteAddress={}", (Object)childChannel.remoteAddress());
        }
        if (rmCh != childChannel) {
            log.error("Mismatch instance of childChannel. remoteAddress={}", (Object)childChannel.remoteAddress());
        }
        Ukcp ukcp = childChannel.ukcp();
        if (this.isActive() && ukcp.getState() != -1 && ukcp.checkFlush()) {
            ukcp.setClosed(false);
            int current = Utils.milliSeconds();
            this.closeWaitKcpMap.put(ukcp.channel().remoteAddress(), new CloseWaitKcp(ukcp, current + 5000));
            this.tryScheduleCloseWait();
            if (!this.scheduleUpdate) {
                this.scheduleUpdate(ukcp.check(current), current);
            }
        } else {
            ukcp.setClosed(true);
        }
    }

    private void tryScheduleCloseWait() {
        if (this.closeWaitKcpMap.isEmpty() || this.scheduleCloseWait) {
            return;
        }
        this.eventLoop().schedule(this.closeWaitRunner, 2500L, TimeUnit.MILLISECONDS);
        this.scheduleCloseWait = true;
    }

    @Override
    public void run() {
        int current = Utils.milliSeconds();
        int nextTsUpdate = 0;
        boolean nextSchedule = false;
        ReusableIterator<Map.Entry<SocketAddress, Object>> itr = this.childChannelMapItr.rewind();
        while (itr.hasNext()) {
            UkcpServerChildChannel childCh = (UkcpServerChildChannel)((Map.Entry)itr.next()).getValue();
            if (!childCh.isActive()) continue;
            int tsUp = childCh.kcpTsUpdate();
            int nextChildTsUp = 0;
            boolean nextChildSchedule = false;
            Throwable exception = null;
            if (Utils.itimediff(current, tsUp) >= 0) {
                try {
                    nextChildTsUp = childCh.kcpUpdate(current);
                    nextChildSchedule = true;
                }
                catch (Throwable t) {
                    exception = t;
                }
                if (childCh.kcpState() == -1 && exception == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("getState=-1 after update(). channel={}", (Object)childCh);
                    }
                    exception = new KcpException("State=-1 after update()");
                }
                if (exception != null) {
                    this.closeChildList.add(new ExceptionCloseWrapper(childCh, exception));
                    nextChildTsUp = 0;
                    nextChildSchedule = false;
                } else if (childCh.isFlushPending() && childCh.kcpCanSend()) {
                    this.writeChannels.add(childCh);
                }
            } else {
                nextChildTsUp = tsUp;
                nextChildSchedule = true;
            }
            if (!nextChildSchedule || nextSchedule && Utils.itimediff(nextTsUpdate, nextChildTsUp) <= 0) continue;
            nextTsUpdate = nextChildTsUp;
            nextSchedule = true;
        }
        if (this.writeChannels.size() > 0) {
            for (UkcpServerChildChannel childCh : this.writeChannels) {
                childCh.unsafe().forceFlush();
            }
            this.writeChannels.clear();
        }
        if (this.closeWaitKcpMap.size() > 0) {
            itr = this.closeWaitKcpMapItr.rewind();
            while (itr.hasNext()) {
                CloseWaitKcp w = (CloseWaitKcp)((Map.Entry)itr.next()).getValue();
                Ukcp ukcp = w.ukcp;
                int tsUp = ukcp.getTsUpdate();
                int nextChildTsUp = 0;
                boolean nextChildSchedule = false;
                Throwable exception = null;
                if (Utils.itimediff(current, tsUp) >= 0) {
                    try {
                        nextChildTsUp = ukcp.update(current);
                        nextChildSchedule = true;
                    }
                    catch (Throwable t) {
                        exception = t;
                        itr.remove();
                        ukcp.setKcpClosed();
                        log.error("Terminate closeWaitKcp. ukcp={}, cause={}", new Object[]{ukcp, "update error", t});
                    }
                    if (ukcp.getState() == -1 && exception == null) {
                        itr.remove();
                        ukcp.setKcpClosed();
                        nextChildTsUp = 0;
                        nextChildSchedule = false;
                        if (log.isDebugEnabled()) {
                            log.debug("Terminate closeWaitKcp. ukcp={}, cause={}", (Object)ukcp, (Object)"update -1");
                        }
                    }
                } else {
                    nextChildTsUp = tsUp;
                    nextChildSchedule = true;
                }
                if (!nextChildSchedule || nextSchedule && Utils.itimediff(nextTsUpdate, nextChildTsUp) <= 0) continue;
                nextTsUpdate = nextChildTsUp;
                nextSchedule = true;
            }
        }
        this.tsUpdate = nextTsUpdate;
        this.scheduleUpdate = nextSchedule;
        if (nextSchedule) {
            this.scheduleUpdate(this.tsUpdate, current);
        }
        if (this.closeChildList.size() > 0) {
            this.handleCloseChildList();
        }
    }

    void updateChildKcp(UkcpServerChildChannel childCh) {
        int current = Utils.milliSeconds();
        Throwable exception = null;
        try {
            childCh.kcpUpdate(current);
        }
        catch (Throwable t) {
            exception = t;
        }
        if (childCh.kcpState() == -1 && exception == null) {
            if (log.isDebugEnabled()) {
                log.debug("getState=-1 after update(). channel={}", (Object)childCh);
            }
            exception = new KcpException("State=-1 after update()");
        }
        if (exception != null) {
            Utils.fireExceptionAndClose(childCh, exception, true);
        }
    }

    private void handleCloseChildList() {
        for (Object obj : this.closeChildList) {
            if (obj instanceof UkcpServerChildChannel) {
                UkcpServerChildChannel childCh = (UkcpServerChildChannel)obj;
                UkcpServerChildChannel.UkcpServerChildUnsafe childUnsafe = childCh.unsafe();
                childUnsafe.close(childUnsafe.voidPromise());
                continue;
            }
            ExceptionCloseWrapper wrap = (ExceptionCloseWrapper)obj;
            Utils.fireExceptionAndClose(wrap.channel, wrap.exception, true);
        }
        this.closeChildList.clear();
    }

    static /* synthetic */ ReItrHashMap access$6(UkcpServerChannel ukcpServerChannel) {
        return ukcpServerChannel.closeWaitKcpMap;
    }

    static /* synthetic */ UkcpServerChildChannel access$8(UkcpServerChannel ukcpServerChannel, InetSocketAddress inetSocketAddress) {
        return ukcpServerChannel.getOrCreateUkcpChannel(inetSocketAddress);
    }

    private static class CloseWaitKcp {
        final Ukcp ukcp;
        final int closeTime;

        CloseWaitKcp(Ukcp ukcp, int closeTime) {
            this.ukcp = ukcp;
            this.closeTime = closeTime;
        }
    }

    private class CloseWaitRun
    implements Runnable {
        private CloseWaitRun() {
        }

        @Override
        public void run() {
            UkcpServerChannel.this.scheduleCloseWait = false;
            int current = Utils.milliSeconds();
            ReusableIterator itr = UkcpServerChannel.this.closeWaitKcpMapItr.rewind();
            while (itr.hasNext()) {
                CloseWaitKcp w = (CloseWaitKcp)((Map.Entry)itr.next()).getValue();
                Ukcp ukcp = w.ukcp;
                if (Utils.itimediff(current, w.closeTime) >= 0) {
                    ukcp.setKcpClosed();
                    itr.remove();
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Terminate closeWaitKcp. ukcp={}, cause={}", (Object)ukcp, (Object)"timeout");
                    continue;
                }
                if (ukcp.checkFlush()) continue;
                ukcp.setKcpClosed();
                itr.remove();
                if (!log.isDebugEnabled()) continue;
                log.debug("Terminate closeWaitKcp. ukcp={}, cause={}", (Object)ukcp, (Object)"no flush");
            }
            UkcpServerChannel.this.tryScheduleCloseWait();
        }
    }

    private static class ExceptionCloseWrapper {
        final UkcpServerChildChannel channel;
        final Throwable exception;

        ExceptionCloseWrapper(UkcpServerChildChannel channel, Throwable exception) {
            this.channel = channel;
            this.exception = exception;
        }
    }

    private class UkcpServerOutput
    implements KcpOutput {
        private UkcpServerOutput() {
        }

        @Override
        public void out(ByteBuf data, Kcp kcp) {
            UkcpServerChildChannel channel = (UkcpServerChildChannel)kcp.getUser();
            AbstractNioChannel.NioUnsafe unsafe = UkcpServerChannel.this.unsafe();
            unsafe.write((Object)UkcpPacket.newInstance(data, channel.remoteAddress()), unsafe.voidPromise());
            unsafe.flush();
        }
    }

    private final class UkcpServerUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private final List<Object> readBuf;

        private UkcpServerUnsafe() {
            super((AbstractNioChannel)UkcpServerChannel.this);
            this.readBuf = new ArrayList<Object>();
        }

        /*
         * Unable to fully structure code
         */
        public void read() {
            if (!UkcpServerUnsafe.$assertionsDisabled && !UkcpServerChannel.this.eventLoop().inEventLoop()) {
                throw new AssertionError();
            }
            config = UkcpServerChannel.this.config();
            pipeline = UkcpServerChannel.this.pipeline();
            allocHandle = UkcpServerChannel.this.unsafe().recvBufAllocHandle();
            allocHandle.reset((ChannelConfig)config);
            closed = false;
            exception = null;
            try {
                try {
                    while ((localRead = UkcpServerChannel.this.doReadMessages(this.readBuf)) != 0) {
                        if (localRead < 0) {
                            closed = true;
                        } else {
                            allocHandle.incMessagesRead(localRead);
                            if (allocHandle.continueReading()) continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    exception = t;
                }
                readBufSize = this.readBuf.size();
                i = 0;
                while (i < readBufSize) {
                    block39: {
                        block36: {
                            block35: {
                                block40: {
                                    block38: {
                                        block34: {
                                            subException = null;
                                            packet = (UkcpPacket)this.readBuf.get(i);
                                            remoteAddress = packet.remoteAddress();
                                            byteBuf = packet.content();
                                            closeWaitKcp = (CloseWaitKcp)UkcpServerChannel.access$6(UkcpServerChannel.this).get(remoteAddress);
                                            if (closeWaitKcp == null) break block38;
                                            recvBufList = null;
                                            ukcp = closeWaitKcp.ukcp;
                                            try {
                                                try {
                                                    ukcp.input(byteBuf);
                                                    ukcp.setTsUpdate(Utils.milliSeconds());
                                                    while (ukcp.canRecv()) {
                                                        if (recvBufList == null) {
                                                            recvBufList = CodecOutputList.newInstance();
                                                        }
                                                        ukcp.receive(recvBufList);
                                                    }
                                                }
                                                catch (Throwable t) {
                                                    subException = t;
                                                    packet.release();
                                                    break block34;
                                                }
                                            }
                                            catch (Throwable var16_19) {
                                                packet.release();
                                                throw var16_19;
                                            }
                                            packet.release();
                                        }
                                        if (recvBufList != null) {
                                            this.clearAndRelease(recvBufList);
                                            recvBufList.recycle();
                                        }
                                        if (subException != null) {
                                            UkcpServerChannel.access$6(UkcpServerChannel.this).remove(remoteAddress);
                                            ukcp.setKcpClosed();
                                            UkcpServerChannel.access$7().error("Terminate closeWaitKcp. ukcp={}, cause={}", new Object[]{ukcp, "read error", subException});
                                        }
                                        break block39;
                                    }
                                    childCh = UkcpServerChannel.access$8(UkcpServerChannel.this, remoteAddress);
                                    if (childCh.isActive()) break block40;
                                    packet.release();
                                    break block39;
                                }
                                childConfig = childCh.config();
                                childPipeline = childCh.pipeline();
                                mergeSegmentBuf = childConfig.isMergeSegmentBuf();
                                recvBufList = null;
                                recv = false;
                                try {
                                    try {
                                        childCh.kcpInput(byteBuf);
                                        childCh.kcpTsUpdate(Utils.milliSeconds());
                                        if (!mergeSegmentBuf) ** GOTO lbl96
                                        childAllocator = childConfig.getAllocator();
                                        while ((peekSize = childCh.kcpPeekSize()) >= 0) {
                                            recv = true;
                                            recvBuf = childAllocator.ioBuffer(peekSize);
                                            childCh.kcpReceive(recvBuf);
                                            childPipeline.fireChannelRead((Object)recvBuf);
                                        }
                                        break block35;
lbl-1000:
                                        // 1 sources

                                        {
                                            recv = true;
                                            if (recvBufList == null) {
                                                recvBufList = CodecOutputList.newInstance();
                                            }
                                            childCh.kcpReceive(recvBufList);
lbl96:
                                            // 2 sources

                                            ** while (childCh.kcpCanRecv())
                                        }
lbl97:
                                        // 1 sources

                                    }
                                    catch (Throwable t) {
                                        subException = t;
                                        packet.release();
                                        break block36;
                                    }
                                }
                                catch (Throwable var22_26) {
                                    packet.release();
                                    throw var22_26;
                                }
                            }
                            packet.release();
                        }
                        if (recv) {
                            if (mergeSegmentBuf) {
                                childPipeline.fireChannelReadComplete();
                            } else {
                                Utils.fireChannelRead(childCh, recvBufList);
                                recvBufList.recycle();
                            }
                        }
                        if (subException != null) {
                            Utils.fireExceptionAndClose(childCh, subException, true);
                        }
                    }
                    ++i;
                }
                this.readBuf.clear();
                allocHandle.readComplete();
                if (exception != null) {
                    closed = UkcpServerChannel.this.closeOnReadError(exception);
                    pipeline.fireExceptionCaught(exception);
                }
                if (closed && UkcpServerChannel.this.isOpen()) {
                    this.close(this.voidPromise());
                }
            }
            finally {
                if (!config.isAutoRead()) {
                    this.removeReadOp();
                }
            }
        }

        private void clearAndRelease(CodecOutputList<ByteBuf> bufList) {
            int size = bufList.size();
            int i = 0;
            while (i < size) {
                ByteBuf msg = bufList.getUnsafe(i);
                msg.release();
                ++i;
            }
        }
    }
}

