/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway.threadPool.order.waiteStrategy;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kcp.highway.threadPool.order.waiteStrategy.WaitCondition;
import kcp.highway.threadPool.order.waiteStrategy.WaitConditionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SleepingWaitConditionStrategy
implements WaitConditionStrategy {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DEFAULT_RETRIES = 200;
    private final int retries;

    public SleepingWaitConditionStrategy() {
        this(200);
    }

    public SleepingWaitConditionStrategy(int retries) {
        this.retries = retries;
    }

    @Override
    public <T> T waitFor(WaitCondition<T> waitCondition, long timeOut, TimeUnit unit) {
        T task;
        int counter = this.retries;
        long endTime = System.nanoTime() + unit.toNanos(timeOut);
        while ((task = waitCondition.getAttach()) == null && System.nanoTime() < endTime) {
            counter = this.applyWaitMethod(counter);
        }
        return task;
    }

    @Override
    public void signalAllWhenBlocking() {
    }

    private int applyWaitMethod(int counter) {
        if (counter > 100) {
            --counter;
        } else if (counter > 0) {
            --counter;
            Thread.yield();
        } else {
            LockSupport.parkNanos(1L);
        }
        return counter;
    }
}

