/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.HashedWheelTimer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kcp.highway.ChannelConfig;
import kcp.highway.Crc32Decode;
import kcp.highway.Crc32Encode;
import kcp.highway.IChannelManager;
import kcp.highway.KcpListener;
import kcp.highway.ServerAddressChannelManager;
import kcp.highway.ServerChannelHandler;
import kcp.highway.ServerConvChannelManager;
import kcp.highway.Ukcp;
import kcp.highway.erasure.fec.Fec;
import kcp.highway.threadPool.IMessageExecutorPool;

public class KcpServer {
    private IMessageExecutorPool iMessageExecutorPool;
    private Bootstrap bootstrap;
    private EventLoopGroup group;
    private List<Channel> localAddresss = new Vector<Channel>();
    private IChannelManager channelManager;
    private HashedWheelTimer hashedWheelTimer;

    public void init(final KcpListener kcpListener, final ChannelConfig channelConfig, InetSocketAddress ... addresses) {
        if (channelConfig.isUseConvChannel()) {
            int convIndex = 0;
            if (channelConfig.getFecAdapt() != null) {
                convIndex += Fec.fecHeaderSizePlus2;
            }
            this.channelManager = new ServerConvChannelManager(convIndex);
        } else {
            this.channelManager = new ServerAddressChannelManager();
        }
        this.hashedWheelTimer = new HashedWheelTimer((ThreadFactory)new TimerThreadFactory(), 1L, TimeUnit.MILLISECONDS);
        boolean epoll = Epoll.isAvailable();
        boolean kqueue = KQueue.isAvailable();
        this.iMessageExecutorPool = channelConfig.getiMessageExecutorPool();
        this.bootstrap = new Bootstrap();
        int cpuNum = Runtime.getRuntime().availableProcessors();
        int bindTimes = 1;
        if (epoll || kqueue) {
            this.bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
            bindTimes = cpuNum;
        }
        Class<EpollDatagramChannel> channelClass = null;
        if (epoll) {
            this.group = new EpollEventLoopGroup(cpuNum);
            channelClass = EpollDatagramChannel.class;
        } else if (kqueue) {
            this.group = new KQueueEventLoopGroup(cpuNum);
            channelClass = KQueueDatagramChannel.class;
        } else {
            this.group = new NioEventLoopGroup(addresses.length);
            channelClass = NioDatagramChannel.class;
        }
        this.bootstrap.channel(channelClass);
        this.bootstrap.group(this.group);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ServerChannelHandler serverChannelHandler = new ServerChannelHandler(KcpServer.this.channelManager, channelConfig, KcpServer.this.iMessageExecutorPool, kcpListener, KcpServer.this.hashedWheelTimer);
                ChannelPipeline cp = ch.pipeline();
                if (channelConfig.isCrc32Check()) {
                    Crc32Encode crc32Encode = new Crc32Encode();
                    Crc32Decode crc32Decode = new Crc32Decode();
                    cp.addLast(new ChannelHandler[]{crc32Encode});
                    cp.addLast(new ChannelHandler[]{crc32Decode});
                }
                cp.addLast(new ChannelHandler[]{serverChannelHandler});
            }
        });
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        for (InetSocketAddress addres : addresses) {
            for (int i = 0; i < bindTimes; ++i) {
                ChannelFuture channelFuture = this.bootstrap.bind((SocketAddress)addres);
                Channel channel = channelFuture.channel();
                this.localAddresss.add(channel);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    public void stop() {
        this.localAddresss.forEach(ChannelOutboundInvoker::close);
        this.channelManager.getAll().forEach(Ukcp::close);
        if (this.iMessageExecutorPool != null) {
            this.iMessageExecutorPool.stop();
        }
        if (this.hashedWheelTimer != null) {
            this.hashedWheelTimer.stop();
        }
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
    }

    public IChannelManager getChannelManager() {
        return this.channelManager;
    }

    private static class TimerThreadFactory
    implements ThreadFactory {
        private AtomicInteger timeThreadName = new AtomicInteger(0);

        private TimerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "KcpServerTimerThread " + this.timeThreadName.addAndGet(1));
            return thread;
        }
    }
}

