/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway;

import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.DatagramPacket;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kcp.highway.IChannelManager;
import kcp.highway.Ukcp;

public class ClientConvChannelManager
implements IChannelManager {
    private final int convIndex;
    private final Map<Long, Ukcp> ukcpMap = new ConcurrentHashMap<Long, Ukcp>();

    public ClientConvChannelManager(int convIndex) {
        this.convIndex = convIndex;
    }

    @Override
    public Ukcp get(DatagramPacket msg) {
        long conv = this.getConv(msg);
        return this.ukcpMap.get(conv);
    }

    private long getConv(DatagramPacket msg) {
        ByteBuf byteBuf = (ByteBuf)msg.content();
        return byteBuf.getLong(byteBuf.readerIndex() + this.convIndex);
    }

    @Override
    public void New(SocketAddress socketAddress, Ukcp ukcp, DatagramPacket msg) {
        long conv = ukcp.getConv();
        if (msg != null && conv == 0L) {
            conv = this.getConv(msg);
            ukcp.setConv(conv);
        }
        this.ukcpMap.put(conv, ukcp);
    }

    @Override
    public void del(Ukcp ukcp) {
        this.ukcpMap.remove(ukcp.getConv());
        ukcp.user().getChannel().close();
    }

    @Override
    public Collection<Ukcp> getAll() {
        return this.ukcpMap.values();
    }
}

