/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http.util;

import io.javalin.http.Context;
import io.javalin.http.util.RateLimitUtilKt;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bR&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/javalin/http/util/RateLimiter;", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(Ljava/util/concurrent/TimeUnit;)V", "handlerToIpToRequestCount", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "incrementCounter", "", "ctx", "Lio/javalin/http/Context;", "requestLimit", "javalin"})
public final class RateLimiter {
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Integer>> handlerToIpToRequestCount;

    public final void incrementCounter(@NotNull Context ctx, int requestLimit) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        String limiterName = ctx.method() + ctx.matchedPath();
        this.handlerToIpToRequestCount.putIfAbsent(limiterName, new ConcurrentHashMap());
        ConcurrentHashMap<String, Integer> concurrentHashMap = this.handlerToIpToRequestCount.get(limiterName);
        if (concurrentHashMap == null) {
            Intrinsics.throwNpe();
        }
        concurrentHashMap.compute(RateLimitUtilKt.access$ip(ctx), new BiFunction<String, Integer, Integer>(requestLimit){
            final /* synthetic */ int $requestLimit;

            @Nullable
            public final Integer apply(@NotNull String $noName_0, @Nullable Integer count) {
                Integer n;
                Intrinsics.checkParameterIsNotNull($noName_0, "<anonymous parameter 0>");
                if (count == null) {
                    n = 1;
                } else if (Intrinsics.compare(count, this.$requestLimit) < 0) {
                    n = count + 1;
                } else {
                    throw (Throwable)new RuntimeException("Too many requests!");
                }
                return n;
            }
            {
                this.$requestLimit = n;
            }
        });
    }

    public RateLimiter(@NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)timeUnit, "timeUnit");
        this.handlerToIpToRequestCount = new ConcurrentHashMap();
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

            @Override
            public final void run() {
                Map $this$forEach$iv = handlerToIpToRequestCount;
                boolean $i$f$forEach = false;
                Map map = $this$forEach$iv;
                boolean bl = false;
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry $dstr$_u24__u24$ipRequestCount = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Map.Entry entry = $dstr$_u24__u24$ipRequestCount;
                    boolean bl3 = false;
                    ConcurrentHashMap ipRequestCount = (ConcurrentHashMap)entry.getValue();
                    ipRequestCount.clear();
                }
            }
        }, 0L, 1L, timeUnit);
    }
}

