/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.Javalin;
import io.javalin.core.util.LogUtil;
import io.javalin.http.Context;
import io.javalin.http.HandlerEntry;
import io.javalin.http.HandlerType;
import io.javalin.http.PathMatcher;
import io.javalin.websocket.WsContext;
import io.javalin.websocket.WsHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001e\u0010\u0013\u001a\u00020\b*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\b\b\u0002\u0010\u0016\u001a\u00020\fH\u0002\u00a8\u0006\u0017"}, d2={"Lio/javalin/core/util/LogUtil;", "", "()V", "executionTimeMs", "", "ctx", "Lio/javalin/http/Context;", "requestDevLogger", "", "time", "(Lio/javalin/http/Context;F)Lkotlin/Unit;", "resBody", "", "setup", "matcher", "Lio/javalin/http/PathMatcher;", "wsDevLogger", "ws", "Lio/javalin/websocket/WsHandler;", "logEvent", "Lio/javalin/websocket/WsContext;", "event", "additionalInfo", "javalin"})
public final class LogUtil {
    public static final LogUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Unit requestDevLogger(@NotNull Context ctx, float time) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        try {
            Unit unit2;
            CharSequence charSequence;
            Collection collection;
            void $this$mapTo$iv$iv;
            HandlerType type2 = HandlerType.Companion.fromServletRequest(ctx.req);
            String requestUri = ctx.req.getRequestURI();
            boolean bl = false;
            boolean bl2 = false;
            Context $this$with = ctx;
            boolean bl3 = false;
            Object t = ctx.attribute("javalin-request-log-matcher");
            if (t == null) {
                Intrinsics.throwNpe();
            }
            PathMatcher matcher = (PathMatcher)t;
            String string = requestUri;
            Intrinsics.checkExpressionValueIsNotNull(string, "requestUri");
            Iterable $this$map$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)matcher.findEntries(HandlerType.BEFORE, string), (Iterable)matcher.findEntries(type2, requestUri)), (Iterable)matcher.findEntries(HandlerType.AFTER, requestUri));
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HandlerEntry handlerEntry = (HandlerEntry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                charSequence = it.getType().name() + "=" + it.getPath();
                collection.add(charSequence);
            }
            List allMatching = (List)destination$iv$iv;
            Collection<String> collection2 = $this$with.res.getHeaderNames();
            Intrinsics.checkExpressionValueIsNotNull(collection2, "res.headerNames");
            Map resHeaders2 = MapsKt.toMap(SequencesKt.map(CollectionsKt.asSequence((Iterable)collection2), (Function1)new Function1<String, Pair<? extends String, ? extends String>>($this$with){
                final /* synthetic */ Context $this_with;

                @NotNull
                public final Pair<String, String> invoke(String it) {
                    return TuplesKt.to(it, this.$this_with.res.getHeader(it));
                }
                {
                    this.$this_with = context;
                    super(1);
                }
            }));
            Logger logger = Javalin.log;
            if (logger != null) {
                String string2;
                List v;
                boolean bl5;
                Map.Entry entry;
                Map.Entry $dstr$_u24__u24$v;
                Map map;
                Object k;
                Object k2;
                Map.Entry it$iv$iv;
                boolean bl6;
                Map map2;
                Map<String, List<String>> $this$mapValuesTo$iv$iv;
                Map<String, List<String>> $this$mapValues$iv;
                Map<String, List<String>> $i$f$map2 = $this$with.queryParamMap();
                charSequence = new StringBuilder().append("JAVALIN REQUEST DEBUG LOG:\n                        |Request: ").append($this$with.method()).append(" [").append($this$with.path()).append("]\n                        |    Matching endpoint-handlers: ").append(allMatching).append("\n                        |    Headers: ").append($this$with.headerMap()).append("\n                        |    Cookies: ").append($this$with.cookieMap()).append("\n                        |    Body: ").append($this$with.isMultipart() ? "Multipart data ..." : $this$with.body()).append("\n                        |    QueryString: ").append($this$with.queryString()).append("\n                        |    QueryParams: ");
                collection = logger;
                boolean $i$f$mapValues = false;
                destination$iv$iv = $this$mapValues$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    map2 = destination$iv$iv2;
                    bl6 = false;
                    k2 = it$iv$iv.getKey();
                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                    k = k2;
                    map = map2;
                    boolean bl7 = false;
                    entry = $dstr$_u24__u24$v;
                    bl5 = false;
                    v = (List)entry.getValue();
                    string2 = v.toString();
                    map.put(k, string2);
                }
                map = destination$iv$iv2;
                $this$mapValues$iv = $this$with.formParamMap();
                charSequence = ((StringBuilder)charSequence).append(map).append("\n                        |    FormParams: ");
                $i$f$mapValues = false;
                $this$mapValuesTo$iv$iv = $this$mapValues$iv;
                destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
                $i$f$mapValuesTo = false;
                $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    it$iv$iv = (Map.Entry)element$iv$iv$iv;
                    map2 = destination$iv$iv2;
                    bl6 = false;
                    k2 = it$iv$iv.getKey();
                    $dstr$_u24__u24$v = (Map.Entry)element$iv$iv$iv;
                    k = k2;
                    map = map2;
                    boolean bl8 = false;
                    entry = $dstr$_u24__u24$v;
                    bl5 = false;
                    v = (List)entry.getValue();
                    string2 = v.toString();
                    map.put(k, string2);
                }
                map = destination$iv$iv2;
                collection.info(StringsKt.trimMargin$default(((StringBuilder)charSequence).append(map).append("\n                        |Response: [").append($this$with.status()).append("], execution took ").append(new Formatter(Locale.US).format("%.2f", Float.valueOf(time))).append(" ms\n                        |    Headers: ").append(resHeaders2).append("\n                        |    ").append(INSTANCE.resBody(ctx)).append("\n                        |----------------------------------------------------------------------------------").toString(), null, 1, null));
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        catch (Exception e) {
            Unit unit3;
            Logger logger = Javalin.log;
            if (logger != null) {
                logger.info("An exception occurred while logging debug-info", (Throwable)e);
                unit3 = Unit.INSTANCE;
            } else {
                unit3 = null;
            }
            unit = unit3;
        }
        return unit;
    }

    private final String resBody(Context ctx) {
        boolean staticFile = Intrinsics.areEqual(ctx.req.getAttribute("handled-as-static-file"), true);
        if (staticFile) {
            return "Body is a static file (not logged)";
        }
        InputStream inputStream = ctx.resultStream();
        if (inputStream == null) {
            return "No body was set";
        }
        InputStream stream = inputStream;
        if (!stream.markSupported()) {
            return "Body is binary (not logged)";
        }
        boolean gzipped = Intrinsics.areEqual(ctx.res.getHeader("Content-Encoding"), "gzip");
        boolean brotlied = Intrinsics.areEqual(ctx.res.getHeader("Content-Encoding"), "br");
        String string = ctx.resultString();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String resBody = string;
        return gzipped ? "Body is gzipped (" + resBody.length() + " bytes, not logged)" : (brotlied ? "Body is brotlied (" + resBody.length() + " bytes, not logged)" : "Body is " + resBody.length() + " bytes (starts on next line):\n    " + resBody);
    }

    public final void setup(@NotNull Context ctx, @NotNull PathMatcher matcher) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        Intrinsics.checkParameterIsNotNull(matcher, "matcher");
        ctx.attribute("javalin-request-log-matcher", matcher);
        ctx.attribute("javalin-request-log-start-time", System.nanoTime());
    }

    public final float executionTimeMs(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull(ctx, "ctx");
        long l = System.nanoTime();
        Object t = ctx.attribute("javalin-request-log-start-time");
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return (float)(l - ((Number)t).longValue()) / 1000000.0f;
    }

    @JvmStatic
    public static final void wsDevLogger(@NotNull WsHandler ws) {
        Intrinsics.checkParameterIsNotNull(ws, "ws");
        ws.onConnect(wsDevLogger.1.INSTANCE);
        ws.onMessage(wsDevLogger.2.INSTANCE);
        ws.onBinaryMessage(wsDevLogger.3.INSTANCE);
        ws.onClose(wsDevLogger.4.INSTANCE);
        ws.onError(wsDevLogger.5.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void logEvent(@NotNull WsContext $this$logEvent, String event, String additionalInfo) {
        block3: {
            String string;
            Logger logger = Javalin.log;
            if (logger == null) break block3;
            StringBuilder stringBuilder = new StringBuilder().append("JAVALIN WEBSOCKET DEBUG LOG\n                |WebSocket Event: ").append(event).append("\n                |Session Id: ").append($this$logEvent.getSessionId()).append("\n                |Host: ").append($this$logEvent.host()).append("\n                |Matched Path: ").append($this$logEvent.matchedPath()).append("\n                |PathParams: ").append($this$logEvent.pathParamMap()).append("\n                |QueryParams: ");
            if ($this$logEvent.queryString() != null) {
                Map map;
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                Map<String, List<String>> map2 = $this$logEvent.queryParamMap();
                StringBuilder stringBuilder2 = stringBuilder;
                Logger logger2 = logger;
                boolean $i$f$mapValues = false;
                void var6_8 = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void $dstr$_u24__u24$v;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl = false;
                    Object k = it$iv$iv.getKey();
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k2 = k;
                    map = map3;
                    boolean bl2 = false;
                    void var19_21 = $dstr$_u24__u24$v;
                    boolean bl3 = false;
                    List v = (List)var19_21.getValue();
                    String string2 = v.toString();
                    map.put(k2, string2);
                }
                map = destination$iv$iv;
                logger = logger2;
                stringBuilder = stringBuilder2;
                string = map.toString();
            } else {
                string = "No query string was provided";
            }
            logger.info(StringsKt.trimMargin$default(stringBuilder.append(string).append("\n                |").append(additionalInfo).append("\n                |----------------------------------------------------------------------------------").toString(), null, 1, null));
        }
    }

    static /* synthetic */ void logEvent$default(LogUtil logUtil, WsContext wsContext, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        logUtil.logEvent(wsContext, string, string2);
    }

    private LogUtil() {
    }

    static {
        LogUtil logUtil;
        INSTANCE = logUtil = new LogUtil();
    }

    public static final /* synthetic */ void access$logEvent(LogUtil $this, WsContext $this$access_u24logEvent, String event, String additionalInfo) {
        $this.logEvent($this$access_u24logEvent, event, additionalInfo);
    }
}

