/*
 * Decompiled with CFR 0.152.
 */
package express.http;

import express.http.MediaType;
import express.http.Status;
import io.javalin.http.BadGatewayResponse;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.ConflictResponse;
import io.javalin.http.Context;
import io.javalin.http.ForbiddenResponse;
import io.javalin.http.GatewayTimeoutResponse;
import io.javalin.http.GoneResponse;
import io.javalin.http.HttpResponseException;
import io.javalin.http.InternalServerErrorResponse;
import io.javalin.http.MethodNotAllowedResponse;
import io.javalin.http.NotFoundResponse;
import io.javalin.http.RedirectResponse;
import io.javalin.http.ServiceUnavailableResponse;
import io.javalin.http.UnauthorizedResponse;
import io.javalin.plugin.json.JavalinJson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;

public class Response {
    private final Context ctx;

    public Response(Context ctx) {
        this.ctx = ctx;
    }

    public Context ctx() {
        return this.ctx;
    }

    public Response send(String text) {
        this.type("text/html");
        this.ctx.result(text);
        return this;
    }

    public Response send(Object obj) {
        this.ctx.result(JavalinJson.toJson(obj));
        return this;
    }

    public Response send(InputStream stream) {
        this.ctx.result(stream);
        return this;
    }

    public Response send(byte[] bytes) {
        this.ctx.result(bytes);
        return this;
    }

    public Response json(Object json2) {
        if (json2 == null) {
            this.send("null");
        } else {
            this.ctx.json(json2);
        }
        return this;
    }

    public Response append(String name, String value) {
        this.ctx.header(name, value);
        return this;
    }

    public Response attachment() {
        this.ctx.header("Content-Disposition", "attachment");
        return this;
    }

    public Response attachment(String path) {
        String filename = path.substring(path.lastIndexOf(path.contains("/") ? 47 : 92) + 1);
        String extension = path.substring(path.lastIndexOf(".") + 1);
        this.ctx.header("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        this.type(extension);
        return this;
    }

    public Response download(Path path) {
        this.attachment(path.toString());
        this.sendFile(path);
        return this;
    }

    public Response sendFile(Path path) {
        MediaType fromExtension = MediaType.getByExtension(path.toString().substring(path.toString().lastIndexOf(".") + 1));
        this.ctx.contentType(fromExtension != null ? fromExtension.getMIME() : "text/plain");
        try {
            this.ctx.result(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public Response cookie(String name, String value) {
        this.ctx.cookie(name, value);
        return this;
    }

    public Response cookie(Cookie cookie) {
        this.ctx.cookie(cookie);
        return this;
    }

    public Response clearCookie(String name, String path) {
        this.ctx.removeCookie(name, path);
        return this;
    }

    public String get(String key) {
        return this.ctx.header(key);
    }

    public String links() {
        return this.ctx.header("Link");
    }

    public Response links(String next, String last) {
        this.ctx.header("Link", String.format("<%s>; rel=\"next\",\n<%s>; rel=\"last\"", next, last));
        return this;
    }

    public String location() {
        return this.ctx.header("Location");
    }

    public Response location(String location) {
        this.ctx.header("Location", location);
        return this;
    }

    public Response redirect(String location) {
        this.ctx.redirect(location);
        return this;
    }

    public Response redirect(int httpStatusCode, String location) {
        this.ctx.redirect(location, httpStatusCode);
        return this;
    }

    public Response render(String filePath, Map<String, Object> model) {
        this.ctx.render(filePath, model);
        return this;
    }

    public Response sendStatus(int statusCode) {
        this.status(statusCode).send(Status.valueOf(statusCode).getDescription());
        return this;
    }

    public Response set(String name, String value) {
        this.ctx.header(name, value);
        return this;
    }

    public Response status(int statusCode) {
        this.ctx.status(statusCode);
        return this;
    }

    public int status() {
        return this.ctx.status();
    }

    public Response type(String contentType) {
        MediaType fromExtension;
        if (contentType.startsWith(".")) {
            contentType = contentType.replaceFirst("\\.", "");
        }
        this.ctx.contentType((fromExtension = MediaType.getByExtension(contentType)) != null ? fromExtension.getMIME() : contentType);
        return this;
    }

    public void end() {
        this.end(null);
    }

    public void end(String message) {
        switch (this.status()) {
            case 302: {
                throw new RedirectResponse();
            }
            case 400: {
                throw new BadRequestResponse(message == null ? "BadRequest" : message);
            }
            case 401: {
                throw new UnauthorizedResponse(message == null ? "Unauthorized" : message);
            }
            case 403: {
                throw new ForbiddenResponse(message == null ? "Forbidden" : message);
            }
            case 404: {
                throw new NotFoundResponse(message == null ? "NotFound" : message);
            }
            case 405: {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("method", this.ctx.method());
                throw new MethodNotAllowedResponse(message == null ? "MethodNotAllowed" : message, details);
            }
            case 409: {
                throw new ConflictResponse(message == null ? "Conflict" : message);
            }
            case 410: {
                throw new GoneResponse(message == null ? "Gone" : message);
            }
            case 500: {
                throw new InternalServerErrorResponse(message == null ? "InternalServerError" : message);
            }
            case 502: {
                throw new BadGatewayResponse(message == null ? "BadGateway" : message);
            }
            case 503: {
                throw new ServiceUnavailableResponse(message == null ? "ServiceUnavailable" : message);
            }
            case 504: {
                throw new GatewayTimeoutResponse(message == null ? "GatewayTimeout" : message);
            }
        }
        HashMap<String, String> det = new HashMap<String, String>();
        throw new HttpResponseException(this.status(), message == null ? "NoResponse" : message, det);
    }
}

