/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway.threadPool.disruptor;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import kcp.highway.threadPool.IMessageExecutor;
import kcp.highway.threadPool.IMessageExecutorPool;
import kcp.highway.threadPool.disruptor.DisruptorSingleExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptorExecutorPool
implements IMessageExecutorPool {
    private static final Logger log = LoggerFactory.getLogger(DisruptorExecutorPool.class);
    protected List<IMessageExecutor> executor = new Vector<IMessageExecutor>();
    protected AtomicInteger index = new AtomicInteger();

    public DisruptorExecutorPool(int workSize) {
        for (int i = 0; i < workSize; ++i) {
            this.createDisruptorProcessor("DisruptorExecutorPool-" + i);
        }
    }

    private IMessageExecutor createDisruptorProcessor(String threadName) {
        DisruptorSingleExecutor singleProcess = new DisruptorSingleExecutor(threadName);
        this.executor.add(singleProcess);
        singleProcess.start();
        return singleProcess;
    }

    @Override
    public void stop() {
        for (IMessageExecutor process : this.executor) {
            process.stop();
        }
    }

    @Override
    public IMessageExecutor getIMessageExecutor() {
        int index = this.index.incrementAndGet();
        return this.executor.get(index % this.executor.size());
    }
}

