/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor.dsl;

import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.EventTranslatorThreeArg;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.ConsumerInfo;
import com.lmax.disruptor.dsl.ConsumerRepository;
import com.lmax.disruptor.dsl.EventHandlerGroup;
import com.lmax.disruptor.dsl.EventProcessorFactory;
import com.lmax.disruptor.dsl.ExceptionHandlerSetting;
import com.lmax.disruptor.dsl.ExceptionHandlerWrapper;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Disruptor<T> {
    private final RingBuffer<T> ringBuffer;
    private final ThreadFactory threadFactory;
    private final ConsumerRepository<T> consumerRepository = new ConsumerRepository();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ExceptionHandler<? super T> exceptionHandler = new ExceptionHandlerWrapper<T>();

    public Disruptor(EventFactory<T> eventFactory, int ringBufferSize, ThreadFactory threadFactory) {
        this(RingBuffer.createMultiProducer(eventFactory, ringBufferSize), threadFactory);
    }

    public Disruptor(EventFactory<T> eventFactory, int ringBufferSize, ThreadFactory threadFactory, ProducerType producerType, WaitStrategy waitStrategy) {
        this(RingBuffer.create(producerType, eventFactory, ringBufferSize, waitStrategy), threadFactory);
    }

    private Disruptor(RingBuffer<T> ringBuffer, ThreadFactory threadFactory) {
        this.ringBuffer = ringBuffer;
        this.threadFactory = threadFactory;
    }

    @SafeVarargs
    public final EventHandlerGroup<T> handleEventsWith(EventHandler<? super T> ... handlers) {
        return this.createEventProcessors(new Sequence[0], handlers);
    }

    @SafeVarargs
    public final EventHandlerGroup<T> handleEventsWith(EventProcessorFactory<T> ... eventProcessorFactories) {
        Sequence[] barrierSequences = new Sequence[]{};
        return this.createEventProcessors(barrierSequences, eventProcessorFactories);
    }

    public EventHandlerGroup<T> handleEventsWith(EventProcessor ... processors) {
        for (EventProcessor processor : processors) {
            this.consumerRepository.add(processor);
        }
        Sequence[] sequences = new Sequence[processors.length];
        for (int i = 0; i < processors.length; ++i) {
            sequences[i] = processors[i].getSequence();
        }
        this.ringBuffer.addGatingSequences(sequences);
        return new EventHandlerGroup<T>(this, this.consumerRepository, Util.getSequencesFor(processors));
    }

    @Deprecated
    public void handleExceptionsWith(ExceptionHandler<? super T> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setDefaultExceptionHandler(ExceptionHandler<? super T> exceptionHandler) {
        this.checkNotStarted();
        if (!(this.exceptionHandler instanceof ExceptionHandlerWrapper)) {
            throw new IllegalStateException("setDefaultExceptionHandler can not be used after handleExceptionsWith");
        }
        ((ExceptionHandlerWrapper)this.exceptionHandler).switchTo(exceptionHandler);
    }

    public ExceptionHandlerSetting<T> handleExceptionsFor(EventHandler<T> eventHandler) {
        return new ExceptionHandlerSetting<T>(eventHandler, this.consumerRepository);
    }

    @SafeVarargs
    public final EventHandlerGroup<T> after(EventHandler<T> ... handlers) {
        Sequence[] sequences = new Sequence[handlers.length];
        int handlersLength = handlers.length;
        for (int i = 0; i < handlersLength; ++i) {
            sequences[i] = this.consumerRepository.getSequenceFor(handlers[i]);
        }
        return new EventHandlerGroup<T>(this, this.consumerRepository, sequences);
    }

    public EventHandlerGroup<T> after(EventProcessor ... processors) {
        return new EventHandlerGroup<T>(this, this.consumerRepository, Util.getSequencesFor(processors));
    }

    public void publishEvent(EventTranslator<T> eventTranslator) {
        this.ringBuffer.publishEvent(eventTranslator);
    }

    public <A> void publishEvent(EventTranslatorOneArg<T, A> eventTranslator, A arg) {
        this.ringBuffer.publishEvent(eventTranslator, arg);
    }

    public <A> void publishEvents(EventTranslatorOneArg<T, A> eventTranslator, A[] arg) {
        this.ringBuffer.publishEvents(eventTranslator, arg);
    }

    public <A, B> void publishEvent(EventTranslatorTwoArg<T, A, B> eventTranslator, A arg0, B arg1) {
        this.ringBuffer.publishEvent(eventTranslator, arg0, arg1);
    }

    public <A, B, C> void publishEvent(EventTranslatorThreeArg<T, A, B, C> eventTranslator, A arg0, B arg1, C arg2) {
        this.ringBuffer.publishEvent(eventTranslator, arg0, arg1, arg2);
    }

    public RingBuffer<T> start() {
        this.checkOnlyStartedOnce();
        for (ConsumerInfo consumerInfo : this.consumerRepository) {
            consumerInfo.start(this.threadFactory);
        }
        return this.ringBuffer;
    }

    public void halt() {
        for (ConsumerInfo consumerInfo : this.consumerRepository) {
            consumerInfo.halt();
        }
    }

    public void shutdown() {
        try {
            this.shutdown(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.exceptionHandler.handleOnShutdownException(e);
        }
    }

    public void shutdown(long timeout, TimeUnit timeUnit) throws TimeoutException {
        long timeOutAt = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (this.hasBacklog()) {
            if (timeout < 0L || System.currentTimeMillis() <= timeOutAt) continue;
            throw TimeoutException.INSTANCE;
        }
        this.halt();
    }

    public RingBuffer<T> getRingBuffer() {
        return this.ringBuffer;
    }

    public long getCursor() {
        return this.ringBuffer.getCursor();
    }

    public long getBufferSize() {
        return this.ringBuffer.getBufferSize();
    }

    public T get(long sequence) {
        return this.ringBuffer.get(sequence);
    }

    public SequenceBarrier getBarrierFor(EventHandler<T> handler) {
        return this.consumerRepository.getBarrierFor(handler);
    }

    public long getSequenceValueFor(EventHandler<T> b1) {
        return this.consumerRepository.getSequenceFor(b1).get();
    }

    private boolean hasBacklog() {
        long cursor = this.ringBuffer.getCursor();
        return this.consumerRepository.hasBacklog(cursor, false);
    }

    public boolean hasStarted() {
        return this.started.get();
    }

    EventHandlerGroup<T> createEventProcessors(Sequence[] barrierSequences, EventHandler<? super T>[] eventHandlers) {
        this.checkNotStarted();
        Sequence[] processorSequences = new Sequence[eventHandlers.length];
        SequenceBarrier barrier = this.ringBuffer.newBarrier(barrierSequences);
        for (EventHandler<? super T> eventHandler : eventHandlers) {
            BatchEventProcessor<? super T> batchEventProcessor = new BatchEventProcessor<T>(this.ringBuffer, barrier, eventHandler);
            if (this.exceptionHandler != null) {
                batchEventProcessor.setExceptionHandler(this.exceptionHandler);
            }
            this.consumerRepository.add(batchEventProcessor, eventHandler, barrier);
            processorSequences[i] = batchEventProcessor.getSequence();
        }
        this.updateGatingSequencesForNextInChain(barrierSequences, processorSequences);
        return new EventHandlerGroup<T>(this, this.consumerRepository, processorSequences);
    }

    private void updateGatingSequencesForNextInChain(Sequence[] barrierSequences, Sequence[] processorSequences) {
        if (processorSequences.length > 0) {
            this.ringBuffer.addGatingSequences(processorSequences);
            for (Sequence barrierSequence : barrierSequences) {
                this.ringBuffer.removeGatingSequence(barrierSequence);
            }
            this.consumerRepository.unMarkEventProcessorsAsEndOfChain(barrierSequences);
        }
    }

    EventHandlerGroup<T> createEventProcessors(Sequence[] barrierSequences, EventProcessorFactory<T>[] processorFactories) {
        EventProcessor[] eventProcessors = new EventProcessor[processorFactories.length];
        for (int i = 0; i < processorFactories.length; ++i) {
            eventProcessors[i] = processorFactories[i].createEventProcessor(this.ringBuffer, barrierSequences);
        }
        return this.handleEventsWith(eventProcessors);
    }

    private void checkNotStarted() {
        if (this.started.get()) {
            throw new IllegalStateException("All event handlers must be added before calling starts.");
        }
    }

    private void checkOnlyStartedOnce() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Disruptor.start() must only be called once.");
        }
    }

    public String toString() {
        return "Disruptor{ringBuffer=" + this.ringBuffer + ", started=" + this.started + ", threadFactory=" + this.threadFactory + "}";
    }
}

