/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway;

import io.netty.buffer.ByteBuf;
import java.util.Queue;
import kcp.highway.Ukcp;
import kcp.highway.erasure.fec.Snmp;
import kcp.highway.internal.CodecOutputList;
import kcp.highway.threadPool.ITask;

public class ReadTask
implements ITask {
    private final Ukcp ukcp;

    public ReadTask(Ukcp ukcp) {
        this.ukcp = ukcp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        CodecOutputList<ByteBuf> bufList = null;
        Ukcp ukcp = this.ukcp;
        try {
            ByteBuf byteBuf;
            if (!ukcp.isActive()) {
                return;
            }
            long current = System.currentTimeMillis();
            Queue<ByteBuf> recieveList = ukcp.getReadBuffer();
            int readCount = 0;
            while ((byteBuf = recieveList.poll()) != null) {
                ++readCount;
                ukcp.input(byteBuf, current);
                byteBuf.release();
            }
            if (readCount == 0) {
                return;
            }
            if (ukcp.isControlReadBufferSize()) {
                ukcp.getReadBufferIncr().addAndGet(readCount);
            }
            long readBytes = 0L;
            if (ukcp.isStream()) {
                int size = 0;
                while (ukcp.canRecv()) {
                    if (bufList == null) {
                        bufList = CodecOutputList.newInstance();
                    }
                    ukcp.receive(bufList);
                    size = bufList.size();
                }
                for (int i = 0; i < size; ++i) {
                    ByteBuf byteBuf2 = bufList.getUnsafe(i);
                    readBytes += (long)byteBuf2.readableBytes();
                    this.readBytebuf(byteBuf2, current, ukcp);
                }
            } else {
                while (ukcp.canRecv()) {
                    ByteBuf recvBuf = ukcp.mergeReceive();
                    readBytes += (long)recvBuf.readableBytes();
                    this.readBytebuf(recvBuf, current, ukcp);
                }
            }
            Snmp.snmp.BytesReceived.add(readBytes);
            if (!ukcp.getWriteBuffer().isEmpty() && ukcp.canSend(false)) {
                ukcp.notifyWriteEvent();
            }
        }
        catch (Throwable e) {
            ukcp.internalClose();
            e.printStackTrace();
        }
        finally {
            this.release();
            if (bufList != null) {
                bufList.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBytebuf(ByteBuf buf, long current, Ukcp ukcp) {
        ukcp.setLastRecieveTime(current);
        try {
            ukcp.getKcpListener().handleReceive(buf, ukcp);
        }
        catch (Throwable throwable) {
            ukcp.getKcpListener().handleException(throwable, ukcp);
        }
        finally {
            buf.release();
        }
    }

    public void release() {
        this.ukcp.getReadProcessing().set(false);
    }
}

