/*
 * Decompiled with CFR 0.152.
 */
package kcp.highway;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import kcp.highway.erasure.fec.Snmp;

public class Crc32Decode
extends ChannelInboundHandlerAdapter {
    private CRC32 crc32 = new CRC32();

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof DatagramPacket) {
            DatagramPacket datagramPacket = (DatagramPacket)msg;
            ByteBuf data = (ByteBuf)datagramPacket.content();
            long checksum = data.readUnsignedIntLE();
            ByteBuffer byteBuffer = data.nioBuffer(data.readerIndex(), data.readableBytes());
            this.crc32.reset();
            this.crc32.update(byteBuffer);
            if (checksum != this.crc32.getValue()) {
                Snmp.snmp.getInCsumErrors().increment();
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }
}

